#include <stdio.h>
#include "math.h"
#include "tc_vars.h"
#include "hardware_t.h"
#include "flash_t.h"
#include "display_t.h"
#include "floatstr_t.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"

//#define _Debug_
//#define _Debug_IRQ_
//#define _Debug_QM_
//#define _Debug_FindZero_
//#define _Debug_AutoScale_
//#define _Debug_FindVoltage_
//#define _Debug_FindTimebase_
//#define _Debug_ZeroLevel_
//#define _Debug_Cursor_
//#define _Debug_Roll_Mode_
//#define _Debug_Memory_
//#define _Debug_USB_
//#define _Debug_FFT_

// Class Hardware
void Hardware::Init(void)						// Hardware Init Routine
{
	int x;
	unsigned long ChannelSign = 0;

	na_data_adr->np_piodata = 0x01;
	na_mode->np_piodata 	= 0x01;		//reset CH3 & CH4
	na_mode->np_piodata 	= 0x00;
	na_data_adr->np_piodata = 0x01;		// delay


#ifdef _Debug_
	printf("debug\r\n");
#endif

	//printf("Get number of channels\r\n");
	ChannelSign = READADC(3);

	if ((ChannelSign & 0xFFFF0000) == 0x12480000)
	{
		printf("4-Channels found Signature : %x\r\n", ChannelSign);
		NumberOfChannels = 4;
	}
	else
	{
		printf("2-Channels found Signature : %x\r\n", ChannelSign);
		NumberOfChannels = 2;
	}
	
	data_adr->np_piodata = 0x00;

	printf("Setup hardware\r");
	Setup_Hardware();	
	printf("Setup hardware 				- done\r\n");

	Read_Version();	
	printf("HW Version : %x  Channels : %d\r\n", tc_hw_version, NumberOfChannels);

	printf("Testing LEDs\r\n");
	//LED-test, 	BF
	for(x=0;x<16;x++)	//switch all LEDs off 	
	{ Reset_LED(x); }
	
	Set_LED(12);		//Run/Stop green
	//Set_LED(15);		//Single green

	//Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red

	for(x=0;x<12;x++)	//switch  LEDs on 
	{ Set_LED(x); }		
	
	//Reset_LED(12);
	//Reset_LED(15);
	//Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red
	
	nr_delay(5);
	Send_LED();
	nr_delay(200);

	//LED-test, 	BF
	for(x=0;x<16;x++)	//switch all LEDs off 	
	{ Reset_LED(x); }
	
	nr_delay(5);
	Send_LED();
	nr_delay(200);

	//Set_LED(12);		//Run/Stop green
	//Set_LED(15);		//Single green

	Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red

	for(x=0;x<12;x++)	//switch  LEDs on 
	{ Set_LED(x); }		
	
	//Reset_LED(12);
	//Reset_LED(15);
	//Set_LED(13);		//Run/Stop red
	Set_LED(14);		//Single red
	
	nr_delay(5);
	Send_LED();
	nr_delay(50);


	printf("Setup vars\r");
	Setup_Vars();
	printf("Setup vars 				- done\r\n");

	
	printf("Read protected config from flash\r");
	AMDFlash::Read_Protected_Flash();
	printf("Read protected config from flash	- done\r\n");



/*
//BF added
	//set LEDs depending on run mode
	if (Continius)
	{
		LED_ON[12] = 1;			                                        // Run/Stop Green
		LED_ON[13] = 0;			                                        // Run/Stop Red
		LED_ON[14] = 0;			                                        // Single Red
		LED_ON[15] = 0;			                                        // Single Green
	}
	else if(SingleMode)
	{
		LED_ON[12] = 0;			                                        // Run/Stop Green
		LED_ON[13] = 0;			                                        // Run/Stop Red
		LED_ON[14] = 0;			                                        // Single Red
		LED_ON[15] = 1;			                                        // Single Green
	}
	else
	{
		LED_ON[12] = 0;			                                        // Run/Stop Green
		LED_ON[13] = 1;			                                        // Run/Stop Red
		LED_ON[14] = 0;			                                        // Single Red
		LED_ON[15] = 1;								// Single Green
	}
*/
	Setup_Interrupts();					//enable all interupts

	key_reset->np_piodata = 0;				//reset keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;	

	key_int->np_pioedgecapture = 0;				// clear IRQ conditions		

	//-------------------------------------------------
	//BF add new ultra slow timebase mode
	//-------------------------------------------------
	if (USTB_Mode != USTB_OFF) 	//timebase > 200mS/Div?
	{
		Signal::USTB_Clear_Buffer();	//clear all buffers
		Reset_Timer2();
	}

}

void Hardware::Reset_the_Watchdog(void)					//Resets the WatchDog
{
	reset_watchdog->np_piodata = 0x00;			// Reset WatchDog
	reset_watchdog->np_piodata = 0x01;	
}
//#####################################################################################################################################
void Hardware::Start_Record(void)						
{
    //if (Test_Mode) return;

	//BF add 
	//Don't start new record if ADC is still running
	//if(adc_started) return;

	la_pulse->np_piodata = 0x01;				//stop record Port On
	la_pulse->np_piodata = 0x00;				//stop record Port Off	
	
	READADC(1);
	
	adc_started = true;
	start_acq->np_piodata = 0x01;				//start record Port On
	start_acq->np_piodata = 0x00;				//start record Port Off	
 	//printf("Start Record\r\n");
}
//#####################################################################################################################################
void Hardware::Stop_Record()							
{
    adc_started = false;
    la_pulse->np_piodata = 0x01;				//stop record Port On
    la_pulse->np_piodata = 0x00;				//stop record Port Off	

//    READADC(1);
 //printf("Stop Record\r\n");

}
//#####################################################################################################################################
void Hardware::Read_Version(void)					//Read the hardware version
{
    la_gate->np_piodata = 0x01;
    tc_hw_version = (unsigned long) la_data->np_piodata;
    la_gate->np_piodata = 0x00;
}
//#####################################################################################################################################
void Hardware::Setup_Vars(void)						// Set standard values for variables
{
	short ix, ix2, ix3;
    	int cnt;
	
	for (ix = 0;ix < 480;ix++)
	    Display_Line_Adresses[ix] = ix * 20;	//BF used in  Display::PIXELP()

/* BF del not used
	for (ix = 0;ix < 480;ix++)
	    Display_Line_Adresses2[ix] = ix * 80;
*/
/*BF del	
	for (ix = 0; ix <= 255; ix++) 
        for (ix2 = 0; ix2 < 6; ix2++) 
            for (ix3 = 0; ix3 < 9; ix3++)
                FIR_Tab_big[ix][ix2][ix3] = (short) FIR_Tabel[ix2][ix3] * ix;
*/
/*BF del
	for (ix = 0;ix < 32;ix++)
		LogicData[ix] = ix;
*/
/*BF del not used
	for (ix = 0;ix <= GRID_WIDTH;ix++) {	
	    SIGNAL1_SUM_MIN[ix] = 255;
	    SIGNAL1_SUM_MAX[ix] = 0;
	}
*/

	// BF -> changed Stefans initialization to 1 dimensional array
	for (cnt = 0; cnt < 1024; cnt++)
	SIGNAL_Histo[cnt] = 0;
	

	// delete signals
	for (cnt = 0; cnt < 0x4000; cnt++) {
		SIGNAL1[cnt] = ADC_ZERO;
		SIGNAL2[cnt] = ADC_ZERO;
		SIGNAL3[cnt] = ADC_ZERO;
		SIGNAL4[cnt] = ADC_ZERO;
	        SIGNALM[cnt] = ADC_ZERO;
	}	

	printf("Building trigonometric tables\r");
	Signal::FFT_BuildTrigoTables();						// BF insert - init FFT-data
	printf("Building trigonometric tables 		- done\r\n");

	MenuStored  = 0;
	MenuActive  = 0;
	MenuChanged = 0;
		
	IsPopuped   = 0;
	
	//Reset all LEDs	BF
//	for(cnt=0;cnt<16;cnt++)
//	{ Reset_LED(cnt); }

	led_status = 0x01;

	// Channel 1-4 on + Math off
	LED_ON[0] = 1;	
	LED_ON[1] = 1;
	LED_ON[2] = 1;
	LED_ON[3] = 1;	
	LED_ON[4] = 0;
	
	// General Wheel LED off
	LED_ON[5] = 0;	
	
	// Run Green LED On
	LED_ON[12] = 1;
	
	// Trigger edge On
	LED_ON[8] = 1;		

	
    	Cursor_Enabled = false;
	
	Cursor_Both_Selected_Old = 0;	
    	Cursor_Both_Selected = 0;	
	
	SelectedCursor = 0;
	SelectedCursorOld = 0;	
	
	CursorChanged = 0;
	
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Active_Old = 0; 	

	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	

	Cursor_Horizontal_Position1_Old = 103;
	Cursor_Horizontal_Position2_Old = 203;	

	Cursor_Vertical_Active = 0;
	Cursor_Vertical_Active_Old = 0;	

	Cursor_Vertical_Position_Real1 = 103;
	Cursor_Vertical_Position_Real2 = 203;	

	Cursor_Vertical_Position1_Old = 103;
	Cursor_Vertical_Position2_Old = 203;	

	Cursor_Vertical_Position_Real_XY_1 = 103;
	Cursor_Vertical_Position_Real_XY_2 = 203;	

	Cursor_Vertical_Position_XY_1_Old = 103;
	Cursor_Vertical_Position_XY_2_Old = 203;
	
    	QM_Enabled = false;
	QM_Changed[0] = 0;
	QM_Changed[1] = 0;
	QM_Changed[2] = 0;
	
	QM_Type[0] = 0;
	QM_Type[1] = 0;
	QM_Type[2] = 0;

	QM_Type_Old[0] = 0;
	QM_Type_Old[1] = 0;
	QM_Type_Old[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 3;
	QM_Horizontal_Active_Old = 3; 	

	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Horizontal_Position1_Old = 103;
	QM_Horizontal_Position2_Old = 203;	

	QM_Vertical_Active = 3;
	QM_Vertical_Active_Old = 3;	

	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	QM_Vertical_Position1_Old = 103;
	QM_Vertical_Position2_Old = 203;		

    	Quick_Measure_Threshold_btn_select = 1;

//BF not used	SelectedEdgeExtern = 0;

	Memory_Position = 0;	
	
	Selected_Trigger_Source     = 0;
	Selected_Trigger_Source_Old = 5;
	
	Selected_Timebase = 4;
	Timebase_Idx  = 4;       // Mu� vielleicht ins Flash
	
	dmode_Selected_Timebase = 0;
	dmode_Window_Offset_Pos = 0;
	
	TriggerWay = TRIG_EDGE;

	Timebase_Offset_Pos 	= 0;
	Timebase_Offset_Pos_Old = 0;

	//Trigger_Offset_Pos 	= 8192;		//BF not used
	//Trigger_Offset_Pos_Old = 8192;	//BF not used
    	
	Selected_Voltage_CH1 = 9;
	Selected_Voltage_CH2 = 9;
	Selected_Voltage_CH3 = 9;
	Selected_Voltage_CH4 = 9;
	Selected_TB = 0;	
	
	SwitchesCH1 = 0x00D5;
	SwitchesCH2 = 0x00D5;
	SwitchesCH3 = 0x00D5;
	SwitchesCH4 = 0x00D5;	
	SwitchesTB  = 0x0000;		

/*
	SwitchesCH1Old = 0x0000;
	SwitchesCH2Old = 0x0000;
	SwitchesCH3Old = 0x0000;
	SwitchesCH4Old = 0x0000;		
	SwitchesTBOld  = 0x0001;
*/
	ScreenShotActive = 0;	
	
	USB_Data_Trans  = 0;
	USB_SendAllData = 0;
	USB_OnlyTrigger = 0;
	Continius       = 1;
	SingleMode      = 0;	
	Single_Restart  = 0;
	
	ADC_Debug_Mode = false;
	Debug_Mode     = false;
	Command_Mode   = false;
	Calc_Mode      = false;
	ExtraTrg_Mode  = false;
	Search_Mode    = false;
	Search_Auto    = false;
	
	adc_started    = false;
	
	ctrl_reg     = 0x00A3;
	adc_ctrl_reg = 0x01C0;
	
	adc_del_reg = 0;
	pre_reg = 0x0000;
	//trg_val_reg = 0x00A0;
	//trg_hyst_reg = 0x0090;
	ext_trg_val_reg = 0x80;
	triggering = 0x00;
	trig_range_reg = 0;
	trig_width_reg = 0x0001;
	
	trg_val_CHI_reg   = 0x00A0;
	trg_val_CHII_reg  = 0x00A0;
	trg_val_CHIII_reg = 0x00A0;
	trg_val_CHIV_reg  = 0x00A0;
	
	trig_holdoff_reg = 0x00000000;

	timebase_reg = 0xFFFFFFFF;
	ram_adress_reg = 0;
//	test_port_reg = 0;
	
	CH1_DAC_Offset = 8192;
	CH2_DAC_Offset = 8192;
	CH3_DAC_Offset = 8192;
	CH4_DAC_Offset = 8192;

	VSync_Needed = 0;		// BF ?????????????????
	
	ClearPlane  = 0x00;
	DrawPlane   = 0x00;
	RemovePlane = 0x00;
	ClearPhase  = true;		// BF ?????????????????

	// Display settings
	GridColorArrayPos         = 1;                                          // Normal Grid 33 %
	GridColor_Val             = GridColorArray[GridColorArrayPos];     	// GridColor Gray
	
	Rotary_Direction           = 0;
	Rotary_Direction_mem       = 0;
	Rotary_Direction_mem_pulse = 1;
	Rotary_Switch              = 0;
	Rotary_Steps               = 1;
	Rotary_Changed             = 0;
	
	Keyboard_mem     = 0;
	Keyboard_Changed = 0;
	
	ADC_Data_Available = 0;

	SIGNAL_StartFr_idx = 0;
	SIGNAL_OFFSET 	   = 0;
	SIGNALFaktor_idx   = 0;	

/*BF del not used	
	FirEnabledCH1 = 0;		//BF?????????????
	FirEnabledCH2 = 0;		//BF?????????????
	FirEnabledCH3 = 0;		//BF?????????????
	FirEnabledCH4 = 0;		//BF?????????????
	
	//BF -> not used FirStartCH = 5;
	//BF -> not used FirStartCH_delayed = 5;
	
	SmoothEnabledCH1 = 0;
	SmoothEnabledCH2 = 0;
	SmoothEnabledCH3 = 0;
	SmoothEnabledCH4 = 0;
*/	
	USB_Data_Trans  = false;
	USB_SendAllData = false;
	USB_OnlyTrigger = false;
	
	ButtonChanged = false;
	RoteryChanged = false;
	
	DoDraw = false;
	
	PopUpPosition    = 0;
	IsPopuped        = false;
	PopupTimeCounter = 0;
	
	TriggerLevelChanged = 1;								// Was Triggerlevel changed
	TriggerModeChanged  = 1;								// Was Triggermode changed
	TriggerWayChanged   = 1;								// Was Triggerway changed
	TimebaseChanged     = 1;								// Was Timebase changed
	TimeOffsetChanged   = 1;								// Was Time_Offset changed
	SIGNALFaktorChanged = 1;								// Was SIGNALFaktor changed
	
	TriggerLevelActive = 0;								    	// Is Triggerlevel selected ?
	TimeOffsetActive   = 0;									// Is Time_Offset selected ?
	
	StatusbarChanged  = 0;									// When 1 then is changed
	ZeroPopupChanged  = 0;									// When 1 then is changed
	MenuPopupChanged  = 0;									// When 1 then is changed
	MenuPopupActive   = -1;									// Stores the actual Menupopup
	VoltageChangedCh1 = 1;									// Was Voltage changed
	VoltageChangedCh2 = 1;									// Was Voltage changed
	VoltageChangedCh3 = 1;									// Was Voltage changed
	VoltageChangedCh4 = 1;									// Was Voltage changed
	MenuPopupChanged2 = 0;									// Was MenuPopup changed
	MenuOnlyChanged  = 0;									// When 1 then is changed
	
	MenuItemChanged[0] = 0;
	MenuItemChanged[1] = 0;
	MenuItemChanged[2] = 0;
	MenuItemChanged[3] = 0;
	MenuItemChanged[4] = 0;
	MenuItemChanged[5] = 0;
	
	MenuItemPushed[0] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[1] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[2] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[3] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[4] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[5] = 0;				                    // When Menuitem is pushed drawed
	
	MenuStatusChanged = 0;									// When switching on/off a menu holds menunr
	
	VS_ZeroLevelChanged = 0;								// zero changed
	VS_TrigLevelChanged = 0;								// triggerlevel change
	
	MenuPopupX = 0;
	MenuPopupY = 0;
	MenuPopupSizeX = 0;
	MenuPopupSizeY = 0;
	
	MenuStored      = 0;
	MenuActive      = 18;		//Startmenu
	MenuActiveOld   = 0;
	MenuChanged     = true;
	MenuTimeCounter = 0;										// Counter for Menu Pulldown
	
	MenuItemCount    = 0;										// Store the count of the Menuitems
	MenuOldItemCount = 0;										// Store the count of the old Menuitems
	
	New_Menu     = -1;
	Active_Menu  = -1;
	Menu_Changed = -1;
	

	wheelchanged = 0;
	Rot_Summary  = 0;
	
	Memory_Position = 0;

	UI_request = 0;	

/*BF del not used
	//clear buffers
	for (cnt = 0; cnt < 32; cnt++)
	  LogicData[cnt] = 0;
*/	

}
//################################################################################################################################
void Hardware::Setup_Hardware(void)					// Setup the Hardware
{
	dma->np_piointerruptmask = 0x00;							// disable all IRQs
	dma->np_piodirection = 0x01;								// set all bits to output
	dma->np_piodata = 0x00;									// Set to 0

	serstartled->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartled->np_piodirection = 0x01;							// set all bits to output
	serstartled->np_piodata = 0x00;								// Set to 0

	serstartsw->np_piointerruptmask = 0x00;							// disable all IRQs
	serstartsw->np_piodirection = 0x01;							// set all bits to output
	serstartsw->np_piodata = 0x00;								// Set to 0

	serstartdac->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartdac->np_piodirection = 0x01;							// set all bits to output
	serstartdac->np_piodata = 0x00;								// Set to 0

	serdata->np_piointerruptmask = 0x00;							// disable all IRQs
	serdata->np_piodirection = 0xFF;							// set all bits to output
	serdata->np_piodata = 0x00;								// Set to 0

	key_reset->np_piointerruptmask = 0x00;							// disable all IRQs
	key_reset->np_piodirection = 0x01;							// set all bits to output
	key_reset->np_piodata = 0x01;								// Set to 1

	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piodata = 0x00;								// Set to 0

	key->np_piointerruptmask = 0x00;							// disable all IRQs
	key->np_piodirection = 0x00;								// set all bits to input
	key->np_piodata = 0x00;									// Set to 0

	rot_speed_read->np_piointerruptmask = 0x00;						// disable all IRQs
	rot_speed_read->np_piodirection = 0x01;							// set all bits to output
	rot_speed_read->np_piodata = 0x00;							// Set to 0

	data_adr->np_piointerruptmask = 0x00;							// disable all IRQs
	data_adr->np_piodirection = 0x01;							// set all bits to output
	data_adr->np_piodata = 0x00;								// Set to 0
	
	mode->np_piointerruptmask = 0x00;							// disable all IRQs
	mode->np_piodirection = 0x01;								// set all bits to output
	mode->np_piodata = 0x00;								// Set to 0
	
	start_acq->np_piointerruptmask = 0x00;							// disable all IRQs
	start_acq->np_piodirection = 0x01;							// set all bits to output
	start_acq->np_piodata = 0x00;								// Set to 0

	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	acq_ready->np_piodirection = 0x00;							// set all bits to input
	acq_ready->np_piodata = 0x00;								// Set to 0

	reset_watchdog->np_piointerruptmask = 0x00;						// disable all IRQs
	reset_watchdog->np_piodirection = 0x01;							// set all bits to output
	reset_watchdog->np_piodata = 0x00;							// Set to 0

	la_data->np_piointerruptmask = 0x00;							// disable all IRQs
	la_data->np_piodirection = 0x00;							// set all bits to input
	la_data->np_piodata = 0x00;								// Set to 0

	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
	la_interrupt->np_piodirection = 0x00;							// set all bits to input
	la_interrupt->np_piodata = 0x00;							// Set to 0

	la_gate->np_piointerruptmask = 0x00;							// disable all IRQs
	la_gate->np_piodirection = 0x01;							// set all bits to output
	la_gate->np_piodata = 0x00;									// Set to 0

	la_pulse->np_piointerruptmask = 0x00;							// disable all IRQs
	la_pulse->np_piodirection = 0x01;							// set all bits to output
	la_pulse->np_piodata = 0x00;								// Set to 0

	//out_test->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	//out_test->np_piodirection = 0x01;								// set all bits to output
	//out_test->np_piodata = 0x08;

	boot_reset_key->np_piointerruptmask = 0x00;						// disable all IRQs
	boot_reset_key->np_piodirection = 0x00;							// set all bits to input
	boot_reset_key->np_piodata = 0x00;							// Set to 0

	power_on_boot_key->np_piointerruptmask = 0x00;						// disable all IRQs
	power_on_boot_key->np_piodirection = 0x00;						// set all bits to input
	power_on_boot_key->np_piodata = 0x00;							// Set to 0
	
	//key_test->np_piointerruptmask = 0x00;							// disable all IRQs
	//key_test->np_piodirection = 0x00;							// set all bits to input
	//key_test->np_piodata = 0x00;			

    if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("No Keyboard selected\r\n");
        keyboard_found = 1;
    } 
	else if ((boot_reset_key->np_piodata == 0x01) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("Power on Boot Pressed\r\n");
        keyboard_found = 2;
    } 
	else if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x01)) {
        printf("Reset on Boot Pressed\r\n");
        keyboard_found = 3;
    } else {
        printf("Keyboard found\r\n");
        keyboard_found = 4;
    }

	triggering = 0;
}
//################################################################################################################################
void Hardware::Setup_Interrupts(void)					// Setup the Interrupts
{
	if (keyboard_found == 4)
	{
		DoEnableKeyInterrupt();
		DoEnableRotInterrupt();
	}
	
	DoEnableUARTInterrupt();
	DoEnableUART2Interrupt();
	DoEnableADCInterrupt();	
	DoEnableReadVSyncInterrupt();
	//    DoEnableLogicAnalyserInterrupt();
	DoEnableTimer1Interrupt();
	DoEnableTimer2Interrupt();
	DoEnableTimer3Interrupt();	
}

//################################################################################################################################
//BF #010
void Hardware::Disable_All_Interrupts(void)					// Disable the Interrupts
{
	if (keyboard_found == 4)
	{
		DoDisableKeyInterrupt();
		DoDisableRotInterrupt();
	}
	
	DoDisableUARTInterrupt();
	DoDisableUART2Interrupt();
	DoDisableADCInterrupt();	
	DoDisableReadVSyncInterrupt();
	//    DoDisableLogicAnalyserInterrupt();
	DoDisableTimer1Interrupt();
	DoDisableTimer2Interrupt();
	DoDisableTimer3Interrupt();	
}

//################################################################################################################################
void Hardware::Set_Vars_Default(void)					//Resets all vars to standard values
{
	int cnt;
	
	// Main/Delayed - Timebase
	MenuStatus[MENU_TIMEBASE][0] = 1;                               // Main
	MenuStatus[MENU_TIMEBASE][1] = 0;                               // Delayed
	MenuStatus[MENU_TIMEBASE][2] = 0;                               // XY-Mode
	MenuStatus[MENU_TIMEBASE][3] = 246;                     	// Roll-Mode 
	MenuStatus[MENU_TIMEBASE][4] = 246;                             // Shift-Mode
	MenuStatus[MENU_DISPLAY][2] = 136;                              // Display - Grid - 100%
	XY_Mode = 0;                                               	// Normal Mode - No XY-Mode
	USTB_Mode     = USTB_OFF;					// ultra slow timebase off	
	USTB_Mode_bak = USTB_ROLL;

	UI_request  = 0;						//BF flag for user interface activity
	QP_request  = 0;						//BF flag Quick Print requested
	ZL_changed  = 0;						//BF OnZero Channel -> only draw signal with changed zerolevel
	AS_request  = 0;						//BF auto scale requested
	RC_request  = 0;						//BF signal recall requested
	RC_overlay  = 0;

	test_signal = 0;						//BF test signal generator
	CRS_Delta   = 1;						//BF delta cursor on/off

	UART_NewData = 0;
	UART_RXData  = -1;


	MenuStatus[MENU_AUTOSCALE][1] = 240;                 		// Autoscale - Search Slow TBs
	
//BF ins	
	//Trig_Pos_Mem             = 300; 
	Trig_Pos_Display           = 300;
	Trig_Pos_Display_dmode     = 300;
	Trig_Pos_Zoom              = 1.0; 
	Trig_Pos_Mem               = 300;
	Trig_Pos_Mem_old           = 300;	
	Trig_Pos_Display_old       = 300;
	Trig_Pos_Display_dmode_old = 300;	
	Trig_Pos_Zoom_old          = 1.0;
	MemWinStart                = 0;
	MemWinStart_old            = -300;

// BF end
	
	dmode_Window_Offset_Pos = 0;

	SwitchesTB         = 0;                                         // timebase switches
	timebase_reg       = 0xFFFFFFFF;                                // fastest timebase
	Timebase_Idx   = 4;                                         	// Displayed timebase is 50 ns
	Selected_Timebase  = 4;                                         // 50 ns
	SIGNALFaktor_idx   = 0;                                         // non zoom
	SIGNAL_StartFr_idx = 0;                                         // running. so 0
	SIGNAL_OFFSET      = 0;                                         // signal offset
	
	Timebase_Offset_Pos = -300;//-298;                              // Timebase Offset
	Memory_Position     = 0;                               		// Memory Position
	
	dmode_Selected_Timebase = 0;                                    // delayed timebase is 20 ns
//BF del #003	dmode_SIGNALFaktor_idx = 0;                             // non zoom for delayed windows
	Timebase_Ratio = 0;                                             // factor for delayed windows cursor calculation
//BF del not used	dmode_SIGNAL_StartFr_idx = 0;                   // running. so 0
//BF del not used	dmode_SIGNAL_OFFSET = 0;                        // signal offset
	
	Cursor_Delayed_1    = 180;                                      // Delayed windows cursor position 1
	Cursor_Delayed_2    = 420;                                      // Delayed windows cursor position 2
	Cursor_Delayed_Size = 240;                                      // Delayed windows size
	

	// Trigger
	// Trigger Mode
	MenuStatus[MENU_TRIGGERMODE][0] = 92;                                         // Triggering - Auto
	MenuStatus[MENU_TRIGGERMODE][1] = 95;                                         // Triggering - Coupling DC
//BF no function #020	MenuStatus[MENU_TRIGGERMODE][2] = 97;                                         // Triggering - LF Reject
	MenuStatus[MENU_TRIGGERMODE][4] = 104;                                        // Triggering - External Probe 1:1
	
//BF del #020	MenuPopupStatus[9][0] = 3;
//BF del #020	MenuPopupStatus[9][1] = 2;
		
	EdgeToggle = 1;                                                 		// Holdoff deaktive
	
	// Trigger Edge
	MenuStatus[MENU_TRIGGEREDGE][0] = 2;                                          // Triggering - positive edge
	MenuStatus[MENU_TRIGGEREDGE][1] = 137;                                        // Triggering - Source = channel 1 #019
	MenuStatus[MENU_TRIGGEREDGE][2] = 246;                                        // Triggering - no externel triggering #019
	MenuStatus[MENU_TRIGGEREDGE][3] = 246;                                        // Triggering - no externel TV triggering #019
	Display::MenuPopupInit(28, MENU_TRIGGEREDGE, 137);	
	//init extern trigger menu #019
	MenuPopupStatus[8][0] = 3;
	MenuPopupStatus[8][1] = 2;
	MenuPopupStatus[8][2] = 2;
	//init TV trigger menu #019
	MenuPopupStatus[11][0] = 3;
	MenuPopupStatus[11][1] = 2;



	// Trigger Pulse
	MenuStatus[MENU_PULSEWIDTH][0] = 137;                                        // Triggering - Source Channel 1
	//MenuStatus[MENU_PULSEWIDTH][1] = 2;                                          // Triggering - Negative Pulse
	MenuStatus[MENU_PULSEWIDTH][2] = 3;                                          // Triggering - bigger - smaller - then
	
	// Quick Print
	//    MenuStatus[MENU_QUICKPRINT][0] = 241;                                        // quick Print - USB
	//    MenuStatus[MENU_QUICKPRINT][1] = 240;                                        // quick Print - RS-232
	
	Selected_Trigger_Source = 1;                                    	// Selected Trigger Source is Channel 1
//BF not used	SelectedEdgeExtern = 0;                                         // Trigger Edge by extern triggering
			
	//BF set zero levels to default
	if (NumberOfChannels == 2)
	{
		ZeroLevelCH1 = (int)(GRID_HEIGHT / 4);		// 1/4 grid height
		ZeroLevelCH2 = (int)((GRID_HEIGHT / 4) * 3);	// 3/4 grid height
		ZeroLevelCH3 = (int)(GRID_HEIGHT >> 1);	
		ZeroLevelCH4 = (int)(GRID_HEIGHT >> 1);
	}
	else
	{
		ZeroLevelCH1 = (int)(GRID_HEIGHT / 5.333);			//10% line
		ZeroLevelCH2 = (int)((GRID_HEIGHT / 8) * 3);			//third div
		ZeroLevelCH3 = (int)((GRID_HEIGHT / 8) * 5);			//fifth div
		ZeroLevelCH4 = (int)(GRID_HEIGHT - (GRID_HEIGHT / 5.333));	//90% line
	}

	ZeroLevelCH1_Old = ZeroLevelCH1;
	ZeroLevelCH2_Old = ZeroLevelCH2;
	ZeroLevelCH3_Old = ZeroLevelCH3;
	ZeroLevelCH4_Old = ZeroLevelCH4;

	Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2);	//Virtual zeroes are related to 1/2 grid height,
	Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2);	//means that VZero = 0 is the middle of the grid
	Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2);	
	Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2);
	
	Virtual_ZeroLevelXYCH1 = 0;	// 0 = middle of the grid
	Virtual_ZeroLevelXYCH2 = 0;	// 0 = middle of the grid
	Virtual_ZeroLevelXYCH3 = 0;	// 0 = middle of the grid	
	Virtual_ZeroLevelXYCH4 = 0;	// 0 = middle of the grid


	//BF set trigger levels
	Trigger_Pos_CH1 = ZeroLevelCH1;					// Trigger Level Channel 1
	Trigger_Pos_CH2 = ZeroLevelCH2;					// Trigger Level Channel 2
	Trigger_Pos_CH3 = ZeroLevelCH3;					// Trigger Level Channel 3
	Trigger_Pos_CH4 = ZeroLevelCH4;					// Trigger Level Channel 4
	Trigger_Pos_CHE = 56;						// Trigger Level Extern Trigger Source
	
	Trigger_Pos_CH1_Old = ZeroLevelCH1;
	Trigger_Pos_CH2_Old = ZeroLevelCH2;
	Trigger_Pos_CH3_Old = ZeroLevelCH3;
	Trigger_Pos_CH4_Old = ZeroLevelCH4;
	Trigger_Pos_CHE_Old = 56;	

	//trg_val_reg = 0xB1;                                       	// Trigger Value
	//trg_hyst_reg = 0xA9;                                		// Trigger Hysterese
	trg_val_CHI_reg   = 0x00A0;                                     // Trigger Level Register Channel 1
	trg_val_CHII_reg  = 0x00A0;                                     // Trigger Level Register Channel 2
	trg_val_CHIII_reg = 0x00A0;                                     // Trigger Level Register Channel 3
	trg_val_CHIV_reg  = 0x00A0;                                     // Trigger Level Register Channel 4
	ext_trg_val_reg   = 0x80;                             		// Triggr Level Register Extern Trigger (0.00V)
	
	trig_range_reg   = 0;                                  		// Trigger Range
	trig_holdoff_reg = 0;                  				// Trigger Holdoff
	trig_width_reg   = 0;                                   	// Trigger Width
	pre_reg          = 0x6C;    					// PreTrigger Value

//--------------------------------------------------------------------------------------------------------------------------------
	ctrl_reg         = 0x0007;                                        // Control register
	adc_ctrl_reg     = 0x81C0;		                          // ADC Control register - Auto Slope detect off

//BF ???	ctrl_reg     = 0x00A3;
//BF ???	adc_ctrl_reg = 0x01C0;
//------------------------------------------------------------------------------------------------------------------------------
	triggering = 1;                                                 // Triggering - Free Run
	TriggerWay = TRIG_EDGE;                                         // Edge
	Continius  = 1;                                                 // Continius Running
	
	HoldOff_Value = 0;
	HoldOff_Expo  = 1;   //ns
	HoldOff_Steps = 40;
	
	Pulse11_Value = 16;
	Pulse11_Expo  = 1;   //ns
	Pulse11_Steps = 8;
	
	Pulse12_Value = 8;
	Pulse12_Expo  = 1;   //ns
	Pulse12_Steps = 8;
	
	Pulse21_Value = 16;
	Pulse21_Expo  = 1;   //ns
	Pulse21_Steps = 8;
	
	Pulse22_Value = 16;
	Pulse22_Expo  = 1;   //ns
	Pulse22_Steps = 8;

	math_scale     = 11;	//BF added -> 5V default
	math_mul_scale = 177;	//BF -> 5V
	math_sub_scale = 161;	//BF -> 5V 
	math_add_scale = 161;	//BF -> 5V
	
	//BF added for new offset calculation
	Math_Offset     = 0;
	Math_Mul_Offset = 0;
	Math_Sub_Offset = 0;
	Math_Add_Offset = 0;
	
	Math_Offset_mul.Init(0.000001, 0.000001, 1000, 0.000001, 2, 3, "", "", "V");
	Math_Offset_mul.RenderText();
	Math_Offset_add.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_add.RenderText();
	Math_Offset_sub.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_sub.RenderText();

	// Channel 1
	Channel_1_Active = 1;                                           // Channel 1 active
//BF del	Channel_1_Active_Old = 0;                                       // Channel 1 old must be 0
	Channel_1_Active_bak = 1;                                       // Channel 1 backup
	MenuStatus[MENU_CHANNEL1][0] = 8;                               // Channel 1 - Coupling AC
	MenuStatus[MENU_CHANNEL1][1] = 240;                             // Channel 1 - BW Limit off
	MenuStatus[MENU_CHANNEL1][2] = 240;                             // Channel 1 - Invert off
	MenuStatus[MENU_CHANNEL1][3] = 104;                             // Channel 1 - Probe 1.0 : 1
	
	MenuPopupStatus[13][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[13][1] = 2;
	MenuPopupStatus[13][2] = 3;
	
	SwitchesCH1 = 0x0F1A;                                           // Switches for Channel 1 and for the other the AC bit
	Selected_Voltage_CH1 = 11;                                      // Voltage 5V
	
	// Channel2
	Channel_2_Active = 1;                                           // Channel 2 active
//BF del	Channel_2_Active_Old = 0;                                       // Channel 2 old must be 0
	Channel_2_Active_bak = 1;                                       // Channel 2 backup
	MenuStatus[MENU_CHANNEL2][0] = 8;                               // Channel 2 - Coupling AC
	MenuStatus[MENU_CHANNEL2][1] = 240;                             // Channel 2 - BW Limit off
	MenuStatus[MENU_CHANNEL2][2] = 240;                             // Channel 2 - Invert off
	MenuStatus[MENU_CHANNEL2][3] = 104;                             // Channel 2 - Probe 1.0 : 1
	
	MenuPopupStatus[14][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[14][1] = 2;
	MenuPopupStatus[14][2] = 3;
	
	SwitchesCH2 = 0x001A;                                           // Switches for Channel 2
	Selected_Voltage_CH2 = 11;                                      // Voltage 5V
	
	if (NumberOfChannels == 4)
	{
		// Channel 3
		Channel_3_Active = 1;                                           // Channel 3 active
//BF del		Channel_3_Active_Old = 0;                                       // Channel 3 old must be 0
		Channel_3_Active_bak = 1;                                       // Channel 3 backup
		MenuStatus[MENU_CHANNEL3][0] = 8;                               // Channel 3 - Coupling AC
		MenuStatus[MENU_CHANNEL3][1] = 240;                             // Channel 3 - BW Limit off
		MenuStatus[MENU_CHANNEL3][2] = 240;                             // Channel 3 - Invert off
		MenuStatus[MENU_CHANNEL3][3] = 104;                             // Channel 3 - Probe 1.0 : 1
	
		MenuPopupStatus[15][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 2;
		MenuPopupStatus[15][2] = 3;
	
		SwitchesCH3 = 0x001A;                                           // Switches for Channel 3
		Selected_Voltage_CH3 = 11;                                      // Voltage 5V
	
		// Channel 4
		Channel_4_Active = 1;                                           // Channel 4 active
//BF del		Channel_4_Active_Old = 0;                                       // Channel 4 old must be 0
		Channel_4_Active_bak = 1;                                       // Channel 4 backup
		MenuStatus[MENU_CHANNEL4][0] = 8;                           	// Channel 4 - Coupling AC
		MenuStatus[MENU_CHANNEL4][1] = 240;                         	// Channel 4 - BW Limit off
		MenuStatus[MENU_CHANNEL4][2] = 240;                         	// Channel 4 - Invert off
		MenuStatus[MENU_CHANNEL4][3] = 104;                         	// Channel 4 - Probe 1.0 : 1
	
		MenuPopupStatus[16][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 2;
		MenuPopupStatus[16][2] = 3;
	
		SwitchesCH4 = 0x001A;                                           // Switches for Channel 4
		Selected_Voltage_CH4 = 11;                                      // Voltage 5V
	}
	else
	{
		// Channel 3
		Channel_3_Active = 0;                                           // Channel 3 inactive
		Channel_3_Active_bak = 0;
//BF del		Channel_3_Active_Old = 0;                                       // Channel 3 old must be 0

		// Channel 4
		Channel_4_Active = 0;                                           // Channel 4 inactive
		Channel_4_Active_bak = 0;
//BF del		Channel_4_Active_Old = 0;                                       // Channel 4 old must be 0
	}


	Channel_Math_Active = 0;                                        	// Math channel off
	MenuStatus[MENU_MATH][1] = 0;                                          	// standart math FFT off
	MenuStatus[MENU_MATH][2] = 0;                                          	// standart math 1*2 off
	MenuStatus[MENU_MATH][3] = 1;                                          	// standart math 1-2 on
	MenuStatus[MENU_MATH][4] = 0;                                          	// standart math 1+2 off

	math_mul_scale = 177;							//5V	math scaling default setting
	math_sub_scale = 161;							//5V	math scaling default setting
	math_add_scale = 161;							//5V	math scaling default setting
 
	MenuStatus[MENU_FFT][0] = 137;                                          // source = channel 1
	MenuStatus[MENU_FFT][1] = 193;                                          // window = rectangle
	MenuStatus[MENU_FFT][2] = 66;                                          	// mode   = linear
	MenuStatus[MENU_FFT][3] = 83;                                          	// length = 512
	
	FFT_Mode    = FFT_OFF;							// FFT off
	FFT_NewData = 0;
	FFT_Length  = FFT_512;
	FFT_Level   = 9;							// FFT_Level = ld(FFT_Length)
	FFT_Windex  = -1;							// FFT window index default is rect
	FFT_Scale   = 2;
	
	MenuStatus[MENU_HARDWARE][1] = GainIdx + 230;			//Set gain menu 

	// Cursors
	MenuStatus[MENU_CURSOR][0] = 27;                                         // Cursor soruce = channel 1
	
	Cursor_Enabled = false;
	Cursor_Both_Selected = 0;	
	SelectedCursor = 0;
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	
	Cursor_Vertical_Active = 0;
	Cursor_Vertical_Position_Real1 = 103;
	Cursor_Vertical_Position_Real2 = 203;	
	Cursor_Vertical_Position_Real_XY_1 = 103;
	Cursor_Vertical_Position_Real_XY_2 = 203;	
		

    	// Quick Measure
	QM_Enabled = false;
	
	QM_Type[0] = 5;
	QM_Type[1] = 8;
	QM_Type[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 0;
	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Vertical_Active = 0;
	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	Quick_Measure_Threshold_btn_select = 1;
	
	// Display settings
	GridColorArrayPos         = 1;                                          // Normal Grid 33 %
	GridColor_Val             = GridColorArray[GridColorArrayPos];     	// GridColor Gray
	//BF not used GridColorArrayPos_Delayed = 1;                                  	// Delayed Grid 33 %
	//BF not used GridColor_Val_Delayed     = 0x15;                               	// GridColore Gray

 	MenuStatus[MENU_DISPLAY][0] = 240;                                         // Display - Persist off
	MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;                     // Display - Grid 33%
	MenuStatus[MENU_DISPLAY][3] = 241;                                         // Display - Vectors on
	MenuStatus[MENU_TIMEBASE][5] = 240;                                        // Timebase - Browse off

	// Aquire
	MenuStatus[MENU_ACQUIRE][0] = 1;					// Aquire - Normal on
	MenuStatus[MENU_ACQUIRE][1] = 0;					// Aquire - Averaging
	MenuStatus[MENU_ACQUIRE][2] = 0;					// no noise suppression

	// LEDs
	LED_ON[0] = 1;			                                        // Select Channel 1
	LED_ON[1] = 1;			                                        // Select Channel 2
	LED_ON[2] = 1;			                                        // Select Channel 3
	LED_ON[3] = 1;			                                        // Select Channel 4
	LED_ON[4] = 0;			                                        // Select Channel Math
	LED_ON[5] = 1;			                                        // General
	LED_ON[6] = 0;			                                        // Cursor
	LED_ON[7] = 0;			                                        // Quick Measure
	LED_ON[8] = 1;			                                        // Edge
	LED_ON[9] = 0;			                                        // Pattern - Not Used
	LED_ON[10] = 0;			                                        // Pulse Width
	LED_ON[11] = 0;			                                        // More - Not Used
	LED_ON[12] = 1;			                                        // Run/Stop Green
	LED_ON[13] = 0;			                                        // Run/Stop Red
	LED_ON[14] = 0;			                                        // Single Red
	LED_ON[15] = 0;			                                        // Single Green
	
	MenuItemChanged[0] = true;
	MenuItemChanged[1] = true;
	MenuItemChanged[2] = true;
	MenuItemChanged[3] = true;
	MenuItemChanged[4] = true;
	MenuItemChanged[5] = true;
	
	RemovePlane |= 0x1F;
	
	ClearPlanes();
		
}
//#############################################################################################################################################
char Hardware::SearchZero(char channel, char level, int *DAC_Offset, int *ZeroSign)
{
	
	int lcnt = 0;
	//BF del int lcnt2 = 0;
	unsigned long buflong = 0, buflong1 = 0;//, buflong2 = 0;
	//char is_running = 1;

#ifdef _Debug_FindZero_
    	printf("Start searching zero %d\n", channel);
    
    	printf("ZeroSign %8x %d\n", ZeroSign[0], ZeroSign[0]);
#endif
	
	lcnt = 0;
	DAC_Offset[0] = 0x2000;		//8192
	//is_running = 1;
	
	SetDacOffset(channel);
	SetSwitches(channel, level);
	
	triggering = 0;								
	ctrl_reg = 0x0083;							        // Trigger_Master / Trigger_INT / Free Run  / Zero Line search bit
	if (NumberOfChannels == 2) adc_ctrl_reg = 0x00C0;				// Disable Trigger sources and remove the master bits
	else  adc_ctrl_reg = 0x0000;						        // Remove the master bits
	
	switch (channel)
	{
		case 1 : adc_ctrl_reg |= 0x0100; break;                     // Set channel 1 Master bit
		case 2 : adc_ctrl_reg |= 0x0200; break;                     // Set channel 2 Master bit
		case 3 : adc_ctrl_reg |= 0x0400; break;                     // Set channel 3 Master bit
		case 4 : adc_ctrl_reg |= 0x0800; break;                     // Set channel 4 Master bit
	}

	SetupADC();
	
	nr_delay(100);
	
	ctrl_reg = 0x0183;                                               // Add zero_line_adj
	
	SetupADC();

	buflong = 0x00000000;
	if (channel < 3)	// Channel 1 & 2
	{
		
		while (1 == 1)
		{
			data_adr->np_piodata = 0x01;
			
			buflong = READADC(1);
			//printf("buflong %8x %d\n", buflong, buflong);
			if ((buflong & 0x00008000) == 0x00008000)
			{
			
				buflong1 = READADC(1) & 0x3FFF;
							
				ZeroSign[0] = (int) (buflong1 - 8192);		// Wertübergabe an NIOS
			
		//          printf("buflong_ch1 %8x %d\n", buflong, buflong);
		          	//printf("buflong1 %8x %d\n", buflong1, buflong1);
				printf("Channel %d ZeroSign %d\n", channel, ZeroSign[0]);	
				break;
			}
			
			data_adr->np_piodata = 0x00;
			lcnt++;
			
			if (lcnt == 50000) break;
		}
	}
	else	// Channel 3 & 4
	{
		lcnt = 0;
		while (1 == 1)		
		{
			data_adr->np_piodata = 0x01;

			buflong = READADC(3);

			buflong = READADC(1);	
			
			if ((buflong & 0x00008000) == 0x00008000)
			{
				buflong1 = READADC(3) & 0x3FFF;
								
				ZeroSign[0] = (int)buflong1 ;	//(buflong1 - 8192);//BF test
				
				printf("Channel %d ZeroSign %d\n", channel, ZeroSign[0]);	
				break;
			}
			
			data_adr->np_piodata = 0x00;
			lcnt++;
			if (lcnt == 50000) break;
		}
	}
	lcnt = 0;
	data_adr->np_piodata = 0x00;


	//buflong2 = READADC(channel);
	    
#ifdef _Debug_FindZero_
	printf("buflong %8x %d\n", buflong, buflong);
	printf("buflong1 %8x %d\n", buflong1, buflong1);
	//printf("buflong2 %8x %d\n", buflong2, buflong2);
	printf("ZeroSign %8x %d\n", ZeroSign[0], ZeroSign[0]);
  //  printf("%i %i : dir : %i lcnt : %i  BB : %i  BT : %i CZSO : %i \n", channel, level, dir, lcnt, bottom_val, top_val, ZeroSign[0]);
#endif

	ctrl_reg = 0x0083;	// Trigger_Master / Trigger_INT / FreeRun bit  /
	SetupADC();


	return 0;
}
//#############################################################################################################################################
char Hardware::SearchZeros(void)
{
	char IsSearching = true;
	int searchcnt = 0;
	char lChannel_1_bak, lChannel_2_bak, lChannel_3_bak, lChannel_4_bak;
	
	if ((Search_Mode == false) && (Search_Auto == false)) return 0;

	Stop_Record();
	AutoTimerOff = true;
	
	//reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
	#ifdef _Debug_FindZero_
	printf("We start searching\n");
	#endif
		
	DoDisableUARTInterrupt();
	DoDisableADCInterrupt();
	
	//    if (Search_Auto == false)
	//    {
		Display::DRAWROUNDBUTTON(230, 180, 180, 80, 0, 0);
		Display::TEXTOUTxvbig("Searching zero lines.", 247, 192, 1, UI_Plane2);
		Display::TEXTOUTxvbig("Remove all inputs.", 247, 212, 1, UI_Plane2);
		Display::TEXTOUTxvbig("Can take up to 1 min.", 247, 232, 1, UI_Plane2);
	//    }
	
	// Backup old vars
	lChannel_1_bak = Channel_1_Active;
	lChannel_2_bak = Channel_2_Active;
	lChannel_3_bak = Channel_3_Active;
	lChannel_4_bak = Channel_4_Active;
	
	Selected_Timebase_bak  = Selected_Timebase;
	SIGNALFaktor_idx_bak   = SIGNALFaktor_idx;
	SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
	timebase_reg_bak       = timebase_reg;
	Timebase_Idx_bak   = Timebase_Idx;
	Continius_bak          = Continius;
	SingleMode_bak         = SingleMode;
	
	triggering_bak   = triggering;
	ctrl_reg_bak     = ctrl_reg;
	adc_ctrl_reg_bak = adc_ctrl_reg;
	
	// backup settings
	CH1_DAC_Offset_bak = CH1_DAC_Offset;
	CH2_DAC_Offset_bak = CH2_DAC_Offset;
	CH3_DAC_Offset_bak = CH3_DAC_Offset;
	CH4_DAC_Offset_bak = CH4_DAC_Offset;
	
	CH1_DAC_Offset = 8192;	//Range middle
	CH2_DAC_Offset = 8192;
	CH3_DAC_Offset = 8192;
	CH4_DAC_Offset = 8192;
	
	
	Channel_1_Active = true;
	Channel_2_Active = true;
	
	if (NumberOfChannels > 2)
	{
		Channel_3_Active = true;
		Channel_4_Active = true;
	}
	
	Continius = 0;
	//   SingleMode = 1;
	
	if (adc_started)
	{
		while (acq_ready->np_piodata == 0x01)
		{}
		adc_started = false;
	}
	
	Selected_Timebase = 4;                                          // 50 nS
	SIGNALFaktor_idx = 0;                                           // zoom factor 0
	SIGNAL_StartFr_idx = 0;                                         // running. so 0
	
	timebase_reg = 0xFFFFFFFF;                                      // real timebase 50ns (1GSa/s)
	Timebase_Idx = 4;                                           // Displayed timebase is 50ns
	
	// start condition made -> start searching

	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
	
		IsSearching = SearchZero(1, 9, &CH1_DAC_Offset, &DAC_Correction[0][0]);	//channel 1 correction for 1er Ranges
	}
	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
		IsSearching = SearchZero(1, 10, &CH1_DAC_Offset, &DAC_Correction[0][1]);//channel 1 correction for 2er Ranges
	}
	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
		IsSearching = SearchZero(1, 11, &CH1_DAC_Offset, &DAC_Correction[0][2]);//channel 1 correction for 5er Ranges
	}
	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
		IsSearching = SearchZero(2, 9, &CH2_DAC_Offset, &DAC_Correction[1][0]);	//channel 2 correction for 1er Ranges
	}
	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
		IsSearching = SearchZero(2, 10, &CH2_DAC_Offset, &DAC_Correction[1][1]);//channel 2 correction for 2er Ranges
	}
	searchcnt = 0;
	IsSearching = true;
	while (IsSearching)
	{
		searchcnt++;
		if (searchcnt == 3) break;
		IsSearching = SearchZero(2, 11, &CH2_DAC_Offset, &DAC_Correction[1][2]);//channel 2 correction for 5er Ranges
	}
	
	if (NumberOfChannels > 2)
	{
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(3, 9, &CH3_DAC_Offset, &DAC_Correction[2][0]);//channel 3 correction for 1er Ranges
		}
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(3, 10, &CH3_DAC_Offset, &DAC_Correction[2][1]);//channel 3 correction for 2er Ranges
		}
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(3, 11, &CH3_DAC_Offset, &DAC_Correction[2][2]);//channel 3 correction for 5er Ranges
		}
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(4, 9, &CH4_DAC_Offset, &DAC_Correction[3][0]);//channel 4 correction for 1er Ranges
		}
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(4, 10, &CH4_DAC_Offset, &DAC_Correction[3][1]);//channel 4 correction for 2er Ranges
		}
		searchcnt = 0;
		IsSearching = true;
		while (IsSearching)
		{
			searchcnt++;
			if (searchcnt == 3) break;
			IsSearching = SearchZero(4, 11, &CH4_DAC_Offset, &DAC_Correction[3][2]);//channel 4 correction for 5er Ranges
		}
	}
		
	//restore settings
	Channel_1_Active = lChannel_1_bak;
	Channel_2_Active = lChannel_2_bak;
	Channel_3_Active = lChannel_3_bak;
	Channel_4_Active = lChannel_4_bak;
	
	Selected_Timebase  = Selected_Timebase_bak;
	SIGNALFaktor_idx   = SIGNALFaktor_idx_bak;
	SIGNAL_StartFr_idx = SIGNAL_StartFr_idx_bak;
	timebase_reg       = timebase_reg_bak;
	Timebase_Idx   = Timebase_Idx_bak;
	Continius          = Continius_bak;
	SingleMode         = SingleMode_bak;
	
	triggering   = triggering_bak;
	ctrl_reg     = ctrl_reg_bak;
	adc_ctrl_reg = adc_ctrl_reg_bak;
	
	CH1_DAC_Offset = CH1_DAC_Offset_bak;
	CH2_DAC_Offset = CH2_DAC_Offset_bak;
	CH3_DAC_Offset = CH3_DAC_Offset_bak;
	CH4_DAC_Offset = CH4_DAC_Offset_bak;
	
	
	Rotary_Steps = 0;
	UserIF::UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::UserIF::ON_Zero_Channel_2();
	
	
	SetSwitches(1, Selected_Voltage_CH1);
	SetSwitches(2, Selected_Voltage_CH2);
	
	SetDacOffset(1);
	SetDacOffset(2);
	
	//4 channel version
	if (NumberOfChannels > 2)
	{
		Rotary_Steps = 0;
		UserIF::UserIF::ON_Zero_Channel_3();
		Rotary_Steps = 0;
		UserIF::UserIF::ON_Zero_Channel_4();
	
		SetSwitches(3, Selected_Voltage_CH3);
		SetSwitches(4, Selected_Voltage_CH4);

		SetDacOffset(3);
		SetDacOffset(4);

	}
	
	SetupADC();
	
	SingleMode = 0;
	Continius = 1;
	
	Search_Mode = 0;
	Search_Auto = 0;



// BF ????????????????????? 
   /*
//    if (USB_Data_Trans == 1)
    {
        send_buffer[0] = (unsigned char) 13;
        send_buffer[1] = (unsigned char) (CH1_DAC_Offset & 0xFF);
        send_buffer[2] = (unsigned char) ((CH1_DAC_Offset & 0xFF00) >> 8);
        send_buffer[3] = (unsigned char) (CH1_DAC_Correction_1 & 0xFF);
        send_buffer[4] = (unsigned char) ((CH1_DAC_Correction_1 & 0xFF00) >> 8);
        send_buffer[5] = (unsigned char) (CH1_DAC_Correction_2 & 0xFF);
        send_buffer[6] = (unsigned char) ((CH1_DAC_Correction_2 & 0xFF00) >> 8);
        send_buffer[7] = (unsigned char) (CH1_DAC_Correction_3 & 0xFF);
        send_buffer[8] = (unsigned char) ((CH1_DAC_Correction_3 & 0xFF00) >> 8);
        send_buffer[9] = (unsigned char) (CH2_DAC_Offset & 0xFF);
        send_buffer[10] = (unsigned char) ((CH2_DAC_Offset & 0xFF00) >> 8);
        send_buffer[11] = (unsigned char) (CH2_DAC_Correction_1 & 0xFF);
        send_buffer[12] = (unsigned char) ((CH2_DAC_Correction_1 & 0xFF00) >> 8);
        send_buffer[13] = (unsigned char) (CH2_DAC_Correction_2 & 0xFF);
        send_buffer[14] = (unsigned char) ((CH2_DAC_Correction_2 & 0xFF00) >> 8);
        send_buffer[15] = (unsigned char) (CH2_DAC_Correction_3 & 0xFF);
        send_buffer[16] = (unsigned char) ((CH2_DAC_Correction_3 & 0xFF00) >> 8);
        send_buffer[17] = (unsigned char) (CH3_DAC_Offset & 0xFF);
        send_buffer[18] = (unsigned char) ((CH3_DAC_Offset & 0xFF00) >> 8);
        send_buffer[19] = (unsigned char) (CH3_DAC_Correction_1 & 0xFF);
        send_buffer[20] = (unsigned char) ((CH3_DAC_Correction_1 & 0xFF00) >> 8);
        send_buffer[21] = (unsigned char) (CH3_DAC_Correction_2 & 0xFF);
        send_buffer[22] = (unsigned char) ((CH3_DAC_Correction_2 & 0xFF00) >> 8);
        send_buffer[23] = (unsigned char) (CH3_DAC_Correction_3 & 0xFF);
        send_buffer[24] = (unsigned char) ((CH3_DAC_Correction_3 & 0xFF00) >> 8);
        send_buffer[25] = (unsigned char) (CH4_DAC_Offset & 0xFF);
        send_buffer[26] = (unsigned char) ((CH4_DAC_Offset & 0xFF00) >> 8);
        send_buffer[27] = (unsigned char) (CH4_DAC_Correction_1 & 0xFF);
        send_buffer[28] = (unsigned char) ((CH4_DAC_Correction_1 & 0xFF00) >> 8);
        send_buffer[29] = (unsigned char) (CH4_DAC_Correction_2 & 0xFF);
        send_buffer[30] = (unsigned char) ((CH4_DAC_Correction_2 & 0xFF00) >> 8);
        send_buffer[31] = (unsigned char) (CH4_DAC_Correction_3 & 0xFF);
        send_buffer[32] = (unsigned char) ((CH4_DAC_Correction_3 & 0xFF00) >> 8);
        send_buffer[33] = (unsigned char) NumberOfChannels;

        CommIF::SendData(send_buffer);
    }
    */
/*
    printf("DAC1 : %i DAC2 : %i DAC3 : %i DAC4 : %i\n", CH1_DAC_Offset, CH2_DAC_Offset, CH3_DAC_Offset, CH4_DAC_Offset);
    printf("CH1_1 :%3d CH1_2 :%3d CH1_3 :%3d CH2_1 :%3d CH2_2 :%3d CH2_3 :%3d \n", CH1_DAC_Correction_1, CH1_DAC_Correction_2, CH1_DAC_Correction_3, CH2_DAC_Correction_1, CH2_DAC_Correction_2, CH2_DAC_Correction_3);
    printf("CH3_1 :%3d CH3_2 :%3d CH3_3 :%3d CH4_1 :%3d CH4_2 :%3d CH4_3 :%3d \n", CH3_DAC_Correction_1, CH3_DAC_Correction_2, CH3_DAC_Correction_3, CH4_DAC_Correction_1, CH4_DAC_Correction_2, CH4_DAC_Correction_3);
*/ 

   	config_changed = true;
	//BF del AMDFlash::Write_Config_Flash();

   
//BF	if (Search_Auto == false)
//BF	{
		Display::DRAWROUNDBUTTON(230, 180, 180, 80, 0, 1);
		Display::TEXTOUTxvbig("Searching zero lines.", 247, 192, 0, UI_Plane2);
		Display::TEXTOUTxvbig("Remove all inputs.", 247, 212, 0, UI_Plane2);
		Display::TEXTOUTxvbig("Can take up to 1 min.", 247, 232, 0, UI_Plane2);
//BF	}

	
	AutoTimerOff = false;
	
	DoEnableADCInterrupt();
	DoEnableUARTInterrupt();
	
	acq_ready->np_pioedgecapture = 0;
	Start_Record();
	
	//reset_watchdog->np_piodata = 0x01;						// Enable WatchDog
	
	return 0;
}
//#####################################################################################################################################

void Hardware::DoEnableKeyInterrupt(void)							// Enable Keyboard service routine
{
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piointerruptmask = 0x01;							// enable Keyboard IRQ

	key_reset->np_piodata = 0;								// Reset Keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;
	
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions	

	nr_installuserisr(na_key_interrupt_irq,ISR_KEY,(int)key_int);	// Install ISR for Keyboard
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nKEY interrupt enabled.\n"); 							// print on console
#endif
}
//#####################################################################################################################################

void Hardware::DoDisableKeyInterrupt(void)							// Disable Keyboard I/O service routine
{
	nr_installuserisr(na_key_interrupt_irq,0,0); 					// Install empty routine for Keyboard irq
	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
}
//#####################################################################################################################################

void Hardware::ISR_KEY(int context)									// Keyboard Interrupt subroutine
{
	int KeyData = key->np_piodata;									// Get interrupt Keyboad data
	
	ADC_Data_Available_cnt = 2; //BF -> ????? what for
	
	//acq_ready->np_piointerruptmask = 0x00;								// disable adc irq
		
	key_reset->np_piodata = 0;									// Reset Keyboard
	nr_delay(1);
	key_reset->np_piodata = 1;
	key_int->np_pioedgecapture = 0;									// clear IRQ conditions	
	
	Keyboard_mem = KeyData;
	Keyboard_Changed = 1;

	UI_request = 1;	
	
	if (SingleMode)
	{
		SingleMode = 0;
	
		LED_ON[14] = 0;
		LED_ON[15] = 0;
	}
	/*
	LED_ON[12] = 0;
	LED_ON[13] = 1;
	Send_LED();  */

	printf("\r\nKEY interrupt occured %x(%d).\r\n",KeyData,KeyData ); 				// print on console
}
//#####################################################################################################################################
// BF cleaned up unused variables
void Hardware::UpdateChannel(int channel, char active)
{
	char *lChannelPtr = 0;
	int x= 0;
	int pos = 0;
	int bufchannel = channel;
	char lednr = 0;
	
	switch(channel)
	{
		case 1:
		{
			lChannelPtr = &Channel_1_Active;
			lednr = 0;
			break;
		}	
		case 2:
		{
			lChannelPtr = &Channel_2_Active;
			lednr = 1;
			break;
		}
		case 3:
		{
			lChannelPtr = &Channel_3_Active;
			lednr = 2;
			break;
		}
		case 4:
		{
			lChannelPtr = &Channel_4_Active;
			lednr = 3;
			break;
		}
		case 5:
		{
			lChannelPtr = &Channel_Math_Active;
			lednr = 4;
			
			if (NumberOfChannels == 2) bufchannel = 3;
			break;
		}		
	}
						
	if (active == 1)
	{
		if (!*lChannelPtr) config_changed = true;			//Save new values to flash

		*lChannelPtr = 1;						//set actual channel active

		// BF FFT source is handled in FFT_Set_Channel() - don't handle it here!	
		// FFT Source
		
/*BF del #019
		// Edge Source
		if (MenuPopupStatus[28][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_TRIGGEREDGE][1] == 91)
			{
				MenuPopupStatus[28][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_TRIGGEREDGE][1] = 138 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[28][0 + (bufchannel - 1)] = 2;			
		} 		
*/

		// Edge Source #019
		if (MenuPopupStatus[28][bufchannel - 1] == 1)
		{ MenuPopupStatus[28][bufchannel - 1] = 2; } 		

		
		// Cursor Source
		if (MenuPopupStatus[1][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_CURSOR][0] == 91)
			{
				MenuPopupStatus[1][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_CURSOR][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[1][0 + (bufchannel - 1)] = 2;			
		}
		
		// Quick Measurement Source
		if (MenuPopupStatus[3][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_QUICKMEASURE][0] == 91)
			{
				MenuPopupStatus[3][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_QUICKMEASURE][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[3][0 + (bufchannel - 1)] = 2;			
		}		
		
		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_QMDELAY][0] == 91)
			{
				MenuPopupStatus[5][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_QMDELAY][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[5][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_QMDELAY][2] == 91)
			{
				MenuPopupStatus[6][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_QMDELAY][2] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[6][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[21][0] == 91)
			{
				MenuPopupStatus[24][0 + (bufchannel - 1)] = 3;
				MenuStatus[21][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[24][0 + (bufchannel - 1)] = 2;			
		}	
		
		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[21][2] == 91)
			{
				MenuPopupStatus[25][0 + (bufchannel - 1)] = 3;
				MenuStatus[21][2] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[25][0 + (bufchannel - 1)] = 2;			
		}		
		
		// Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_QMTHRESHOLDS][0] == 91)
			{
				MenuPopupStatus[26][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_QMTHRESHOLDS][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[26][0 + (bufchannel - 1)] = 2;			
		}			
		
		// Pulse Width Source BF -> MemuPopup	#019
		if (MenuPopupStatus[7][bufchannel - 1] == 1)
		{ MenuPopupStatus[7][bufchannel - 1] = 2; } 		

/*BF del
		if (MenuPopupStatus[7][0 + (bufchannel - 1)] == 1)
		{
			if (MenuStatus[MENU_PULSEWIDTH][0] == 91)
			{
				MenuPopupStatus[7][0 + (bufchannel - 1)] = 3;
				MenuStatus[MENU_PULSEWIDTH][0] = 27 + (bufchannel - 1);		
			}			
			else MenuPopupStatus[7][0 + (bufchannel - 1)] = 2;			
		}
*/		Set_LED(lednr);
	}
	else
	{
		if (*lChannelPtr) config_changed = true;			//Save new values to flash

		*lChannelPtr = 0;						// set actual channel inactive
		
		if ((Channel_Math_Active) && ((bufchannel == 1) || (bufchannel == 2)) && (MenuStatus[MENU_MATH][1] == 0))
		{
			Channel_Math_Active = 0;
			RemovePlane |= 0x10;
			ClearPlanes();	
			Reset_LED(4);		
		}
/*BF test del		
		// Switch from XY to Main if channels are not active
		if ((XY_Mode == 1) && ((bufchannel == 1) || (bufchannel == 2)))
		{
		    	MenuStatus[MENU_TIMEBASE][0] = 1;
			MenuStatus[MENU_TIMEBASE][2] = 246;
			XY_Mode = 0;	//Main

			// Draw main grid into gridplane
			Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);

			GridColor_Val = GridColorArray[GridColorArrayPos];
			SetupADC();
							
			MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		
		}
*/


		// BF FFT source is handled in FFT_Set_Channel() - don't handle it here!	
		// FFT Source

/*BF del #019
		// Edge Source
		if (MenuPopupStatus[28][0 + (bufchannel - 1)] == 3)
		{	
			MenuPopupStatus[28][0 + (bufchannel - 1)] = 1;
				
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[28][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[28][pos] = 3;
				MenuStatus[MENU_TRIGGEREDGE][1] = 138 + pos;
			}
			else
			{
				MenuStatus[MENU_TRIGGEREDGE][1] = 91;						//None
			}
		}
		else MenuPopupStatus[28][0 + (bufchannel - 1)] = 1;
*/
		// Edge Source BF #019
		if (MenuPopupStatus[28][bufchannel - 1] == 3)		//if actual channel was active source
		{	
			pos = -1;
			for (x = 0;x < 5;x++)				//search next available source
			{
				if (MenuPopupStatus[28][x] == 2)
				{ pos = x; break; }
			}

			if (pos > -1)
			{
				MenuPopupStatus[28][pos] = 3;
				MenuStatus[MENU_TRIGGEREDGE][1] = 137 + pos;
			}
		}
	
		MenuPopupStatus[28][bufchannel - 1] = 1;		//set source inactive



		//BF del Selected_Trigger_Source	= MenuStatus[MENU_TRIGGEREDGE][1] - 136;
		TriggerWayChanged = true;	
		TriggerLevelChanged = 1;
	
		Display::StatusUpdate();
		UpdateTrigger();
			
		// Cursor Source
		if (MenuPopupStatus[1][0 + (bufchannel - 1)] == 3)
		{	
			MenuPopupStatus[1][0 + (bufchannel - 1)] = 1;
				
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[1][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[1][pos] = 3;
				MenuStatus[MENU_CURSOR][0] = 27 + pos;
			}
			else
			{
				MenuStatus[MENU_CURSOR][0] = 91;						//None
			}
		}
		else MenuPopupStatus[1][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Source
		if (MenuPopupStatus[3][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[3][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 4;x++)
			{
				if (MenuPopupStatus[3][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[3][pos] = 3;
				MenuStatus[MENU_QUICKMEASURE][0] = 27 + pos;
			}
			else
			{
				MenuStatus[MENU_QUICKMEASURE][0] = 91;						//None
			}
		}
		else MenuPopupStatus[3][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[5][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[5][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[5][pos] = 3;
				MenuStatus[MENU_QMDELAY][0] = 27 + pos;
			}
			else
			{
				MenuStatus[MENU_QMDELAY][0] = 91;						//None
			}
		}
		else MenuPopupStatus[5][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[6][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[6][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[6][pos] = 3;
				MenuStatus[MENU_QMDELAY][2] = 27 + pos;
			}
			else
			{
				MenuStatus[MENU_QMDELAY][2] = 91;						//None
			}
		}
		else MenuPopupStatus[6][0 + (bufchannel - 1)] = 1;
		
        	// Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[24][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[24][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[24][pos] = 3;
				MenuStatus[21][0] = 27 + pos;
			}
			else
			{
				MenuStatus[21][0] = 91;						//None
			}
		}
		else MenuPopupStatus[24][0 + (bufchannel - 1)] = 1;
		
		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[25][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[25][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[25][pos] = 3;
				MenuStatus[21][2] = 27 + pos;
			}
			else
			{
				MenuStatus[21][2] = 91;						//None
			}
		}
		else MenuPopupStatus[25][0 + (bufchannel - 1)] = 1;		
		
        	// Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][0 + (bufchannel - 1)] == 3)
		{		
			MenuPopupStatus[26][0 + (bufchannel - 1)] = 1;
			
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[26][x] == 2)
				{
					pos = x;
					break;	
				}
			}
			if (pos > -1)
			{
				MenuPopupStatus[26][pos] = 3;
				MenuStatus[MENU_QMTHRESHOLDS][0] = 27 + pos;
			}
			else
			{
				MenuStatus[MENU_QMTHRESHOLDS][0] = 91;						//None
			}
		}
		else MenuPopupStatus[26][0 + (bufchannel - 1)] = 1;

		
		// Pulse Width Source  #019
		if (MenuPopupStatus[7][0 + (bufchannel - 1)] == 3)		//if actual channel was active source
		{		
			pos = -1;
			for (x = 0;x < 5;x++)					//search next available source
			{
				if (MenuPopupStatus[7][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[7][pos] = 3;
				MenuStatus[MENU_PULSEWIDTH][0] = 137 + pos;
			}
//BF del			else
//BF del			{ MenuStatus[MENU_PULSEWIDTH][0] = 91;	}					//None BF ????????????
			
		}	

		MenuPopupStatus[7][bufchannel - 1] = 1;		//set inactive
		
		Reset_LED(lednr);
	}	

/* BF del test	
	//reset trigger source
	MenuPopupStatus[28][0] = 2;
	MenuPopupStatus[28][1] = 2;
	
	if (NumberOfChannels > 2)
	{
		MenuPopupStatus[28][2] = 2;
		MenuPopupStatus[28][3] = 2;
	}
	//set new trigger source active
	if (MenuStatus[MENU_TRIGGEREDGE][1] == 137) MenuPopupStatus[28][0] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 138) MenuPopupStatus[28][1] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139) MenuPopupStatus[28][2] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140) MenuPopupStatus[28][3] = 3;
*/
	
	if (Cursor_Enabled)
	{
		CursorChanged = 3;
		Cursor_Data_First_Draw = 1;
		
		if(FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();
	
		Display::DRAWCURSORDATA(0);
	}

	// Check Measurements
	
	QM_Type_Old[0] = QM_Type[0];
	QM_Type_Old[1] = QM_Type[1];
	QM_Type_Old[2] = QM_Type[2];
	
	pos = -1;
	for (x = 0; x < 3; x++)
	{
		if (QM_Type[x] > 0)
		{
			if ((QM_Channel[x] == 1) && (Channel_1_Active == 0)) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 2) && (Channel_2_Active == 0)) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 3) && (Channel_3_Active == 0)) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 4) && (Channel_4_Active == 0)) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 5) && (Channel_Math_Active == 0)) { QM_Type[x] = 0; pos = 1; }
		}
	}

	if (pos == 1)
	{
		QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
	
	
		QM_Changed[0] = 0;
		QM_Changed[1] = 0;
		QM_Changed[2] = 0;
		QM_Changed[0] = 0;
		QM_Changed[1] = 0;
		QM_Changed[2] = 0;
	
		Quick_Measure_First_Draw = 1;
	
		New_Menu = 19;
		Menu_Changed = 1;
	}

    printf("********  Update channel %d done  ***********\r\n", bufchannel);
}
//#####################################################################################################################################################
//BF 
void Hardware::UpdateTrigger(void)
{
    	int trg_buf, p_mul_value;
	int lVirtual_Zero; 
    //if (AutoTimerOff) return;

	Selected_Trigger_Source_Old = Selected_Trigger_Source;
	
	adc_ctrl_reg &= 0xFFF0;
    //ctrl_reg &= 0xC17F;  // remove holdoff and pulse bits
    	ctrl_reg &= 0xC17D;  // remove holdoff and pulse bits and internal bit
    	
	if (HoldOff_Value)
	{
		trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
		ctrl_reg |= 0x2000;
	}
	else trig_holdoff_reg = 0x00000000;
                    	
  //  if (TriggerWay == 1)
    	{
		if (MenuStatus[MENU_TRIGGEREDGE][1] == 137)	//Source = channel 1
		{
			triggering = 1;
			ctrl_reg |= 0x0002;
			adc_ctrl_reg |= 0x0001;
				
			trg_val_CHI_reg = (int)((float)(Trigger_Pos_CH1 - (GRID_HEIGHT/2)) / scale_factor[Selected_Voltage_CH1][GainIdx]) + ADC_ZERO;	//Stefan

			trg_val_CHI_reg	= 255 - trg_val_CHI_reg;
				
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2)	//rising
			{ 	
				ctrl_reg |= 0x0004;
				if (Trigger_Pos_CH1 > ZeroLevelCH1)	//BF correction
				trg_val_CHI_reg += 10;			//BF correction
			}
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3)	//falling
			{ 	
				ctrl_reg &= 0xFFFB;
				if (Trigger_Pos_CH1 < ZeroLevelCH1)	//BF correction
				trg_val_CHI_reg -= 15;			//BF correction
				else
				trg_val_CHI_reg -= 5;			//BF correction
			}
		}
		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 138)	//Source = channel 2
		{
			triggering = 2;
			ctrl_reg |= 0x0002;
			adc_ctrl_reg |= 0x0002;
						
			trg_val_CHII_reg = (int)((float)(Trigger_Pos_CH2 - (GRID_HEIGHT/2)) / scale_factor[Selected_Voltage_CH2][GainIdx])+ADC_ZERO;	//Stefan
		
			trg_val_CHII_reg = 255 - trg_val_CHII_reg;
						
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2)	//rising
			{ 
				ctrl_reg |= 0x0004;
				if (Trigger_Pos_CH2 > ZeroLevelCH2)	//BF correction
				trg_val_CHII_reg += 10;			//BF correction
 			}
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3)	//falling
			{ 
				ctrl_reg &= 0xFFFB;
				if (Trigger_Pos_CH2 < ZeroLevelCH2)	//BF correction
				trg_val_CHII_reg -= 15;			//BF correction
				else
				trg_val_CHII_reg -= 5;			//BF correction
			 }
		}
		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139)	//Source = channel 3
		{
			triggering = 3;
			ctrl_reg |= 0x0002;
			adc_ctrl_reg |= 0x0004;
					
			trg_val_CHIII_reg = (int)((float)(Trigger_Pos_CH3 - (GRID_HEIGHT/2)) / scale_factor[Selected_Voltage_CH3][GainIdx])+ADC_ZERO;	//Stefan

			trg_val_CHIII_reg = 255 - trg_val_CHIII_reg;
						
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2)	//rising
			{ 
				ctrl_reg |= 0x0004;
				if (Trigger_Pos_CH3 > ZeroLevelCH3)	//BF correction
				trg_val_CHIII_reg += 10;		//BF correction
			}
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3)	//falling
			{ 
				ctrl_reg &= 0xFFFB;
				if (Trigger_Pos_CH3 < ZeroLevelCH3)	//BF correction
				trg_val_CHIII_reg -= 15;		//BF correction
				else
				trg_val_CHIII_reg -= 5;			//BF correction
			}
		}
		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140)	//Source = channel 4
		{
			triggering = 4;
			ctrl_reg |= 0x0002;
			adc_ctrl_reg |= 0x0008;
					
			trg_val_CHIV_reg = (int)((float)(Trigger_Pos_CH4 - (GRID_HEIGHT/2)) / scale_factor[Selected_Voltage_CH4][GainIdx])+ADC_ZERO;	//Stefan
		
			trg_val_CHIV_reg = 255 - trg_val_CHIV_reg;
						
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2)	//rising
			{
			 	ctrl_reg |= 0x0004;
				if (Trigger_Pos_CH4 > ZeroLevelCH4)	//BF correction
				trg_val_CHIV_reg += 10;			//BF correction
 			}
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3)	//falling
			{
				ctrl_reg &= 0xFFFB; 
				if (Trigger_Pos_CH4 < ZeroLevelCH4)	//BF correction
				trg_val_CHIV_reg -= 15;			//BF correction
				else
				trg_val_CHIV_reg -= 5;			//BF correction
			}
		}

//BF del		if (MenuStatus[MENU_TRIGGEREDGE][2] == 1)	//Source = extern
		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 141)	//Source = extern #019
		{
			triggering = 5;
						
			ctrl_reg &= 0xFFFD;
			adc_ctrl_reg &= 0xFFF0;
		
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2) ctrl_reg |= 0x0004;		//rising
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3) ctrl_reg &= 0xFFFB;	//falling
		
			SwitchesTB = 0x00;
/*BF test
			if (MenuPopupStatus[8][0] == 3) SwitchesTB = 0x40;		//LF Reject 
			else if (MenuPopupStatus[8][1] == 3) SwitchesTB = 0xC0;		//HF Reject
			else if (MenuPopupStatus[8][2] == 3) SwitchesTB = 0x80;		//Line
*/	
			//BF changed due to Jürgens recherche	
			if (MenuPopupStatus[8][0] == 3) SwitchesTB = 0xC0;		//LF Reject 
			else if (MenuPopupStatus[8][1] == 3) SwitchesTB = 0x80;		//HF Reject
			else if (MenuPopupStatus[8][2] == 3) SwitchesTB = 0x40;		//Line


			if (MenuStatus[MENU_TRIGGERMODE][1] == 95) SwitchesTB |= 0x04;	//AC/DC
			else SwitchesTB &= 0xFB;
										
			SetSwitches(5, SwitchesTB);

			if (MenuPopupStatus[8][2] == 3)					//Line
			ext_trg_val_reg = 0x80;						//BF set to zero
			else
			ext_trg_val_reg = ExtTriggerLevel[Trigger_Pos_CHE];

			//printf("Trigger_Pos_CHE %d\n\r", Trigger_Pos_CHE);
			//printf("trigger extern level %d \n\r", ext_trg_val_reg);

			serdata->np_piodata = ext_trg_val_reg;
			serstartpwm->np_piodata = 1;
			serstartpwm->np_piodata = 0;
		}
        
//BF del		if (MenuStatus[MENU_TRIGGEREDGE][3] == 1)			//TV Ch1
		else if (MenuStatus[MENU_TRIGGEREDGE][1] == 142)		//TV Ch1 #019
		{
			triggering = 5;
						
			ctrl_reg &= 0xFFFD;
			adc_ctrl_reg &= 0xFFF0;
		
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2) ctrl_reg |= 0x0004;		//rising/falling
			else if (MenuStatus[MENU_TRIGGEREDGE][0] == 3) ctrl_reg &= 0xFFFB;	//rising/falling
		
			SwitchesTB = 0x00;
			
			if (MenuPopupStatus[11][0] == 3) SwitchesTB = 0x01;		//BF vertical sync
			else if (MenuPopupStatus[11][1] == 3) SwitchesTB = 0x02;	//BF composit sync
		
			if (MenuStatus[MENU_TRIGGERMODE][1] == 95) SwitchesTB |= 0x04;		//coupling
			else SwitchesTB &= 0xFB;
										
			SetSwitches(5, SwitchesTB);
			ext_trg_val_reg = ExtTriggerLevel[Trigger_Pos_CHE];
		
			serdata->np_piodata = ext_trg_val_reg;
			serstartpwm->np_piodata = 1;
			serstartpwm->np_piodata = 0;
		}
    	}

	if (TriggerWay == TRIG_PULS)	//BF pulse width triggering #021
	{
		//printf("\r\npulse width triggering active\r\n");

		adc_ctrl_reg &= 0xFFF0;
		
		//BF set source
		if (MenuStatus[MENU_PULSEWIDTH][0] == 137) adc_ctrl_reg |= 0x0001;
		else if (MenuStatus[MENU_PULSEWIDTH][0] == 138) adc_ctrl_reg |= 0x0002;
		else if (MenuStatus[MENU_PULSEWIDTH][0] == 139) adc_ctrl_reg |= 0x0004;
		else if (MenuStatus[MENU_PULSEWIDTH][0] == 140) adc_ctrl_reg |= 0x0008;
		else if (MenuStatus[MENU_PULSEWIDTH][0] == 141) adc_ctrl_reg &= 0xFFF0;

		if (MenuStatus[MENU_PULSEWIDTH][2] == 1) ctrl_reg |= 0x1200;
		else if (MenuStatus[MENU_PULSEWIDTH][2] == 2) ctrl_reg |= 0x1400;
		else if (MenuStatus[MENU_PULSEWIDTH][2] == 3) ctrl_reg |= 0x1800;
	}

    	// Autotrigger
//BF replaced by new Combi-Trigger	if ((MenuStatus[MENU_TRIGGERMODE][0] == 92) && (TriggerWay == 1)) ctrl_reg |= 0x0040;
//					else ctrl_reg &= 0xFFBF;

	// set trigger mode
	if ((MenuStatus[MENU_TRIGGERMODE][0] == 92) && (TriggerWay == TRIG_EDGE))	// auto mode
	{ ctrl_reg |= 0x0040; }	
	else if((MenuStatus[MENU_TRIGGERMODE][0] == 94) && (TriggerWay == TRIG_EDGE))   //combi-trigger by Stefan
	{
		if (Selected_Timebase<20)	//enable normal mode for timebase <=20ms
		{
			ctrl_reg &= 0xFFBF;
			noTriggerTime      = 0;	//reset time-measurement
			CombiTriggerStatus = 0;	//Starten im Normal-Modus
		}
		else
		{ ctrl_reg |= 0x0040; }		//Zeitbasis zu groß->immer Auto-Modus
		
	}
	else									// normal mode
	{ ctrl_reg &= 0xFFBF; }


	Selected_Trigger_Source = triggering;

/* BF del #019	
	MenuPopupStatus[28][0] = 2;
	MenuPopupStatus[28][1] = 2;
	
	if (NumberOfChannels > 2)
	{
		MenuPopupStatus[28][2] = 2;
		MenuPopupStatus[28][3] = 2;
    	}
*/
/*	
	MenuPopupStatus[7][0] = 2;
	MenuPopupStatus[7][1] = 2;
	
	if (NumberOfChannels > 2)
	{
		MenuPopupStatus[7][2] = 2;
		MenuPopupStatus[7][3] = 2;
    	}
*/
/*BF del #019
	if (MenuStatus[MENU_TRIGGEREDGE][1] == 138) MenuPopupStatus[28][0] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139) MenuPopupStatus[28][1] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140) MenuPopupStatus[28][2] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 141) MenuPopupStatus[28][3] = 3;			
*/
/*
	if (MenuStatus[MENU_TRIGGEREDGE][1] == 138) MenuPopupStatus[7][0] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139) MenuPopupStatus[7][1] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140) MenuPopupStatus[7][2] = 3;
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 141) MenuPopupStatus[7][3] = 3;		
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == 142) MenuPopupStatus[7][4] = 3;		
*/


	SetupADC();
}

void Hardware::Set_LED(int LED)
{
	LED_ON[LED] = 1;
	Send_LED();
}

void Hardware::Reset_LED(int LED)
{
	LED_ON[LED] = 0;
	Send_LED();
}

void Hardware::Clear_LED(void)
{
	int ct;
	
	for (ct = 0; ct < 13;ct++) LED_ON[ct] = 0;
}

void Hardware::Send_LED(void)
{
	int led_value = 0xFFFF;
	
	if (LED_ON[0] == 1) led_value = led_value & 0xBFFF;			// Select Channel 1
	if (LED_ON[1] == 1) led_value = led_value & 0xEFFF;			// Select Channel 2
	
	//if (NumberOfChannels > 2)
	//{
	   if (LED_ON[2] == 1) led_value = led_value & 0xFEFF;			// Select Channel 3
	   if (LED_ON[3] == 1) led_value = led_value & 0x7FFF;			// Select Channel 4
    	//}
	if (LED_ON[4] == 1) led_value = led_value & 0xDFFF;		// Select Channel Math
	if (LED_ON[5] == 1) led_value = led_value & 0xFDFF;		// General
	if (LED_ON[6] == 1) led_value = led_value & 0xFBFF;		// Cursor						
	if (LED_ON[7] == 1) led_value = led_value & 0xF7FF;		// Quick Measure
	if (LED_ON[8] == 1) led_value = led_value & 0xFFBF;		// Edge
	if (LED_ON[9] == 1) led_value = led_value & 0xFFFD;		// Pattern - Not Used
	if (LED_ON[10] == 1) led_value = led_value & 0xFF7F;		// Pulse Width
	if (LED_ON[11] == 1) led_value = led_value & 0xFFFE;		// More - Not Used
	if (LED_ON[12] == 1) led_value = led_value & 0xFFDF;		// Run/Stop Green
	if (LED_ON[13] == 1) led_value = led_value & 0xFFEF;		// Run/Stop Red
	if (LED_ON[14] == 1) led_value = led_value & 0xFFF7;		// Single Red					
	if (LED_ON[15] == 1) led_value = led_value & 0xFFFB;		// Single Green
	
	serdata->np_piodata = led_value;
	serstartled->np_piodata = 0x01;
	serstartled->np_piodata = 0x00;	
#ifdef _Debug_	
	if (Debug_Mode) printf("LED VAL : %x \n", led_value);
#endif
}
//##########################################################################################################################################

void Hardware::DoEnableRotInterrupt(void)						// Enable service routine
{
	rot_int->np_pioedgecapture = 0x00; 						// clear all existing IRQ conditions
	rot_int->np_piodirection = 0x00;						// set all bits to input
	rot_int->np_piointerruptmask = 0x01;						// enable rotary IRQ

	key_reset->np_piodata = 0;
	nr_delay(1);
	key_reset->np_piodata = 1;

	rot_int->np_pioedgecapture = 0x00; 						// clear all existing IRQ conditions
	
	nr_installuserisr(na_rot_interrupt_irq,ISR_ROT,(int)rot_int);			// Install ISR for parallel I/Os

	Rotary_Steps = 0;								// BF reset rotary buffer

#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nRot interrupt enabled.\n");  				// print on console
#endif	
}
//##########################################################################################################################################

void Hardware::DoDisableRotInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_rot_interrupt_irq,0,0); 					// Install empty routine for pio irq
	rot_int->np_piointerruptmask = 0x00;						// disable all IRQs
}
//##########################################################################################################################################

void Hardware::ISR_ROT(int context)							// Parallel I/O Interrupt subroutine
{
	int ct;
	int KeyData = key->np_piodata;								// Get interrupt data to asign respective ISR
	int Rot_Dir = KeyData & 0x000FFF;							// Get interrupt data to asign respective ISR

	Rotary_Switch = (KeyData & 0xFFF000) >> 12;

	//BF only draw signal with changed zerolevel
	if (((Rotary_Switch & 0x00000080) == 0x00000080) && Channel_1_Active) { ZL_changed = 1; }
	else if (((Rotary_Switch & 0x00000010) == 0x00000010) && Channel_2_Active) { ZL_changed = 2; }
	else if (((Rotary_Switch & 0x00000800) == 0x00000800) && Channel_3_Active) { ZL_changed = 3; }
	else if (((Rotary_Switch & 0x00000100) == 0x00000100) && Channel_4_Active) { ZL_changed = 4; }

//BF -> del	for (ct = 0; ct < 100; ct++){};
	
	rot_speed_read->np_piodata = 1;
	Rotary_Steps = key->np_piodata & 0x000FFF;							// Get interrupt data to assign respective ISR
	
	//printf("\nkeydata : %3x RotSW %3x RotDir %i RotaryDirec %i RotDirMem %i RotSpe : %i \n\n", key->np_piodata, Rotary_Switch, Rot_Dir, Rotary_Direction, Rotary_Direction_mem, Rotary_Steps);	

	rot_speed_read->np_piodata = 0;

	key_reset->np_piodata = 0;
	for (ct = 0; ct < 100; ct++){};
	key_reset->np_piodata = 1;

	UI_request = 1;
	Rotary_Changed = 1;

	rot_int->np_pioedgecapture = 0;								// clear IRQ conditions		

	if (Rotary_Switch == Rot_Dir)
	Rotary_Direction = 1;
	else
	Rotary_Direction = 0;

#ifdef _Debug_IRQ_
    if (Debug_Mode) printf("RotSW %3x RotDir %i RotaryDirec %i RotDirMem %i RotSpe : %i \n", Rotary_Switch, Rot_Dir, Rotary_Direction, Rotary_Direction_mem, Rotary_Steps);	
#endif
	Rotary_Direction_mem = Rotary_Direction;

}
//##########################################################################################################################################
void Hardware::RecalcTimeParameters(void)
{
	ZoomFactor_old   = ZoomFactor;
	ZoomFactor       = ZoomFactorTable[Timebase_Idx];

	OffsetFactor     = OffsetFactorTable[Timebase_Idx];


	// Correct the Trigger Position
	Trig_Pos_Mem = (int)((float) Trig_Pos_Mem * (ZoomFactor / ZoomFactor_old));
	
	// Correct the Memory Position
	MemWinStart = (int)((float) (MemWinStart) * (ZoomFactor / ZoomFactor_old));
 
   
        if (MemWinStart < MemStartOffs) 
        {
        	Trig_Pos_Mem = Trig_Pos_Mem + (MemStartOffs - MemWinStart);
        	MemWinStart = MemStartOffs;
        }

	if (Selected_Timebase < 9)
	{
		if ((MemWinStart + SignalSize[Timebase_Idx]) > 16250) MemWinStart = 16250 - SignalSize[Timebase_Idx];
	}
	else
	{
		if ((MemWinStart + SignalSize[Timebase_Idx]) > 4070) MemWinStart = 4070 - SignalSize[Timebase_Idx];
	}


	if (MenuStatus[MENU_TIMEBASE][1] == 1)
	{
		Timebase_Ratio = Timebase_Delayed_Factor_Table[Timebase_Idx] / Timebase_Delayed_Factor_Table[Timebase_Idx - dmode_Selected_Timebase - 1];	//BF #003

		Cursor_Delayed_1 = ((GRID_WIDTH / 2) - (int) (((float) GRID_WIDTH / Timebase_Ratio) / 2)) + dmode_Window_Offset_Pos;
		Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / Timebase_Ratio);
		Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;

//		ZoomFactorDel = DelZoomFactorTable[Timebase_Idx][dmode_Selected_Timebase]; //BF = ZoomFactor / Timebase_Ratio -> to check
		if (Timebase_Ratio > 0)
		ZoomFactorDel = ZoomFactor / Timebase_Ratio;
		else
		ZoomFactorDel = 0;

	}
    
    	RecalcTriggerPos();
}

//##########################################################################################################################################
void Hardware::RecalcTriggerPos(void)
{
//    printf("C1 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, MemWinStart, Trig_Pos_Display);
    
    Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
    Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactorDel) - ((float) Cursor_Delayed_1 * (ZoomFactor / ZoomFactorDel)));
    
    if (Selected_Timebase < 9) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;
    else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;

//    printf("C2 pre : %x TPM : %d TMP : %d - %d\n\n", pre_reg, Trig_Pos_Mem, MemWinStart, Trig_Pos_Display);
    
    if (pre_reg > 4096)
    {
        Trig_Pos_Mem = GRID_WIDTH / 2;
        MemWinStart = MemStartOffs;

        Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);

        if (Selected_Timebase < 9) pre_reg = (Trig_Pos_Mem >> 2) + PreReg_Offset;
        else pre_reg = (Trig_Pos_Mem) + PreReg_Offset;
    }
}

//##########################################################################################################################################
void Hardware::Zero_Levels_Center(void)	 
{
	char CH1_bak, CH2_bak, CH3_bak, CH4_bak;

	if(Continius) Hardware::Stop_Record();

	//backup channel status
	CH1_bak = Channel_1_Active;
	CH2_bak = Channel_2_Active;
	CH3_bak = Channel_3_Active;
	CH4_bak = Channel_4_Active;

	//backup zerolevels
	ZeroLevelCH1_bak = ZeroLevelCH1;
	ZeroLevelCH2_bak = ZeroLevelCH2;
	ZeroLevelCH3_bak = ZeroLevelCH3;
	ZeroLevelCH4_bak = ZeroLevelCH4;

	Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
	Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
	Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
	Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;


	//set zerolevels to the middle of the grid
	ZeroLevelCH1 = GRID_HEIGHT / 2;
	ZeroLevelCH2 = GRID_HEIGHT / 2;
	ZeroLevelCH3 = GRID_HEIGHT / 2;
	ZeroLevelCH4 = GRID_HEIGHT / 2;

	Virtual_ZeroLevelCH1 = 0;
	Virtual_ZeroLevelCH2 = 0;
	Virtual_ZeroLevelCH3 = 0;
	Virtual_ZeroLevelCH4 = 0;

	//channel have to be active to activate new settings
	Channel_1_Active = true;
	Channel_2_Active = true;

	//activate new settings
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();

	if (NumberOfChannels > 2)	// 4 channel version
	{	
		Channel_3_Active = true;
		Channel_4_Active = true;

		//activate new settings
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_3();
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();
	}

	//restore channel status
	Channel_1_Active = CH1_bak;
	Channel_2_Active = CH2_bak;
	Channel_3_Active = CH3_bak;
	Channel_4_Active = CH4_bak;

	nr_delay(100);

	if(!Continius && !RC_request)SingleMode = 1;
	
	Hardware::Start_Record();

}
//##########################################################################################################################################
void Hardware::Zero_Levels_Restore(void)							// 
{
	char CH1_bak, CH2_bak, CH3_bak, CH4_bak;

	if(Continius) Hardware::Stop_Record();

	//backup channel status
	CH1_bak = Channel_1_Active;
	CH2_bak = Channel_2_Active;
	CH3_bak = Channel_3_Active;
	CH4_bak = Channel_4_Active;

	//restore zerolevels
	ZeroLevelCH1 = ZeroLevelCH1_bak;
	ZeroLevelCH2 = ZeroLevelCH2_bak;
	ZeroLevelCH3 = ZeroLevelCH3_bak;
	ZeroLevelCH4 = ZeroLevelCH4_bak;

	Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_bak;
	Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_bak;
	Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_bak;
	Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_bak;

	//channel have to be active to activate new settings
	Channel_1_Active = true;
	Channel_2_Active = true;

	//activate new settings
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();

	if (NumberOfChannels > 2)	// 4 channel version
	{	
		Channel_3_Active = true;
		Channel_4_Active = true;

		//activate new settings
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_3();
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();
	}

	//restore channel status
	Channel_1_Active = CH1_bak;
	Channel_2_Active = CH2_bak;
	Channel_3_Active = CH3_bak;
	Channel_4_Active = CH4_bak;

	nr_delay(100);

	if(!Continius && !RC_request)SingleMode = 1;
	
	Hardware::Start_Record();

}
//###########################################################################################################################################

void Hardware::DoEnableUARTInterrupt(void)						// Enable service routine
{
	nr_installuserisr(na_uart1_irq, ISR_UART, (int)puart);				// Install ISR for UART

	puart->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART interrupt enabled.\n"); 				// print on console
#endif	
}
	
void Hardware::DoDisableUARTInterrupt(void)						// Disable service routine
{
	puart->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart1_irq, 0, 0); 						// Install empty routine for uart irq
}
//###########################################################################################################################################
//BF cleaned ISR from useless overhead and transferred buttonhandler to keyboard interface
/*********************************************************************
/ Added state machine for GUI-commands.
/ On reception of STX (0x02) eight Bytes are read into a buffer.
/ When buffer is full, UartRxGuiCmd is set to 1
*********************************************************************/
void Hardware::ISR_UART(int context)                            // UART Interrupt subroutine for RS232 interface
{
#define	debug 0
    char rxchar;
    int status;
    static unsigned char state=0,rxbufcnt=0;

    status = puart->np_uartstatus;
    rxchar = puart->np_uartrxdata;

    puart->np_uartstatus = 0;				//clear interrupt condition


    if (status & np_uartstatus_rrdy_mask)
    {
        switch (state) {
            case 0:
                if (rxchar != STX) {        //Standard handling
                    UART_RXData  = rxchar;
                    UART_NewData = 1;
                    UI_request   = 1;
                }
                else state=1;
            break;
            case 1:
                if (rxchar == 'E') {        //Extended CMD from GUI
					if (debug) printf("E->2\n\r");
                    state=2; }
                else {                      //This is a screenshot-request
                    UartRxGuiCmd=rxchar;    //This setting is caught in PC-comms.cpp
					UART_NewData=1;
					if (debug) printf("Extended Part invalid: %.2X\n\r",rxchar);
                    state=0; }
            break;
            case 2:
					if (debug) printf("Extended Part: %.2X\n\r",rxchar);
                    UartRxGuiBuf[rxbufcnt++]=rxchar;    //Store to buffer
                    if (rxbufcnt==UARTRXGUISIZE) {      //If buffer is full
						if (debug) printf("Is Last Extended Part: %.2X\n\r",rxchar);
                        UartRxGuiCmd='E';               //Mark UartRxGuiCmd
                    	UART_NewData = 1;
                        rxbufcnt=0;                     //Reset counter
                        state=0; }                      //and state
            break;
        }
    }
}

//###########################################################################################################################################

void Hardware::DoEnableUART2Interrupt(void)						// Enable service routine
{
	UART2_rx_cnt = 0;
	
	nr_installuserisr(na_uart_usb_irq, ISR_UART2, (int)puart2);			// Install ISR for UART2

	puart2->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART USB interrupt enabled.\n"); 			// print on console
#endif	
}
//###########################################################################################################################################
	
void Hardware::DoDisableUART2Interrupt(void)						// Disable service routine
{
	puart2->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart_usb_irq, 0, 0); 					// Install empty routine for uart2 irq
}
//###########################################################################################################################################
// BF new designed USB function #017
void Hardware::ISR_UART2(int context)							// UART Interrupt subroutine for USB interface
{
	char rxchar = -1;
	int status;
	int x;
		

		
	status = puart2->np_uartstatus;									// get UART status
	rxchar = puart2->np_uartrxdata;									// get transferred byte
	
	//puart2->np_uartstatus = 0;									// Clear Interrupt condition
	   	
	if (status & np_uartstatus_rrdy_mask)
	{
		UART2_rx_buffer[UART2_rx_cnt] = rxchar;							// save byte to buffer
			
		UART2_rx_cnt++;										// increase byte counter
	}	

	if ((UART2_rx_buffer[0] != 64) && (UART2_rx_buffer[0] != 8) && (UART2_rx_buffer[0] != 37))	// check for block start indicator
	UART2_rx_cnt = 0;
													// first byte contains block size

	if ((UART2_rx_cnt == UART2_rx_buffer[0]) && (UART2_rx_cnt > 0))								// Check if data block is complete (64 byte)
	{		
		printf("USB Interface: Received data block with %d bytes\n\r",UART2_rx_cnt);

		if(UART2_rx_buffer[0] == 37) CommIF::InterpretUART(&UART2_rx_buffer[0]);		//WELEC USB handler
	
		if(UART2_rx_buffer[0] == 64) CommIF::ON_UART2DataBlock(&UART2_rx_buffer[0]);		//new USB handler by BF

		if(UART2_rx_buffer[0] == 8) CommIF::ON_UART2DataBlock(&UART2_rx_buffer[0]);		//new USB handler by BF

		UART2_rx_cnt = 0;									// reset byte counter
	}
	
	puart2->np_uartstatus = 0;									// Clear Interrupt condition

}

//##############################################################################################################################################
// BF new implemented
// timer 1 service routines for combi-trigger
void Hardware::DoEnableTimer1Interrupt(void)									// Enable service routine
{	
	nr_installuserisr(na_timer1_irq,ISR_TIMER1,(int)timer1); 						// Install timer isr
	
	timer1->np_timerperiodh = (nasys_clock_freq/1000)>>16;;
	timer1->np_timerperiodl = (nasys_clock_freq/1000)&0x0000ffff;	
	
	timer1->np_timercontrol = timer1->np_timercontrol | np_timercontrol_ito_mask | np_timercontrol_start_mask | np_timercontrol_cont_mask;
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nTimer1 interrupt enabled.\n"); 						// print on console
#endif	
}


void Hardware::DoDisableTimer1Interrupt(void)									// Disable service routine
{
	nr_installuserisr(na_timer1_irq,0,0); 									// Install empty routine for timer irq
	timer1->np_timercontrol = timer1->np_timercontrol & ~np_timercontrol_ito_mask; 				// Disable timer interrupt
}

void Hardware::Start_Timer1(void)
{
	timer1->np_timerperiodh = timer_reload_high;
	timer1->np_timerperiodl = timer_reload_low;	
	
	timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_start_mask);	// Start Timer
}

void Hardware::Stop_Timer1(void)
{
   	 timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer
}

void Hardware::ISR_TIMER1(int context)										// Menu Timer service subroutine
{
	timer1->np_timerstatus  = 0;										// clear the status register
	timingcounter++;
	noTriggerTime++; 											//needed for combi-trigger
	
	//BF added for Stefans combi-trigger
	if (MenuStatus[MENU_TRIGGERMODE][0] == 94  && noTriggerTime > 500  && CombiTriggerStatus == 0 && USTB_Mode == USTB_OFF) //change trigger to auto-trigger
	{
		//combi-trigger,  no Trigger for 500ms, trigger still in normal-mode
		if((Selected_Timebase < 20) || (!(ctrl_reg & 0x0040)))
		{
			//timebase<=20ms,
			CombiTriggerStatus = 1;//change trigger to auto-trigger
			ctrl_reg |= 0x0040;
			SetupADC();
			// printf("Set to Auto\n");
		}
	}
	
#ifdef _Debug_IRQ_
	if (Debug_Mode)  printf("We got a timer1 irq  AFR %d  AST %d tcv %d tcm %d irq %d\n", AutoFreeRun, AutoSearchTrigger, timer_counter_value, timer_counter_max, acq_ready->np_piodata);
#endif
}

//##############################################################################################################################################
// BF new implemented
// Enable timer 2 interrupt for rollmode
void Hardware::DoEnableTimer2Interrupt(void)									// Enable service routine
{	

	//timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	timer2->np_timercontrol = 0x0008;									// Stop Timer, disable interrupt
	//timer2->np_timerperiodh = (short)((USTB_timer_value[Selected_Timebase - 23] >> 16) & 0x0000ffff);	// Set High Register of Timer
	//timer2->np_timerperiodl = (short)(USTB_timer_value[Selected_Timebase - 23] & 0x0000ffff);		// Set Low Register of Timer
	timer2->np_timerstatus = 0;										// write anything to clear the ISR

	nr_installuserisr(na_timer2_irq,ISR_TIMER2,(int)timer2); 						// Install timer isr
	timer2->np_timercontrol = 0x0001;									// enable interrupt

	//printf("\nTimer2 interrupt enabled.\n");

}
//##############################################################################################################################################
// BF new implemented
// disable timer 2 interrupt for rollmode
void Hardware::DoDisableTimer2Interrupt(void)									// Disable service routine
{
	
	timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	nr_installuserisr(na_timer2_irq,0,0); 									// Install empty routine for timer irq
    	timer2->np_timerstatus = 0;

	//printf("\nTimer2 interrupt disabled.\n");	

}
// BF new implemented
void Hardware::Start_Timer2(void)
{
	//timer2->np_timerperiodh = (short)((USTB_timer_value[Selected_Timebase - 23] >> 16) & 0x0000ffff);	// Set High Register of Timer
	//timer2->np_timerperiodl = (short)(USTB_timer_value[Selected_Timebase - 23] & 0x0000ffff);		// Set Low Register of Timer
	//timer2->np_timerstatus = 0;										// clear the ISR

	//timer2->np_timercontrol = np_timercontrol_start_mask;							// Start Timer
	//timer2->np_timercontrol = np_timercontrol_start_mask + np_timercontrol_ito_mask;			// Start Timer and enable Interrupt
	timer2->np_timercontrol = 0x0005;									// Start Timer and enable Interrupt
	printf("\nTimer2 started.\n");
}
// BF new implemented
void Hardware::Stop_Timer2(void)
{
	//timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	//timer2->np_timercontrol = 0x0009;									// Stop Timer
	timer2->np_timercontrol = 0x0008;									// Stop Timer, disable interrupt
	timer2->np_timerstatus  = 0;										// clear the ISR

	//printf("\nTimer2 stopped.\n");
}
// BF new implemented
void Hardware::Reset_Timer2(void)
{
	timer2->np_timerperiodh = (short)((USTB_timer_value[Selected_Timebase - 23] >> 16) & 0x0000ffff);	// Set High Register of Timer
	timer2->np_timerperiodl = (short)(USTB_timer_value[Selected_Timebase - 23] & 0x0000ffff);		// Set Low Register of Timer
	timer2->np_timerstatus = 0;										// clear the ISR
	
	timer2->np_timercontrol = 0x0007; 									// Set Timer to continous and start

	//timer2->np_timercontrol = np_timercontrol_start_mask;							// Start Timer
	//timer2->np_timercontrol = np_timercontrol_start_mask + np_timercontrol_ito_mask;			// Start Timer and enable Interrupt
	//timer2->np_timercontrol = 0x0005;									// Start Timer and enable Interrupt
	printf("\r\nTimer2 counter value = %d\r\n", USTB_timer_value[Selected_Timebase - 23]);
	//printf("\nTimer2 resetted.\n");
}

//##############################################################################################################################################
// timer 2 interrupt service routine for rollmode
// BF new implemented
void Hardware::ISR_TIMER2(int context)										// Menu Timer service subroutine
{
	//int cnt;
	
	if (context != (int)timer2) return;

	//if (Continius == false) return;

	timer2->np_timerstatus  = 0;										// clear the status register
	//Stop_Timer2();

	Start_Record();
	
//	printf("\nTimer 2 interrupt occured - new record started\n");

}

//##############################################################################################################################################
/* BF -> not needed
// copy/shift routine for rollmode
void Hardware::Copy_in_asm(int cnt, unsigned char *DataArray_in, unsigned char *DataArray_out)
{
    asm("
            ;MOV	%l0, %i0

            ;MOV	%l1, %i1
            ;SUB	%l1, %i0

            ;MOV	%l2, %i2
            ;SUB	%l2, %i0

        copy_asm1 :
            LD      	%r0, [%i1]	; save old value
            EXT8D   	%r0, %i1 	; extract byte

            FILL8	%r0, %r0
            ST8D	[%i2], %r0

            ADDI   	%i1, 1    	; Add Address Counter
            ADDI   	%i2, 1 		; Add Address Counter
                        	
            SUBI   	%i0, 1   	; Decrement Line Counter
            SKPS   	cc_z
            BR     	copy_asm1	
            NOP

        ");

}
*/


//##############################################################################################################################################
// enable timer 3 interupt for rotary interface
void Hardware::DoEnableTimer3Interrupt(void)										// Enable service routine
{					
	timer_rotary_busy->np_timerperiodh = timerrotPeriod >> 16;									// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = timerrotPeriod & 0xffff;									// Set Low Register of Timer
    timer_rotary_busy->np_timerstatus = 0;														// write anything to clear the IRQ

	nr_installuserisr(na_timer3_irq,ISR_TIMER3,(int)timer_rotary_busy); 						// Install timer isr

	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol | np_timercontrol_ito_mask;  	// Enable timer interrupt
	
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("Timer3 interrupt enabled & started.\n"); 										// print on console
#endif	
}
//##############################################################################################################################################
// disable timer 3 interupt for rotary interface
void Hardware::DoDisableTimer3Interrupt(void)										// Disable service routine
{
	nr_installuserisr(na_timer3_irq,0,0); 											// Install empty routine for timer irq
	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol & ~np_timercontrol_ito_mask; 	// Disable timer interrupt
}

//##############################################################################################################################################
// timer 3 interrupt service routine for rotary interface and popup menus
void Hardware::ISR_TIMER3(int context)				// Menu Timer service subroutine
{
	char fchanged = 0;
	char already_saved = 0;					// TMW added variable


	timer_rotary_busy->np_timerstatus = 0;	// write anything to clear the IRQ
    	
	if ((Search_Mode) || (Splash_drawed)) return;

	if(QP_request) return;
	
 	if (MenuItemPushed[0] == 1) { fchanged = 1; MenuItemPushed[0] = 0; MenuItemPushed_old[0] = 1; MenuItemChanged[0] = 1;}
	if (MenuItemPushed[1] == 1) { fchanged = 1; MenuItemPushed[1] = 0; MenuItemPushed_old[1] = 1; MenuItemChanged[1] = 1;}
	if (MenuItemPushed[2] == 1) { fchanged = 1; MenuItemPushed[2] = 0; MenuItemPushed_old[2] = 1; MenuItemChanged[2] = 1;}
	if (MenuItemPushed[3] == 1) { fchanged = 1; MenuItemPushed[3] = 0; MenuItemPushed_old[3] = 1; MenuItemChanged[3] = 1;}
	if (MenuItemPushed[4] == 1) { fchanged = 1; MenuItemPushed[4] = 0; MenuItemPushed_old[4] = 1; MenuItemChanged[4] = 1;}
	if (MenuItemPushed[5] == 1) { fchanged = 1; MenuItemPushed[5] = 0; MenuItemPushed_old[5] = 1; MenuItemChanged[5] = 1;}

	if (StatusbarChanged) { Display::RemoveStatusBtn(); }			// Remove the Status Button
	if (MenuPopupActive > -1)
    	{
  		config_changed = 1;						// BF write config
       		fchanged = 0;
        	Display::DRAWMENUPOPDOWN();
		already_saved = 1;						// TMW added variable
    	}	 

	// Bf changed for new menu structure 
	if ((Memory_Window_visible) && (MenuStatus[MENU_TIMEBASE][5] == 240)) 	// if Memory Window is visible and
    	{									// Browse Function not active
		if ( already_saved == 0 )					// TMW added variable
		{
			config_changed = true;  				// BF write config
		}
		
      		Display::DRAWMEMORY(1, 0, 0);     			  	// Close Memory Window and
    	}
	
	if (fchanged == 1) { New_Menu = Active_Menu; Menu_Changed = 1; }

	ButtonChanged = 0;
	RoteryReady = 0;

	Menu_Popup_visible = 0;

   	//BF del acq_ready->np_pioedgecapture = 0;	#018

}
//##############################################################################################################################################
// Reset timer 3 
void Hardware::ResetTimer(void)	// Reset Timer
{
	long timerVal;
	long timerPeriod;

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);// & ~np_timercontrol_cont_mask;	// Stop Timer
	timer_rotary_busy->np_timerstatus = 0;								// write anything to clear the IRQ
		
	timer_rotary_busy->np_timerperiodh = timerrotPeriod >> 16;			// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = timerrotPeriod & 0xffff;		// Set Low Register of Timer

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);// | np_timercontrol_cont_mask;	// Start Timer

}
//##############################################################################################################################################
// set hardware switches on the mainboard for voltage range
void Hardware::SetSwitches(char channel, int voltage)
{
	bool DoNothing = 0;
	short dat_buf = 0;
	short CalcBufInt = 0;	
	long adr_buf = 0x00000000;
	long outbuf = 0x00000000;
	


	//Bit0 and Bit1: 01: 1st Voltage divider 1/10, Bit2 and 3: 2nd Voltage divider 1/10
	//Bit4: 0: OPA656N: ampl. by 1.25, 1: ampl. by 1.
	//Bit5: BW-Limit
	//Bit6: 1st AD8131 x1/x2
	//Bit7: 2nd AD8131 x1/x2
	//Bits8-11: AC Channel (Bit8..Bit11)
			
	switch(voltage)
	{
		case -1 :
		{
			switch(channel)
			{
				case 1 : dat_buf = SwitchesCH1;break;
				case 2 : dat_buf = SwitchesCH2;break;
				case 3 : dat_buf = SwitchesCH3;break;
				case 4 : dat_buf = SwitchesCH4;break;
				case 5 : dat_buf = SwitchesTB;break;				
			}	
			break;		
		}			
							// amplification 1.25
		case 0 : dat_buf = 0x0015; break;	//0x0005	//1mV
		case 1 : dat_buf = 0x0015; break;	//0x0005	//2mV
		case 2 : dat_buf = 0x0015; break;	//0x0005	//5mV
		case 3 : dat_buf = 0x0015; break;	//0x0005	//10mV	00010101
		case 4 : dat_buf = 0x0055; break;	//0x0045	//20mV	01010101
		case 5 : dat_buf = 0x00C5; break;	//0x00D5	//50mV	11000101
		case 6 : dat_buf = 0x0019; break;	//0x0009	//100mV	00011001
		case 7 : dat_buf = 0x0059; break;	//0x0049	//200mV	01011001
		case 8 : dat_buf = 0x00C9; break;	//0x00D9	//500mV	11001001
		case 9 : dat_buf = 0x001A; break;	//0x000A	//1V	00011010
		case 10 : dat_buf = 0x005A; break;	//0x004A	//2V	01011010
		case 11 : dat_buf = 0x00CA; break;	//0x00DA	//5V	11001010
	}

	//switch for amplification
	if(GainIdx > 0) dat_buf &= 0xFFEF;	//delete bit 4 set to 1.25


	switch(channel)
	{
		case 1:
		{
			adr_buf = 0x70000000;		// channel 1 = address 7 (hardware)

			// Set AC Bits
			dat_buf = dat_buf & 0xF0DF;

			if (MenuStatus[MENU_CHANNEL1][0] == 8) dat_buf = dat_buf | 0x0100;
			if (MenuStatus[MENU_CHANNEL2][0] == 8) dat_buf = dat_buf | 0x0200;
			if (MenuStatus[MENU_CHANNEL3][0] == 8) dat_buf = dat_buf | 0x0400;
			if (MenuStatus[MENU_CHANNEL4][0] == 8) dat_buf = dat_buf | 0x0800;	
		
			// BW Limit
			if (MenuStatus[MENU_CHANNEL1][1] == 241) dat_buf = dat_buf | 0x0020;

			SwitchesCH1 = dat_buf;
			
			VoltageChangedCh1 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH1, (adr_buf | SwitchesCH1));
#endif			
			break;	
		}
		case 2:
		{
			adr_buf = 0x50000000;		// channel 2 = address 5 (hardware)
			
			// Set AC Bit
			dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;	
			//if (MenuStatus[MENU_CHANNEL2][0] == 8) dat_buf = dat_buf | 0x0200;	//BF add
			// BW Limit
			if (MenuStatus[MENU_CHANNEL2][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH2 = dat_buf;
            			
			VoltageChangedCh2 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH2, (adr_buf | SwitchesCH2));
#endif			
			break;	
		}
		case 3:
		{
			adr_buf = 0x10000000;		// channel 3 = address 4 (hardware)
			
			// Set AC Bit		
			dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;
			//if (MenuStatus[MENU_CHANNEL3][0] == 8) dat_buf = dat_buf | 0x0400;	//BF add
			// BW Limit
			if (MenuStatus[MENU_CHANNEL3][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH3 = dat_buf;
            			
			VoltageChangedCh3 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH3, (adr_buf | SwitchesCH3));
#endif			
			break;	
		}
		case 4:
		{
			adr_buf = 0x30000000;		// channel 4 = address 3 (hardware)
			
			// Set AC Bit	
            		dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;
			//if (MenuStatus[MENU_CHANNEL4][0] == 8) dat_buf = dat_buf | 0x0800;
			// BW Limit
			if (MenuStatus[MENU_CHANNEL4][1] == 241) dat_buf = dat_buf | 0x0020;
			
			SwitchesCH4 = dat_buf;
            			
			VoltageChangedCh4 = 1;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesCH4, (adr_buf | SwitchesCH4));
#endif			
			break;	
		}		
		case 5:
		{
			adr_buf = 0x20000000;		// trigger channel = address 2 (hardware)
			
			SwitchesTB = voltage;
#ifdef _Debug_			
			if (Debug_Mode) printf("Switches : %x , erg : %x \n", SwitchesTB, (adr_buf | SwitchesTB));
#endif			
			break;	
		}				
	}

	switch(channel)
	{
		case 1: outbuf = adr_buf | SwitchesCH1; break;
		case 2: outbuf = adr_buf | SwitchesCH2; break;
		case 3: outbuf = adr_buf | SwitchesCH3; break;
		case 4: outbuf = adr_buf | SwitchesCH4; break;
		case 5: outbuf = adr_buf | SwitchesTB; break;		
		case 6: outbuf = 0xFFFFFFFF; break;		
		case 7: outbuf = 0x00000000; break;				
	}	
#ifdef _Debug_		
    if (Debug_Mode) printf("outbuf1 : %x\n", outbuf);
#endif       		
    serdata->np_piodata = outbuf;//TurnBits(outbuf);
	
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
		
	nr_delay(15);

	//Clear Bits0..3 and send again to shut off driver transistors for voltage divider-relais
	switch(channel)
	{
		case 1: outbuf = (adr_buf | SwitchesCH1) & 0xFFFFFFF0; break;
		case 2: outbuf = (adr_buf | SwitchesCH2) & 0xFFFFFFF0; break;
		case 3: outbuf = (adr_buf | SwitchesCH3) & 0xFFFFFFF0; break;
		case 4: outbuf = (adr_buf | SwitchesCH4) & 0xFFFFFFF0; break;
	}		
#ifdef _Debug_
    if (Debug_Mode) printf("outbuf2 : %x\n", outbuf);
#endif
    if ((channel > 0) && (channel < 5))
    {
        serdata->np_piodata = outbuf;//TurnBits(outbuf);	
	
	   serstartsw->np_piodata = 1;
	   serstartsw->np_piodata = 0;	

	   nr_delay(15);
    }
#ifdef _Debug_	
	if (Debug_Mode)
    {
	    switch(channel)
	    {	
		    case 1: printf("Switches : %x , erg : %x\n", SwitchesCH1, (adr_buf | SwitchesCH1) & 0xFFFFFFF0); break;
		    case 2: printf("Switches : %x , erg : %x\n", SwitchesCH2, (adr_buf | SwitchesCH2) & 0xFFFFFFF0); break;
		    case 3: printf("Switches : %x , erg : %x\n", SwitchesCH3, (adr_buf | SwitchesCH3) & 0xFFFFFFF0); break;
		    case 4: printf("Switches : %x , erg : %x\n", SwitchesCH4, (adr_buf | SwitchesCH4) & 0xFFFFFFF0); break;
		    case 5: printf("Switches : %x , erg : %x\n", SwitchesTB, (adr_buf | SwitchesTB) & 0xFFFFFFFF); break;
	    }
    }
#endif					

}

void Hardware::SetDacOffset(char channel)
{
	long CalcBufInt = 0;	
	long BufInt = 0;
	long BufInt2 = 0;	
	long outbuf = 0x00000000;		


	switch(channel)
	{
		case 1 :	//if (CH1_DAC_Offset != CH1_DAC_OffsetOld)
					{
						BufInt = CH1_DAC_Offset;
						BufInt2 = (0x00310000 | (BufInt * 4));


						// Bei gelegenheit gegen Turnbits tauschen
						outbuf = (0x60000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 2 :	//if (CH2_DAC_Offset != CH2_DAC_OffsetOld)
					{
						BufInt = CH2_DAC_Offset;
						BufInt2 = (0x00300000 | (BufInt * 4));						

                        			outbuf = (0x60000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 3 :	//if (CH3_DAC_Offset != CH3_DAC_OffsetOld)
					{
						BufInt = CH3_DAC_Offset;
						BufInt2 = (0x00310000 | (BufInt * 4));	
						
                        			outbuf = (0x40000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
					
		case 4 :	//if (CH4_DAC_Offset != CH4_DAC_OffsetOld)
					{
						BufInt = CH4_DAC_Offset;
						BufInt2 = (0x00300000 | (BufInt * 4));						

                        			outbuf = (0x40000000 | BufInt2);
						
						serdata->np_piodata = outbuf;
						
						serstartsw->np_piodata = 1;
						serstartsw->np_piodata = 0;	
										
						nr_delay(5);						
					}	
					break;	
	}											
#ifdef _Debug_
	if (Debug_Mode) printf("ch : %d cb : %x bi : %x bi2 : %x  ob : %x \n", channel, CalcBufInt, BufInt, BufInt2, outbuf);
#endif
}

void Hardware::SetCHDacOffset(char channel)
{
	switch(channel)
	{
		case 1 :
		{		
 			// channel 1 DAC 1
			serdata->np_piodata = 0x80000000 | 0 | 0x0600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	

			nr_delay(1);
					
 			// channel 1 DAC 2
			serdata->np_piodata = 0x80000000 | 0 | 0x1600; //0x0E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

 			// channel 1 DAC 3
			serdata->np_piodata = 0x80000000 | 0 | 0x1E00; //0x1600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

 			// channel 1 DAC 4
			serdata->np_piodata = 0x80000000 | 0 | 0x2600; //0x1E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);	
					
			break;	
		}
															
		case 2 : 
		{
			// channel 2 DAC 1
			serdata->np_piodata = 0x80000000 | 0 | 0x0E00; //0x2600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 2 DAC 2
			serdata->np_piodata = 0x80000000 | 0 | 0x3E00; //0x2E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 2 DAC 3
			serdata->np_piodata = 0x80000000 | 0 | 0x3600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 2 DAC 4
			serdata->np_piodata = 0x80000000 | 0 | 0x2E00; //0x3E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);
										
			break;
		}

		case 3 : 
		{
			// channel 3 DAC 1
			serdata->np_piodata = 0x90000000 | 0 | 0x0600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	

			nr_delay(1);		

			// channel 3 DAC 2
			serdata->np_piodata = 0x90000000 | 0 | 0x0E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 3 DAC 3
			serdata->np_piodata = 0x90000000 | 0 | 0x1600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 3 DAC 4
			serdata->np_piodata = 0x90000000 | 0 | 0x1E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);	

			break;		
		}												
															
		case 4 : 
		{
			// channel 4 DAC 1
			serdata->np_piodata = 0x90000000 | 0 | 0x2600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);	

			// channel 4 DAC 2
			serdata->np_piodata = 0x90000000 | 0 | 0x2E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 4 DAC 3
			serdata->np_piodata = 0x90000000 | 0 | 0x3600;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			// channel 4 DAC 4
			serdata->np_piodata = 0x90000000 | 0 | 0x3E00;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
			
			nr_delay(1);

			break;					
		}			
	}	
}
//#####################################################################################################################################################

void Hardware::SetupADC(void)
{
	
	mode->np_piodata = 0x01;
		
	if (triggering == 0) WRITEADC(1, (ctrl_reg | 0x0001) + (adc_ctrl_reg << 16));	
	else if(triggering == 1) WRITEADC(1, ctrl_reg + (adc_ctrl_reg << 16));
	else WRITEADC(1, (ctrl_reg & 0xFFFE) + (adc_ctrl_reg << 16));		

	WRITEADC(1, timebase_reg);

	WRITEADC(1, pre_reg + (channel_Adr_add12 << 16));
    	
	WRITEADC(1, trg_val_CHI_reg + (trg_val_CHII_reg << 8) + (trig_range_reg << 16));
	WRITEADC(1, (0xFFFFFFFF - trig_holdoff_reg));

	//BF set the grid color via trigger width register 
	WRITEADC(1, trig_width_reg + (GridColor_Val << 26));	// ->GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
	WRITEADC(1, adc_change12_reg);
	
	WRITEADC(1, adc_ctr12_reg);

	mode->np_piodata = 0x00;


	if (NumberOfChannels == 4)
	{
		mode->np_piodata = 0x01;
								
		if(triggering == 3) WRITEADC(3, ctrl_reg + (adc_ctrl_reg << 16));
		else WRITEADC(3, (ctrl_reg & 0xFFFE) + (adc_ctrl_reg << 16));
	
		WRITEADC(3, timebase_reg);
		
		WRITEADC(3, pre_reg + (channel_Adr_add34 << 16));		//BF add
//		WRITEADC(3, pre_reg + (channel_Adr_add2 << 16));

		WRITEADC(3, trg_val_CHIII_reg + (trg_val_CHIV_reg << 8) + (trig_range_reg << 16));	
		WRITEADC(3, (0xFFFFFFFF - trig_holdoff_reg));
	
		//BF set the grid color via trigger width register -> function is a little bit dubious		
		WRITEADC(3, trig_width_reg + (GridColor_Val << 26));	// ->GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
		WRITEADC(3, adc_change34_reg);	//BF changed
		WRITEADC(3, adc_ctr34_reg);
	
		mode->np_piodata = 0x00;
    	}
#ifdef _Debug_	
	if (Debug_Mode) printf("ctr %x actr %x tb %x pr %x tv1 %x tv2 %x tv1 %x tv2 %x trr %x trw %x cha %x adcch12 %x adcch34 %x adcctr12 %x adcctr34 %x\n", ctrl_reg, adc_ctrl_reg, timebase_reg, pre_reg, trg_val_CHI_reg, trg_val_CHII_reg, trg_val_CHIII_reg, trg_val_CHIV_reg, trig_range_reg, trig_width_reg, channel_Adr_add, adc_change12_reg, adc_change34_reg, adc_ctr12_reg, adc_ctr34_reg);
#endif
}

void Hardware::WRITEADC(unsigned char which, unsigned long value)
{	
	switch(which)
	{
		case 1 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 2 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 3 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 4 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
			
						ST		[%l0], %r0		
					");	
				break;
	}
}

unsigned long Hardware::READADC(unsigned char which)
{

	switch(which)
	{
		case 1 :
				asm("		
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0
					");	
				break;
		case 2 :
				asm("		
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 3 :
				asm("		
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 4 :
				asm("		
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
	}
}	
//#####################################################################################################################################################
//BF set registers for ADC reading with correction values and value count
void Hardware::PREPARE_READADC(unsigned char correct1, unsigned char correct2, unsigned char correct3, unsigned char correct4, unsigned int count)
{
    asm("
            MOV		%r3, %i0
            MOV		%r4, %i1
            MOV		%r5, %i2
            MOV		%r6, %i3
            MOV		%r7, %i4
        ");
}
//#####################################################################################################################################################
//BF sort, correct and recalculate ADC-values
//BF changed by Stefan to avoid correction error in inverting and averaging mode
void Hardware::READADC_ALL(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{

    asm("
            PFX	%hi(0xFEFEFEFE)                   ; Set MASK
            MOVI	%r10,%lo(0xFEFEFEFE)
            PFX	%xhi(0xFEFEFEFE)
            MOVHI	%r10,%xlo(0xFEFEFEFE)

            MOV		%l1, %r7               ; set address offset memory 2

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow                ; jump to slow tb configuration
            NOP                   									

            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x0001)
            ADDI    %l4, %lo(0x0001);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x0002)
            ADDI    %l5, %lo(0x0002);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x0003)
            ADDI    %l6, %lo(0x0003);

            BR      lpr_channel
            NOP

        lpr_slow:
            MOV		%l4, %i1               ; set address offset memory 2
            PFX     %hi(0x1000)
            ADDI    %l4, %lo(0x1000);
						
            MOV		%l5, %i1               ; set address offset memory 3
            PFX     %hi(0x2000)
            ADDI    %l5, %lo(0x2000);
						
            MOV		%l6, %i1               ; set address offset memory 4
            PFX     %hi(0x3000)
            ADDI    %l6, %lo(0x3000);

      lpr_channel:


            PFX     %hi(0x00917440)         ; load address channel
            MOVI	%l0,%lo(0x00917440)
            PFX		%xhi(0x00917440)
            MOVHI	%l0,%xlo(0x00917440)

	
        lpr1:
            LD		%l2, [%l0]
            NOT     %l2	
            
            ; start mem 1			
            MOV		%r0, %l2  							


            EXT8S	%r0, 0
	
	    SUB     %r0, %r3		;Offsetadjustment (Stefan)

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            IFRZ      %i2                 ; inverting
            BR        lpr1s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr1i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel	
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0	
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
	
            BR        lpr1s
            NOP		

        lpr1i:

            MOV       %r2, %i3            ; store ZeroLevel		
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0		
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v		
            PFX       %hi(0)
            MOVI      %r2, %lo(0)	
	
            MOV       %r0, %r2            ; store result

            ; end inverting		

						
        lpr1s:
      						
            IFRZ      %i4                 ; is average = 0
            BR        lpr1e
            NOP						
	
            ; start averaging

            LD        %l7, [%i1]          ; save old value
            EXT8D     %l7, %i1            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr1a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr1e
            NOP	
						
        lpr1a:

            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1	
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr1e:							

						
            FILL8	%r0, %r0
            ST8D	[%i1], %r0
					
            ; start mem 2		
            MOV		%r0, %l2  

            EXT8S	%r0, 1
	
	    SUB     %r0, %r4		; offsetadjustment(Stefan)
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)		
			
            IFRZ      %i2                 ; inverting
            BR        lpr2s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr2i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel		
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0		
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
	
            BR        lpr2s
            NOP			
						
        lpr2i:

            MOV       %r2, %i3            ; store ZeroLevel		
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0			
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v		
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result

            ; end inverting		
						
						
        lpr2s:
	
            IFRZ      %i4                 ; is average = 0
            BR        lpr2e
            NOP						
	
            ; start averaging

            LD        %l7, [%l4]          ; save old value
            EXT8D     %l7, %l4            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr2a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr2e
            NOP	
						
        lpr2a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr2e:							
            			
            FILL8	%r0, %r0
            ST8D	[%l4], %r0

            ; start mem 3								
            MOV     %r0, %l2  							

            EXT8S	%r0, 2
			            
			SUB     %r0, %r5			;offsetadjustment(Stefan)

            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            IFRZ    %i2                 ; inverting
            BR      lpr3s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr3i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)		
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr3s
            NOP								
						
        lpr3i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr3s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr3e
            NOP						
	
            ; start averaging

            LD        %l7, [%l5]          ; save old value
            EXT8D     %l7, %l5            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr3a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr3e
            NOP	
						
        lpr3a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr3e:							
						
            FILL8	%r0, %r0
            ST8D	[%l5], %r0
			
            ; start mem 4								
            MOV		%r0, %l2  							

            EXT8S	%r0, 3
			
			SUB     %r0, %r6				;offsetadjustment (Stefan)
			
            IFS     cc_n
            PFX     %hi(0)
            MOVI    %r0, %lo(0)	
						
            IFRZ      %i2                 ; inverting
            BR        lpr4s
            NOP						
						
            ; start inverting
						
            CMP       %r0, %i3            ; is Vnew > ZL
            IFS       cc_nc
            BR        lpr4i
            NOP						
						
            ; Vnew < ZeroLevel
						
            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r2, %r0            ; ZL - Vnew = Vcalc0						
            ADD       %r2, %i3            ; Vcalc0 + ZL = Vcalc1
						
            PFX       %hi(255)
            CMPI      %r2, %lo(255)
            IFS       cc_nc
            PFX       %hi(255)
            MOVI      %r2, %lo(255)	; (0) ???	
						
            MOV       %r0, %r2            ; store result
                        						
            BR        lpr4s
            NOP								
						
        lpr4i:

            MOV       %r2, %i3            ; store ZeroLevel							
            SUB       %r0, %r2            ; Vnew - ZL = Vcalc0						
            SUB       %r2, %r0            ; ZL - Vcalc0 = Vcalc1
            IFS       cc_v						
            PFX       %hi(255)
            MOVI      %r2, %lo(255)								
						
            MOV       %r0, %r2            ; store result

            ; end inverting						
						
						
        lpr4s:
                    						
            IFRZ      %i4                 ; is average = 0
            BR        lpr4e
            NOP						
	
            ; start averaging

            LD        %l7, [%l6]          ; save old value
            EXT8D     %l7, %l6            ; extract byte

            CMP       %r0, %l7
            IFS       cc_nc
            BR        lpr4a						
            NOP
						
            ; Vnew < ZL

            MOV       %r2, %l7            ; store Vold	
            SUB       %r2, %r0            ; Vold - Vnew = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1
            SUB       %l7, %r2            ; Vold - Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0

            BR        lpr4e
            NOP	
						
        lpr4a:
                	
            ; Vnew > ZL
						
            MOV       %r2, %r0            ; store Vnew	
            SUB       %r2, %l7            ; Vnew - Vold = Vcalc0
            LSR       %r2, %i4            ; Vcalc0 >> avg = Vcalc1						
            ADD       %l7, %r2            ; Vold + Vcalc1 = Vcalc2

            MOV       %r0, %l7            ; store result in r0
						
        lpr4e:							
            			
            FILL8	%r0, %r0
            ST8D	[%l6], %r0


            ADDI   %l0, 4                            ; Add Address Counter

            IFRZ    %i5                     ; highspeeed timebases?
            BR      lpr_slow_ac             ; jump to slow address calculaten
            NOP
						
            ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter
            ADDI   %l4, 4                            ; Add Address Counter
            ADDI   %l5, 4                            ; Add Address Counter
            ADDI   %l6, 4                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP	

            BR     lprend
            NOP	


        lpr_slow_ac:
            ; calc new adresses
            ADDI   %i1, 1                            ; Add Address Counter
            ADDI   %l4, 1                            ; Add Address Counter
            ADDI   %l5, 1                            ; Add Address Counter
            ADDI   %l6, 1                            ; Add Address Counter
                        	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1	
            NOP

        lprend:		
    ");

}
//#####################################################################################################################################################
//BF -> get data from ADC  -  Assembler routine 
void Hardware::READADC_ALL2(unsigned char which, unsigned long *DataArray1, unsigned int count)
{

    asm("
            CMPI    %i0, 0x01               ; Is it channel 1
            IFS     cc_z
            BR      lpr1ch1n
            NOP

            CMPI    %i0, 0x02               ; Is it channel 2
            IFS     cc_z
            BR      lpr1ch2n
            NOP

            CMPI    %i0, 0x03               ; Is it channel 3
            IFS     cc_z
            BR      lpr1ch3n
            NOP

            CMPI    %i0, 0x04               ; Is it channel 4
            IFS     cc_z
            BR      lpr1ch4n
            NOP

        lpr1ch1n:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI	%l0,%lo(0x00A00000)
            PFX		%xhi(0x00A00000)
            MOVHI	%l0,%xlo(0x00A00000)
            BR      lpr1n
            NOP

        lpr1ch2n:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI	%l0,%lo(0x00A00010)
            PFX		%xhi(0x00A00010)
            MOVHI	%l0,%xlo(0x00A00010)
            BR      lpr1n
            NOP

        lpr1ch3n:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI	%l0,%lo(0x00A00020)
            PFX		%xhi(0x00A00020)
            MOVHI	%l0,%xlo(0x00A00020)
            BR      lpr1n
            NOP

        lpr1ch4n:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI	%l0,%lo(0x00A00030)
            PFX		%xhi(0x00A00030)
            MOVHI	%l0,%xlo(0x00A00030)
	
        lpr1n:
            LD		%l2, [%l0]
	
            MOV		%r0, %l2  	

            ST  	[%i1], %r0
						
           					 ; calc new adresses
            ADDI   %i1, 4                            ; Add Address Counter

            SUBI   %i2, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     lpr1n	
            NOP
    ");

}

//#####################################################################################################################################################
//BF -> get data from ADC
//BF new C-coded hardware routine as replacement for READADC_ALL2()
void Hardware::ADC_ReadData(unsigned char which, unsigned long *DataArray1, unsigned int count)
{

		//coded by Guido

		unsigned long *source=0;
		
			
		switch (which)
		{
			case  	1:
				source = ((unsigned long*)(0x00A00000)); 	//load address channel 1
				break;
				
			case	2:
				source = ((unsigned long*)(0x00A00010));	//load address channel 2
				break;
				
			case	3:
				source = ((unsigned long*)(0x00A00020));	//load address channel 3
				break;
				
			case	4:
				source = ((unsigned long*)(0x00A00030)); 	//load address channel 4
				break;
		}	
		for (unsigned int i = 0; i < count; i++)
		{
			DataArray1[i] = *source;
		}

}

//#####################################################################################################################################################
//BF sort, correct and recalculate ADC-values
//BF new C-coded hardware routine as replacement for READADC_ALL()
void Hardware::ADC_ProcessData(unsigned char which, unsigned char *DataArray1, unsigned char inverse, unsigned int zero, unsigned char averageval, unsigned char highspeed)
{
	//coded by Guido

	static unsigned long mask = 0xFEFEFEFE;  	//set MASK (but never use it???)
	static unsigned int lw_count = 4096;		//number of longwords to work on, should be a parameter
	static unsigned char *chan_addr;		//input-buffer			
	static unsigned int loop, i;			//control
	static unsigned char byte_data; 		//byte to work on
	static unsigned char temp_byte;	
	static int temp_int;		
	static unsigned char correct[4];		//channeldependend correctionvalues	
	static unsigned char *DataArray2;
	static unsigned int zero2;
		
	DataArray2 = DataArray1;		
	zero2 = zero << 1;
	
	chan_addr = ((unsigned char*)(0x00917440)); //channel_address = readout_sigbuf, READADC_ALL2 filled this buffer	
	if (highspeed == 1)	//timebase < 7
/*	//Guido: testing:
	{
		for (loop = 0; loop < 4096; loop++)
		{
			byte_data = *(chan_addr);
			byte_data = ~byte_data;
			*(DataArray2) = byte_data;;	
			*(DataArray2 + 1) = byte_data;;	
			//byte_data = *(chan_addr + 2);
			//byte_data = ~byte_data;					
			*(DataArray2 + 2) = byte_data;;	
			*(DataArray2 + 3) = byte_data;;		
			DataArray2 += 4;
			chan_addr += 4;
		}	
	}
*/
	{
		// this was done bei PREPARE_READADC (now obsolete): load the channel's correctionvalues
		for (i = 0; i < 4; i++) correct[i] = ADC_Offset[(which - 1)][i];

		for (loop = 0; loop < lw_count; loop++)		
		{	
			byte_data = *(chan_addr);	//load first byte
			byte_data = ~byte_data;		//invert it bitwise			
			if (byte_data > correct[0]) byte_data -= correct[0];	//offsetadjustment (stefan put it here)
			else byte_data = 0;
			if (inverse == 1)
			{			
				temp_int = zero2 - byte_data;
				if (temp_int < 0) temp_int = 0;		//limit to byte
				else if (temp_int > 255) temp_int = 255;	
				byte_data = temp_int;				
			}	
			if (averageval != 0) //then start averaging				
			{
				temp_byte = *(DataArray2);		//load old value as byte
				byte_data = (unsigned char)(((unsigned short)byte_data + (unsigned short)temp_byte) >> 1);
			}
			*(DataArray2) = byte_data;	//store result	
			
			byte_data = *(chan_addr);	//load second byte
			byte_data = ~byte_data;		//invert it bitwise			
			if (byte_data > correct[1]) byte_data -= correct[1];	//offsetadjustment (stefan put it here)
			else byte_data = 0;
			if (inverse == 1)
			{			
				temp_int = zero2 - byte_data;
				if (temp_int < 0) temp_int = 0;		//limit to byte
				else if (temp_int > 255) temp_int = 255;	
				byte_data = temp_int;				
			}	
			if (averageval != 0) //then start averaging				
			{
				temp_byte = *(DataArray2 + 1);		//load old value as byte
				byte_data = (unsigned char)(((unsigned short)byte_data + (unsigned short)temp_byte) >> 1);
			}
			*(DataArray2 + 1) = byte_data;	//store result	
			
			byte_data = *(chan_addr);	//load third byte
			byte_data = ~byte_data;		//invert it bitwise			
			if (byte_data > correct[2]) byte_data -= correct[2];	//offsetadjustment (stefan put it here)
			else byte_data = 0;
			if (inverse == 1)
			{			
				temp_int = zero2 - byte_data;
				if (temp_int < 0) temp_int = 0;		//limit to byte
				else if (temp_int > 255) temp_int = 255;	
				byte_data = temp_int;				
			}	
			if (averageval != 0) //then start averaging				
			{
				temp_byte = *(DataArray2 + 2);		//load old value as byte
				byte_data = (unsigned char)(((unsigned short)byte_data + (unsigned short)temp_byte) >> 1);
			}
			*(DataArray2 + 2) = byte_data;	//store result	
			
			byte_data = *(chan_addr);	//load last byte
			byte_data = ~byte_data;		//invert it bitwise			
			if (byte_data > correct[3]) byte_data -= correct[3];	//offsetadjustment (stefan put it here)
			else byte_data = 0;
			if (inverse == 1)
			{			
				temp_int = zero2 - byte_data;
				if (temp_int < 0) temp_int = 0;		//limit to byte
				else if (temp_int > 255) temp_int = 255;	
				byte_data = temp_int;				
			}	
			if (averageval != 0) //then start averaging				
			{
				temp_byte = *(DataArray2 + 3);		//load old value as byte
				byte_data = (unsigned char)(((unsigned short)byte_data + (unsigned short)temp_byte) >> 1);
			}
			*(DataArray2 + 3) = byte_data;	//store result	
			DataArray2 += 4;
			chan_addr += 4;
		}	
	}	
	else	//timebase > 6: only use ADC0
	{
		for (loop = 0; loop < lw_count; loop++)		
		{	
			byte_data = *(chan_addr);	//load one byte
			byte_data = ~byte_data;		//invert it bitwise	
			// nothing to correct as only one ADC is used		
			//if (byte_data > correct[0]) byte_data -= correct[0];	//offsetadjustment (stefan put it here)
			//else byte_data = 0;
			if (inverse == 1)
			{			
				temp_int = zero2 - byte_data;
				if (temp_int < 0) temp_int = 0;		//limit to byte
				else if (temp_int > 255) temp_int = 255;	
				byte_data = temp_int;				
			}	
			if (averageval != 0) //then start averaging				
			{
				temp_byte = *(DataArray2);		//load old value as byte
				byte_data = (unsigned char)(((unsigned short)byte_data + (unsigned short)temp_byte) >> 1);
			}
			*(DataArray2) = byte_data;	//store result	
			DataArray2 += 1;
			chan_addr += 4;		
		}
	}

}


//#####################################################################################################################################################

void Hardware::DoEnableADCInterrupt(void)							// Enable ADC service routine
{
	acq_ready->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	acq_ready->np_piodirection = 0;								// set bit to input
	acq_ready->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_data_acq_interrupt_irq,ISR_ADC_INT,(int)acq_ready);		// Install ISR for ADC
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt enabled.\n"); 							// print on console
#endif
}
//#####################################################################################################################################################

void Hardware::DoDisableADCInterrupt(void)							// Disable ADC service routine
{
	
	nr_installuserisr(na_data_acq_interrupt_irq,0,0); 				// Install empty routine for adc irq
	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt disabled.\n"); 							// print on console
#endif	
}
//#####################################################################################################################################################

void Hardware::ISR_ADC_INT(int context)						// ADC interrupt subroutine
{
	long buffer;
	int ix2;
	
	adc_started = false;
	
	acq_ready->np_pioedgecapture = 0;
	
	ADC_Data_Available = 1;
	//printf("ADC ready - data available\n");

}
//#####################################################################################################################################################

int Hardware::Read_IRQ(void)
{
    return acq_ready->np_piodata;
}
//#####################################################################################################################################################
void Hardware::Handle_ADC(void)						// ADC handler
{
	
	//out_test->np_piodata = 0x01;	// Testbit+++++++++++++++++++++++
	volatile long buffer_addr = 0;	
//BF del not used	volatile long buffer_peak = 0;	
	volatile long buffer_written = 0;	
//BF not used	volatile long buffer_adradd = 0;

//BF not used 	int channel_trig = 0;
	
	//BF del if (UI_request)	return;				// BF add  don't handle ADC if user interface must be handled
	//BF -> must be handled because of zero level adjustment!

	if (RC_request)	return;				// BF signal recall is requested -> don't handle ADC

		
	if (ADC_Data_Available == 0) return;		// if no new data is available return
	
	ADC_Data_Available = 0;				// reset availability flag	

//printf("ADC data available,");

	if (SingleMode == 1)				// handle single mode
	{
		SingleMode = 0;	

		// Run/Stop LED red
		LED_ON[12] = 0;
		LED_ON[13] = 1;			
		
		// Single Mode LED green
		LED_ON[14] = 0;
		LED_ON[15] = 1;	
		Send_LED();
	}
	else if(!Continius) return;			// BF add don't read the new data when stop mode is active and no single shot is done 
	
	data_adr->np_piodata = 0x01;

	if ((Selected_Trigger_Source == 3) || (Selected_Trigger_Source == 4))	
	{
		buffer_addr = READADC(3);
//BF del		buffer_peak = READADC(3);
	}
	else 
	{
		buffer_addr = READADC(1);
//BF del 		buffer_peak = READADC(1);
	}

	AutoFreeRun = false;

//printf("buffer_addr =  %x, ", buffer_addr);	

#ifdef _Debug_	
//if ((Debug_Mode) && (ADC_Debug_Mode)) printf("Peak %x \n", buffer_peak);
#endif

	if ((buffer_addr & 0x00001000) == 0x00001000)
	{
		if ((buffer_addr & 0x00000FFF) == 0x00000000)
		{
			// buffer_written = (buffer_addr & 0x00000FFF) + ((pre_reg - 8) >> 1);
			if (Selected_Timebase < 9) buffer_written = (buffer_addr & 0x00000FFF) + ((pre_reg - 8) >> 1);
			else buffer_written = (buffer_addr & 0x00000FFF) + (pre_reg - 8);
		}
		else
		{
			//buffer_written = pre_reg >> 1;
			if (Selected_Timebase < 9) buffer_written = pre_reg >> 1;
			else buffer_written = pre_reg;
		}
	
		AutoFreeRun = true;
		
		//printf("Auto Free Run   RA : %4x  RW : %4x\n", buffer_addr, buffer_written);
	}
	else if (Selected_Timebase < 7) buffer_written = ((buffer_addr & 0x0FFF) - (pre_reg >> 1)) & 0x00000FFF;
	else buffer_written = ((buffer_addr & 0x0FFF) - pre_reg) & 0x00000FFF;
			
//BF not used   	channel_trig = (buffer_addr & 0xC000) >> 14;



//	if (1 == 2)//(USTB_Mode == USTB_OFF)	//don't trigger if ultra slow tb mode is active BF #022
	{
		if (NumberOfChannels < 4)
		{				
			if ((triggering != 0) || (Selected_Trigger_Source == 5))
			{
				WRITEADC(1, buffer_written);
				WRITEADC(2, buffer_written);
//printf("buffer_written =  %x, ", buffer_written);
			} 
			else
			{
				WRITEADC(1, 0);  //BF del ram_adress_reg + buffer_adradd);
				WRITEADC(2, 0);  //BF del ram_adress_reg + buffer_adradd);
//printf("address =  %x, ", 0);
		//   printf("Write FreeRun Address 0x00 \n");
			}
		}
		else
		{				
			if ((triggering != 0) || (Selected_Trigger_Source == 5))
			{		
				WRITEADC(1, buffer_written);
				WRITEADC(2, buffer_written);
				WRITEADC(3, buffer_written);
				WRITEADC(4, buffer_written);
//printf("buffer_written =  %x, ", buffer_written);
			}
			else
			{
				WRITEADC(1, 0);  //BF del ram_adress_reg + buffer_adradd);
				WRITEADC(2, 0);  //BF del ram_adress_reg + buffer_adradd);
				WRITEADC(3, 0);  //BF del ram_adress_reg + buffer_adradd);
				WRITEADC(4, 0);  //BF delram_adress_reg + buffer_adradd);
//printf("address =  %x, ", 0);
			//	printf("Write FreeRun Address 0x00 \n");
			}
		}
	
	}	


	data_adr->np_piodata = 0x00;
	
	
	if(test_signal)		// generate test signals
	{ Signal::TestSignalGenerate(); }
	else			// get real values
	{
		if (Channel_1_Active)
		{ ReadOut_Signal(1, buffer_addr & 0x3FFF); }
		
		if (Channel_2_Active)
		{ ReadOut_Signal(2, buffer_addr & 0x3FFF); }	
		
		if (NumberOfChannels == 4)
		{	
			if (Channel_3_Active == 1)
			{ ReadOut_Signal(3, buffer_addr & 0x3FFF); }
		
			if (Channel_4_Active == 1)
			{ ReadOut_Signal(4, buffer_addr & 0x3FFF); }
		}	
	}

//printf("Acquisition ready!\r\n");

	//----------------------------------------------------------------------------------
	//				Trigger Time Offset
	//----------------------------------------------------------------------------------
	if (USTB_Mode == USTB_OFF)	//don't trigger if ultra slow tb mode is active
	{
		if (triggering != 0)
		{
			if (((Selected_Trigger_Source > 0) && (Selected_Trigger_Source < 5)) && (AutoFreeRun == false))
			{
				//BF -> this is only to make the triggered signal less "nervous" and more stable, but it works also with
				//	a constant value of 80 for Trigger_Offset_Calc
				Trigger_Offset_Calc = FindTrigger(Selected_Trigger_Source, MenuStatus[MENU_TRIGGEREDGE][0] - 2, Trig_Pos_Mem + 50) - Trig_Pos_Mem;
				//Trigger_Offset_Calc = 80;
			}
			else
			{ Trigger_Offset_Calc = ExtTrigOffset[Timebase_Idx]; }	//BF #022
			//{ Trigger_Offset_Calc = -15; }

			//added by Stefan for combi-trigger	
			if (MenuStatus[MENU_TRIGGERMODE][0] == 94 && CombiTriggerStatus >= 1)	//combi-trigger -> auto-mode enabled
			{
				//search for signal crossing triggervalue
				//calc borders
				unsigned char min=0,max=0;
				static unsigned char oldMin=0,oldMax=0;
				unsigned char *pSignal=0;
				unsigned char tvalue=0;
				
				if (CombiTriggerStatus == 1)	//if first time triggered by auto after switching to auto, reset oldMin,oldMax
				{
				  oldMin=255;
				  oldMax=0;
				  CombiTriggerStatus=2;
				}
				
				//calc border for searching min and max in signal
				short start = (short) MemWinStart + Trigger_Offset_Calc;
				if (start < 0) start = 0;
				
				short stop = start + ((GRID_WIDTH + 30) * draw_factor);
				if (stop > 16383){stop = 16383;}

				switch (Selected_Trigger_Source)
				{
				  case 1:
					pSignal=SIGNAL1;
					tvalue = (int)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH1][GainIdx])+ADC_ZERO;
					break;
				  case 2:
					pSignal=SIGNAL2;
					tvalue = (int)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH2][GainIdx])+ADC_ZERO;
					break;
				  case 3:
					pSignal=SIGNAL3;
					tvalue = (int)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH3][GainIdx])+ADC_ZERO;
					break;
				  case 4:
					pSignal=SIGNAL4;
					tvalue = (int)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH4][GainIdx])+ADC_ZERO;
					break;
					
				}

				Signal::CalcMinMax(start,stop,1,pSignal,&min,&max);	
				
				if (((oldMin<tvalue) && (max>tvalue)) || ((oldMax>tvalue) && (min<tvalue)) || (min<tvalue && max>tvalue))
				{
					//triggervalue crossed--> enable normal-mode
					ctrl_reg &= 0xFFBF;		//activate normal-mode
					noTriggerTime      = 0;		//reset time-measurement
					CombiTriggerStatus = 0;		//reset standard-trigger-status to normal-mode
					SetupADC();
				}
				oldMax=max;
				oldMin=min;
			 
			}
			else	//combi-trigger -> normal-mode
			{ noTriggerTime = 0; }//reset time, because trigger-event occured within 500ms

		}
		else
		{ Trigger_Offset_Calc = 0; }
		//printf("TOC %d\r\n", Trigger_Offset_Calc);
	}

	
//    if ((QM_Enabled) && (QM_Type[0] > 0)) Display::CALCQMDATA();	
	

	//----------------------------------------------------
	//BF FFT mode
	//----------------------------------------------------
	if (FFT_Mode != FFT_OFF)	
	{ FFT_NewData = 1; }


	//----------------------------------------------------
	//BF USTB mode
	//----------------------------------------------------
	if (USTB_Mode == USTB_OFF)	//ultra slow tb mode off
	{
		//BF add new start/stop logic
		if ((!SingleMode) && (Continius))		//BF del && (!OneShotRestart))
		{ Start_Record(); } 
	}
	else if	((USTB_Mode != USTB_OFF) && Continius)	//ultra slow tb mode on
	{ USTB_NewData = 1; }	//New data for roll/shift mode available
	
	ACQ_NewData = 1;	//New signal data acquired

 
}
//#####################################################################################################################################################
// BF deleted unused parameter -> found by Stefan
void Hardware::ReadOut_Signal(char channel, unsigned long adr_read)
{
	int ix, ix2, ix3, enddata;
	int chk_calc     = 0;
	long buffer_long = 0;
	unsigned int read_out_count = 4096;
	int Virtual_Zero;	//BF new

	//if (MenuStatus[MENU_TIMEBASE][2] == 1) read_out_count = 0x100;

	if (USTB_Mode != USTB_OFF)	//ultra slow tb mode?
	read_out_count = 128;
	else
	read_out_count = 4096;

	switch(channel)
	{	
		//--------------------------------------------------
		//                   Channel 1
		//--------------------------------------------------
		case 1 :	
		{
			Virtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]);

			if (Virtual_Zero > 255) Virtual_Zero = 255;	//Limiter
			if (Virtual_Zero < 0) Virtual_Zero = 0;
			
			//channel coupling = ground -> set all values to zero (ADC_ZERO = 127) 		BF -> new ground function 
			if (MenuStatus[MENU_CHANNEL1][0] == 6) //GND-coupling
			{ for(int i=0;i<0x4000;i++) SIGNAL1[i] = Virtual_Zero; }
			else
			{

				//BF #001 set buffer to base address if correction is active
				if(Selected_Timebase < 5)
				{SIGNAL1 = (unsigned char *) 0x0091CC00;}
				

				buffer_long = READADC(1);    // Read correction
				buffer_long = READADC(1);

/*BF test coding 		
				if(test_sw1)	//BF -> new C-routines for testing
				{
					ADC_ReadData(1, &readout_sigbuf[0], read_out_count);
					 					
					if (Selected_Timebase < 7 || USTB_Mode != USTB_OFF) //Highspeed
					{
						if (MenuStatus[MENU_ACQUIRE][1] == 1)
						{ ADC_ProcessData(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 1, 1); }	
						else
						{ ADC_ProcessData(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 0, 1); }	
				
					}
					else	//Lowspeed
					{
						if (MenuStatus[MENU_ACQUIRE][1] == 1)
						{ ADC_ProcessData(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 1, 0); }	
						else
						{ ADC_ProcessData(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 0, 0); }	
					}
				}
//BF test end	
				else	//BF -> Assembler routines as standard
*/				{
					READADC_ALL2(1, &readout_sigbuf[0], read_out_count);
					PREPARE_READADC(ADC_Offset[0][0],ADC_Offset[0][1],ADC_Offset[0][2],ADC_Offset[0][3], read_out_count);	
					
					if (Selected_Timebase < 7 || USTB_Mode != USTB_OFF) //Highspeed
					{
						if (MenuStatus[MENU_ACQUIRE][1] == 1)
						{ READADC_ALL(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 1, 1); }	
						else
						{ READADC_ALL(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 0, 1); }	
				
					}
					else	//Lowspeed
					{
						if (MenuStatus[MENU_ACQUIRE][1] == 1)
						{ READADC_ALL(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 1, 0); }	
						else
						{ READADC_ALL(1, &SIGNAL1[0], MenuStatus[MENU_CHANNEL1][2] - 240, Virtual_Zero, 0, 0); }	
					}
				}
				
				//BF #001 set buffer to corrected address if delay correction is active (buffer shift)
				if(Selected_Timebase < 5)
				{SIGNAL1 = &SIGNAL1[-CH1_Del_Correct];}
//printf("Ch1, ");
			}

			break;
		}
		//--------------------------------------------------
		//                   Channel 2
		//--------------------------------------------------
		case 2 :
		{
			Virtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]);
			if (Virtual_Zero > 255) Virtual_Zero = 255;	//Limiter
			if (Virtual_Zero < 0) Virtual_Zero = 0;

			//channel coupling = ground -> set all values to zero (ADC_ZERO = 127) 		BF -> new ground function 
			if (MenuStatus[MENU_CHANNEL2][0] == 6) 
			{ for(int i=0;i<0x4000;i++) SIGNAL2[i] = Virtual_Zero; }
			else
			{
				//BF #001 set buffer to base address if correction is active
				if(Selected_Timebase < 5)
				{SIGNAL2 = (unsigned char *) 0x00920C00;}


				buffer_long = READADC(2);    // Read correction
				buffer_long = READADC(2);
					
				READADC_ALL2(2, &readout_sigbuf[0], read_out_count);
				PREPARE_READADC(ADC_Offset[1][0],ADC_Offset[1][1],ADC_Offset[1][2],ADC_Offset[1][3], read_out_count);
		
				if (Selected_Timebase < 7 || USTB_Mode != USTB_OFF) //Highspeed
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(2, &SIGNAL2[0], MenuStatus[MENU_CHANNEL2][2] - 240, Virtual_Zero, 1, 1); }
					else
					{ READADC_ALL(2, &SIGNAL2[0], MenuStatus[MENU_CHANNEL2][2] - 240, Virtual_Zero, 0, 1); }
			
				}
				else	//Lowspeed
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(2, &SIGNAL2[0], MenuStatus[MENU_CHANNEL2][2] - 240, Virtual_Zero, 1, 0); }
					else
					{ READADC_ALL(2, &SIGNAL2[0], MenuStatus[MENU_CHANNEL2][2] - 240, Virtual_Zero, 0, 0); }
				}

				//BF #001 set buffer to corrected address if correction is active (buffer shift)
				if(Selected_Timebase < 5)
				{SIGNAL2 = &SIGNAL2[-CH2_Del_Correct];}
//printf("Ch2, ");
			}
            		break;
        	}
		//--------------------------------------------------
		//                   Channel 3
		//--------------------------------------------------
		case 3 :
		{
			Virtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3][GainIdx]);
			if (Virtual_Zero > 255) Virtual_Zero = 255;	//Limiter
			if (Virtual_Zero < 0) Virtual_Zero = 0;

			//channel coupling = ground -> set all values to zero (ADC_ZERO = 127) 		BF -> new ground function 
			if (MenuStatus[MENU_CHANNEL3][0] == 6) 
			{ for(int i=0;i<0x4000;i++) SIGNAL3[i] = Virtual_Zero; }
			else
			{
				//BF #001 set buffer to base address if correction is active
				if(Selected_Timebase < 5)
				{SIGNAL3 = (unsigned char *) 0x00924C00;}

				buffer_long = READADC(3);    // Read correction
				buffer_long = READADC(3);
//BF test del				buffer_long = READADC(3);    // Read correction
				
				// Get new Signal Data
				READADC_ALL2(3, &readout_sigbuf[0], read_out_count);
				PREPARE_READADC(ADC_Offset[2][0],ADC_Offset[2][1],ADC_Offset[2][2],ADC_Offset[2][3], read_out_count);
			
				if (Selected_Timebase < 7 || USTB_Mode != USTB_OFF)
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(3, &SIGNAL3[0], MenuStatus[MENU_CHANNEL3][2] - 240, Virtual_Zero, 1, 1); }
					else
					{ READADC_ALL(3, &SIGNAL3[0], MenuStatus[MENU_CHANNEL3][2] - 240, Virtual_Zero, 0, 1); }
			
				}
				else
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(3, &SIGNAL3[0], MenuStatus[MENU_CHANNEL3][2] - 240, Virtual_Zero, 1, 0); }
					else
					{ READADC_ALL(3, &SIGNAL3[0], MenuStatus[MENU_CHANNEL3][2] - 240, Virtual_Zero, 0, 0); }
				}

				//BF #001 set buffer to corrected address if delay correction is active (buffer shift)
				if(Selected_Timebase < 5)
				{SIGNAL3 = &SIGNAL3[-CH3_Del_Correct];}
//printf("Ch3, ");

			}
			break;
		}
		//--------------------------------------------------
		//                   Channel 4
		//--------------------------------------------------
		case 4 :	
		{
			Virtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4][GainIdx]);
			if (Virtual_Zero > 255) Virtual_Zero = 255;	//Limiter
			if (Virtual_Zero < 0) Virtual_Zero = 0;

			//channel coupling = ground -> set all values to zero (ADC_ZERO = 127) 		BF -> new ground function 
			if (MenuStatus[MENU_CHANNEL4][0] == 6) 
			{ for(int i=0;i<0x4000;i++) SIGNAL4[i] = Virtual_Zero; }
			else
			{

				//BF #001 set buffer to base address if correction is active
				if(Selected_Timebase < 5)
				{SIGNAL4 = (unsigned char *) 0x00928C00;}

				buffer_long = READADC(4);    // Read correction
				buffer_long = READADC(4);
//BF test del				buffer_long = READADC(4);
				
				// Get new Signal Data
				READADC_ALL2(4, &readout_sigbuf[0], read_out_count);
				PREPARE_READADC(ADC_Offset[3][0],ADC_Offset[3][1],ADC_Offset[3][2],ADC_Offset[3][3], read_out_count);
	
				if (Selected_Timebase < 7 || USTB_Mode != USTB_OFF)
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(4, &SIGNAL4[0], MenuStatus[MENU_CHANNEL4][2] - 240, Virtual_Zero, 1, 1); }
					else
					{ READADC_ALL(4, &SIGNAL4[0], MenuStatus[MENU_CHANNEL4][2] - 240, Virtual_Zero, 0, 1); }
				}
				else
				{
					if (MenuStatus[MENU_ACQUIRE][1] == 1)
					{ READADC_ALL(4, &SIGNAL4[0], MenuStatus[MENU_CHANNEL4][2] - 240, Virtual_Zero, 1, 0); }
					else
					{ READADC_ALL(4, &SIGNAL4[0], MenuStatus[MENU_CHANNEL4][2] - 240, Virtual_Zero, 0, 0); }
				}

				//BF #001 set buffer to corrected address if correction is active (buffer shift)
				if(Selected_Timebase < 5)
				{SIGNAL4 = &SIGNAL4[-CH4_Del_Correct];}
//printf("Ch4, ");
			}
			break;

		}

	}//Ende switch channel
}
//#####################################################################################################################################################

/* BF not used
void Hardware::Do_Gen_Signal(void)	
{
    float wert;
    float grad;
    int icnt;

#ifdef _Debug_FFT_
    printf("starting generate signal\n");
#endif
    for(icnt = 0; icnt <= FFT_LENGTH; icnt++)
    {
        grad = (float) (icnt);
        
        if (((int)(grad * 0.015625) %2) == 0) wert = -1.0; // 0.03125
        else wert = 1.0;
               
	//BF change ->reactivated
        //fft_values[icnt] = wert;
        //BF change end
        //SIGNAL1[icnt] = ((unsigned char) ((wert * 30) + 128));
       // printf( "%d\n", (int) wert );
    }
#ifdef _Debug_FFT_
    printf("generate signal ready\n");
#endif
}
*/

//#####################################################################################################################################################
//BF new fix for trigger calculating by Stefan
int Hardware::FindTrigger(unsigned char channel, unsigned char negativ, int TriggerPos)
{
	int ix, foundat = 0, range = 50;
	int tl_buf = 0;
	
	unsigned char neg_buf = negativ;
	
	// if channel inverted
	if (MenuStatus[channel][2] == 241)
	{
		if (negativ) negativ = 0;
		else negativ = 1;
	}
	
	switch(channel)
	{
		case 1 : tl_buf = (int)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH1][GainIdx])+ADC_ZERO; break;//Stefan
		case 2 : tl_buf = (int)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH2][GainIdx])+ADC_ZERO; break;
		case 3 : tl_buf = (int)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH3][GainIdx])+ADC_ZERO; break;
		case 4 : tl_buf = (int)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/scale_factor[Selected_Voltage_CH4][GainIdx])+ADC_ZERO; break;
	}
	
	if (negativ)
	{
		switch(channel)
		{
			case 1 :
			{
				foundat = TriggerPos;
				for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
				{
					if (SIGNAL1[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case 2 :
			{
				foundat = TriggerPos;
				for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
				{
					if (SIGNAL2[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case 3 :
			{
				foundat = TriggerPos;
				for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
				{
					if (SIGNAL3[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case 4 :
			{
				foundat = TriggerPos;
				for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
				{
					if (SIGNAL4[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
		}
	}
	else
	{
		switch(channel)
		{
		case 1 :
		{
			foundat = TriggerPos;
			for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
			{
				if (SIGNAL1[ix] < tl_buf)
				{
					foundat = ix;
					break;
				}
			}
			break;
		}
		case 2 :
		{
			foundat = TriggerPos;
			for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
			{
				if (SIGNAL2[ix] < tl_buf)
				{
					foundat = ix;
					break;
				}
			}
			break;
		}
		case 3 :
		{
			foundat = TriggerPos;
			for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
			{
				if (SIGNAL3[ix] < tl_buf)
				{
					foundat = ix;
					break;
				}
			}
			break;
		}
		case 4 :
		{
			foundat = TriggerPos;
			for (ix = TriggerPos - range; ix < TriggerPos + range; ix++)
			{
				if (SIGNAL4[ix] < tl_buf)
				{
					foundat = ix;
					break;
				}
			}
			break;
		}
		}
	}
	
	return foundat;
}
//#####################################################################################################################################################
//Auto scale
int Hardware::AutoScale(void)
{
	int result = 0;

	triggering_bak   = triggering;
	ctrl_reg_bak     = ctrl_reg;
	adc_ctrl_reg_bak = adc_ctrl_reg;
/*	
	lChannel_1_bak = Channel_1_Active;
	lChannel_2_bak = Channel_2_Active;
	lChannel_3_bak = Channel_3_Active;
	lChannel_4_bak = Channel_4_Active;
*/	
	Continius_bak          = Continius;
	SingleMode_bak         = SingleMode;

/* BF del -> will be restored from flash
	Selected_Timebase_bak  = Selected_Timebase;
	SIGNALFaktor_idx_bak   = SIGNALFaktor_idx;
	SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
	timebase_reg_bak       = timebase_reg;
	Timebase_Idx_bak   = Timebase_Idx;

	Selected_Voltage_CH1_bak = Selected_Voltage_CH1;
	Selected_Voltage_CH2_bak = Selected_Voltage_CH2;
	Selected_Voltage_CH3_bak = Selected_Voltage_CH3;
	Selected_Voltage_CH4_bak = Selected_Voltage_CH4;   	
	
	ZeroLevelCH1_bak = ZeroLevelCH1;
	ZeroLevelCH2_bak = ZeroLevelCH2;
	ZeroLevelCH3_bak = ZeroLevelCH3;
	ZeroLevelCH4_bak = ZeroLevelCH4;
	
	Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
	Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
	Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
	Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;
	
	Trigger_Pos_CH1_bak = Trigger_Pos_CH1;	
	Trigger_Pos_CH2_bak = Trigger_Pos_CH2;
	Trigger_Pos_CH3_bak = Trigger_Pos_CH3;
	Trigger_Pos_CH4_bak = Trigger_Pos_CH4;
	
	Timebase_Offset_Pos_bak = Timebase_Offset_Pos;
	//Trigger_Offset_Pos_bak  = Trigger_Offset_Pos;	//BF del not used
	
	AC_CH1_bak = MenuStatus[MENU_CHANNEL1][0];
	AC_CH2_bak = MenuStatus[MENU_CHANNEL2][0];
	AC_CH3_bak = MenuStatus[MENU_CHANNEL3][0];
	AC_CH4_bak = MenuStatus[MENU_CHANNEL4][0];
	
	Invert_CH1_bak = MenuStatus[MENU_CHANNEL1][2];
	Invert_CH2_bak = MenuStatus[MENU_CHANNEL2][2];
	Invert_CH3_bak = MenuStatus[MENU_CHANNEL3][2];
	Invert_CH4_bak = MenuStatus[MENU_CHANNEL4][2];
	
	MAINMODE_bak = MenuStatus[MENU_TIMEBASE][0];
	//ROLLMODE_bak = MenuStatus[MENU_TIMEBASE][2];
	//BF del ROLLMODESTARTED_bak = ROLLMODE_STARTED;
	
	Acquire_bak_0 = MenuStatus[MENU_ACQUIRE][0];
	Acquire_bak_1 = MenuStatus[MENU_ACQUIRE][1];
	
	TriggerMode_bak = MenuStatus[MENU_TRIGGERMODE][0];
*/				
	Stop_Record();			
	AutoTimerOff = true;
	Search_Mode  = true;
	
	DoDisableUARTInterrupt();
	DoDisableADCInterrupt();
	DoDisableKeyInterrupt();
	DoDisableRotInterrupt();
	
	ADC_Data_Available = 0;
	acq_ready->np_pioedgecapture = 0;
		
	MenuStatus[MENU_TRIGGERMODE][0] = 92;
	MenuPopupStatus[9][0] = 3;
	MenuPopupStatus[9][1] = 2;
	
	// Averaging off			
	MenuStatus[MENU_ACQUIRE][1] = 0;
	MenuStatus[MENU_ACQUIRE][0] = 1;
				
	
	// All AC
//BF del	MenuStatus[MENU_CHANNEL1][0] = 7;
//BF del	MenuStatus[MENU_CHANNEL2][0] = 7;
//BF del	MenuStatus[MENU_CHANNEL3][0] = 7;
//BF del	MenuStatus[MENU_CHANNEL4][0] = 7;
	
	// All invert off
	MenuStatus[MENU_CHANNEL1][2] = 240;
	MenuStatus[MENU_CHANNEL2][2] = 240;
	MenuStatus[MENU_CHANNEL3][2] = 240;
	MenuStatus[MENU_CHANNEL4][2] = 240;
	
	
	
	Selected_Timebase  = 4;                                         //  50 nS
	SIGNALFaktor_idx   = 0;                                         // zoom factor 1 = 50 nS
	SIGNAL_StartFr_idx = 0;                                         // running. so 0
	
	timebase_reg = tb_value[Selected_Timebase];
	Timebase_Idx = 4;                                          // Displayed timebase is 50 ns
	
	triggering    = 0;								
	ctrl_reg      = 0x0087;							            // Trigger_Master / Trigger_INT / Free Run
	adc_ctrl_reg &= 0xFFF0;						                    // Disable Trigger sources
	
	pre_reg = 0x006C;
	//Trigger_Offset_Pos  = 353;	//BF not used
	Timebase_Offset_Pos = -300;
	
	// TMW complete changed (2-Channel Version)
	Virtual_ZeroLevelCH1 = 0;
	//BF del    CH1_Zero_Offset      = 0;
	
	Virtual_ZeroLevelCH2 = 0;
	//BF del    CH2_Zero_Offset      = 0;
	
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();
	
  	if ( NumberOfChannels == 4) // TMW complete changed (4-Channel Version)
 	{
		Virtual_ZeroLevelCH3 = 0;
//BF del    		CH3_Zero_Offset      = 0;
    		Virtual_ZeroLevelCH4 = 0;
//BF del    		CH4_Zero_Offset      = 0;

    		Rotary_Steps = 0;
    		UserIF::ON_Zero_Channel_3();
    		Rotary_Steps = 0;
    		UserIF::ON_Zero_Channel_4();
	}
 
	Trigger_Pos_CH1 = ZeroLevelCH1;
	Trigger_Pos_CH2 = ZeroLevelCH2;
	Trigger_Pos_CH3 = ZeroLevelCH3;
	Trigger_Pos_CH4 = ZeroLevelCH4;
	
	if (USTB_Mode != USTB_OFF)	//was USTB mode active?
	{
		Hardware::Stop_Timer2();

		//backup and deactivate roll/shift mode setting in menu
		USTB_Mode_bak = USTB_Mode;
		MenuStatus[MENU_TIMEBASE][3] = 246;
		MenuStatus[MENU_TIMEBASE][4] = 246;
		USTB_Mode = USTB_OFF;				//switch off USTB mode
	}

	if (Channel_1_Active) result = FindTimebase(1);
	else if (Channel_2_Active) result = FindTimebase(2);
	else if (Channel_3_Active) result = FindTimebase(3);
	else if (Channel_4_Active) result = FindTimebase(4);

//	Rotary_Steps = 0;		//BF added for switching USTB
//	UserIF::ON_Timebase();		//BF added for switching USTB

  // TMW complete changed (2-Channel Version)
   	 Virtual_ZeroLevelCH1 = 0;
//BF del    CH1_Zero_Offset      = 0;

  	  Virtual_ZeroLevelCH2 = 0;
//BF del    CH2_Zero_Offset      = 0;

	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();
	
  	if ( NumberOfChannels == 4) // TMW complete changed (4-Channel Version)
 	{
		Virtual_ZeroLevelCH3 = 0;
//BF del		CH3_Zero_Offset      = 0;
	
		Virtual_ZeroLevelCH4 = 0;
//BF del		CH4_Zero_Offset      = 0;
	
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_3();
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();
	}
 
	Trigger_Pos_CH1 = ZeroLevelCH1;
	Trigger_Pos_CH2 = ZeroLevelCH2;
	Trigger_Pos_CH3 = ZeroLevelCH3;
	Trigger_Pos_CH4 = ZeroLevelCH4;
			
	if (Channel_1_Active) FindVoltage(1);
	if (Channel_2_Active) FindVoltage(2);

	if (NumberOfChannels > 2)
	{
		if (Channel_3_Active) FindVoltage(3);
		if (Channel_4_Active) FindVoltage(4);
	}


    			
	AutoTimerOff = false;
	Search_Mode  = false;
	
	triggering = triggering_bak;
	ctrl_reg = ctrl_reg_bak;
	adc_ctrl_reg = adc_ctrl_reg_bak;
	
	Continius = Continius_bak;
	SingleMode = SingleMode_bak;
//BF del    UserIface_active = 0;
/*
    Trigger_Pos_CH1 = Trigger_Pos_CH1_bak;
    Trigger_Pos_CH2 = Trigger_Pos_CH2_bak;
    Trigger_Pos_CH3 = Trigger_Pos_CH3_bak;
    Trigger_Pos_CH4 = Trigger_Pos_CH4_bak;
*/


  	if ( NumberOfChannels == 2) // TMW complete changed (2-Channel Version)
	{
		if (Channel_2_Active)
			Virtual_ZeroLevelCH1 = -1 * GRID_HEIGHT / 4; 	//-96; BF
		else
			Virtual_ZeroLevelCH1 = 0;
		
//BF del		CH1_Zero_Offset = 0;
	
		if (Channel_1_Active)
			Virtual_ZeroLevelCH2 = GRID_HEIGHT / 4;		//96; BF
		else
			Virtual_ZeroLevelCH2 = 0;
		
//BF del		CH2_Zero_Offset = 0;
	
		Rotary_Steps = 0;
		if (Channel_1_Active)
		{
			UserIF::ON_Zero_Channel_1();
			Trigger_Pos_CH1 = ZeroLevelCH1 - 5;
		
			SetDacOffset(1);
			SetCHDacOffset(1);
		}
	
		Rotary_Steps = 0;
		if (Channel_2_Active)
		{
			UserIF::ON_Zero_Channel_2();
			Trigger_Pos_CH2 = ZeroLevelCH2 - 5;
		
			SetDacOffset(2);
			SetCHDacOffset(2);
		}
    	}
  	else // TMW complete changed (4-Channel Version)
	{
       		Virtual_ZeroLevelCH1 = -120;           
//BF del       		CH1_Zero_Offset = 0;
       		if (Channel_1_Active)
       		{
       			Rotary_Steps = 0;
            		UserIF::ON_Zero_Channel_1();
            		Trigger_Pos_CH1 = ZeroLevelCH1 - 5;

            		SetDacOffset(1);
            		SetCHDacOffset(1);
        	}
       	
		Virtual_ZeroLevelCH2 = -24; 
//BF del	      	CH2_Zero_Offset = 0;
       		if (Channel_2_Active)
       		{
       			Rotary_Steps = 0;
            		UserIF::ON_Zero_Channel_2();
            		Trigger_Pos_CH2 = ZeroLevelCH2 - 5;

            		SetDacOffset(2);
            		SetCHDacOffset(2);
        	}
			
		Virtual_ZeroLevelCH3 = 72;           
//BF del       		CH3_Zero_Offset = 0;
       		if (Channel_3_Active)
       		{
       			Rotary_Steps = 0;
           	 	UserIF::ON_Zero_Channel_3();
            		Trigger_Pos_CH3 = ZeroLevelCH3 - 5;

           		SetDacOffset(3);
           		SetCHDacOffset(3);
        	}
			
		Virtual_ZeroLevelCH4 = 168; 
//BF del       		CH4_Zero_Offset = 0;
       		if (Channel_4_Active)
       		{
       			Rotary_Steps = 0;
            		UserIF::ON_Zero_Channel_4();
            		Trigger_Pos_CH4 = ZeroLevelCH4 - 5;

            		SetDacOffset(4);
            		SetCHDacOffset(4);
        	}

	}


	acq_ready->np_pioedgecapture = 0;
	
	DoEnableRotInterrupt();
	DoEnableKeyInterrupt();
	DoEnableADCInterrupt();
	DoEnableUARTInterrupt();
	
	RecalcTimeParameters();

	UpdateTrigger();
	
	TimebaseChanged = 1;
	TimeOffsetChanged = 1;
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	TriggerWayChanged = 1;
	VoltageChangedCh1 = 1;									// Was Voltage changed
	VoltageChangedCh2 = 1;									// Was Voltage changed
	VoltageChangedCh3 = 1;									// Was Voltage changed
	VoltageChangedCh4 = 1;									// Was Voltage changed          		
			
	Display::StatusUpdate();

//	if (Memory_Window_visible)
//        Display::DRAWMEMORY(0, 0, 1);

	if (Cursor_Enabled)
	{
		Display::CALCCURSORDATA();
		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	if (QM_Enabled)
	{
		Display::CALCQMDATA();
		Menu_Changed = 1;
	}
	
	Display::DRAW_ALL_CURSOR();
	
	LED_ON[12] = 1;
	LED_ON[13] = 0;
	
	LED_ON[14] = 0;
	LED_ON[15] = 0;
	
	Send_LED();
	
	nr_delay(10);

	SetupADC();
	
	Start_Record();

//    RemovePlane |= 0x1F;
 //   ClearPlanes();

	AS_request = 0;

    	return 0;
}
//#####################################################################################################################################################

int Hardware::FindTimebase(char channel)
{
	volatile int ix, result, max_cnt, cnt = 0, cnt2 = 0;
	volatile int buf_int = 0;
	volatile long buf_long = 0;
	
	volatile unsigned char buf_byte = 0;
	volatile unsigned char buf_byte2 = 0;
	
	int max_tb = 23;

#ifdef _Debug_FindTimebase_
    printf("Start FTB Channel %d\n", channel);
#endif

	switch(channel)
	{
		case 1: serdata->np_piodata = 0x70000015; break;
		case 2: serdata->np_piodata = 0x50000015; break;
		case 3: serdata->np_piodata = 0x10000015; break;
		case 4: serdata->np_piodata = 0x30000015; break;
	}


	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(20);



	Selected_Timebase = 4;                                          //  50 nS
	SIGNALFaktor_idx = 0;                                           // zoom factor 1 = 50 nS
	SIGNAL_StartFr_idx = 0;                                         // running. so 0
	
	timebase_reg = tb_value[Selected_Timebase];
	Timebase_Idx = 4;                                          	// Displayed timebase is 50 ns
	
	triggering = 0;					
	ctrl_reg = 0x0087;						// Trigger_Master / Trigger_INT / Free Run
	adc_ctrl_reg &= 0xFFF0;						// Disable Trigger sources
	
	SetupADC();
	
	result = 0;
	
	max_cnt = 0;
	
	if (MenuStatus[MENU_AUTOSCALE][1] == 240) max_tb = 16;
	else max_tb = 26;
			
	while ((result < 15) || (result > 50))
	{
		max_cnt++;
	
		start_acq->np_piodata = 0x01;				//start record Port On
		start_acq->np_piodata = 0x00;				//start record Port Off
	
		while (acq_ready->np_piodata == 0x01) {}
	
		data_adr->np_piodata = 0x01;
	
		buf_long = READADC(1);
		buf_long = READADC(1);
	
		WRITEADC(1, ram_adress_reg);
		WRITEADC(2, ram_adress_reg);
	
		if (NumberOfChannels > 2)
		{
			WRITEADC(3, ram_adress_reg);
			WRITEADC(4, ram_adress_reg);
		}
		
		data_adr->np_piodata = 0x00;   	

		switch(channel)
		{
			case 1 : ReadOut_Signal(1, 0); break;
			case 2 : ReadOut_Signal(2, 0); break;
			case 3 : ReadOut_Signal(3, 0); break;
			case 4 : ReadOut_Signal(4, 0); break;
		}

		result = 0;
		buf_byte = 0;
		cnt = 0;
	
		buf_int = (int) ZoomFactor;
	
		if (buf_int <= 0) buf_int = 1;

		switch(channel)
		{
			case 1 :
			{
				buf_min = 255;
				buf_max = 0;
		
				for (ix = 50; ix < 650; ix++)
				{
					buf_byte = SIGNAL1[ix * buf_int];
					buf_arr[cnt++] = buf_byte;
					if (buf_min < buf_byte) buf_min = buf_byte;
					if (buf_max > buf_byte) buf_max = buf_byte;
				}
		
				buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);
		
				for (ix = 3; ix < 596; ix++)
				{
					if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
					if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
				}
#ifdef _Debug_FindTimebase_

                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                break;
            }

			case 2 :
			{
				buf_min = 255;
				buf_max = 0;
		
				for (ix = 50; ix < 650; ix++)
				{
					buf_byte = SIGNAL2[ix * buf_int];
					buf_arr[cnt++] = buf_byte;
					if (buf_min < buf_byte) buf_min = buf_byte;
					if (buf_max > buf_byte) buf_max = buf_byte;
				}
		
				buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);
		
				for (ix = 1; ix < 599; ix++)
				{
					if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
					if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
				}
#ifdef _Debug_FindTimebase_


                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
                		break;
            		}

			case 3 :
			{
				buf_min = 255;
				buf_max = 0;
		
				for (ix = 50; ix < 650; ix++)
				{
					buf_byte = SIGNAL3[ix * buf_int];
					buf_arr[cnt++] = buf_byte;
					if (buf_min < buf_byte) buf_min = buf_byte;
					if (buf_max > buf_byte) buf_max = buf_byte;
				}

				buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);
		
				for (ix = 1; ix < 599; ix++)
				{
					if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
					if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
				}
#ifdef _Debug_FindTimebase_
                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
				break;
			}

			case 4 :
			{
				buf_min = 255;
				buf_max = 0;
		
				for (ix = 50; ix < 650; ix++)
				{
					buf_byte = SIGNAL4[ix * buf_int];
					buf_arr[cnt++] = buf_byte;
					if (buf_min < buf_byte) buf_min = buf_byte;
					if (buf_max > buf_byte) buf_max = buf_byte;
				}
		
				buf_byte2 = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);
		
				for (ix = 1; ix < 599; ix++)
				{
					if ((buf_arr[ix - 3] > buf_byte2 + 1) && (buf_arr[ix + 3] < buf_byte2 - 1)) result++;
					if ((buf_arr[ix - 3] < buf_byte2 - 1) && (buf_arr[ix + 3] > buf_byte2 + 1)) result++;
				}
#ifdef _Debug_FindTimebase_

                for (cnt2 = 0; cnt2 < 35; cnt2++)
                {
                    printf("%2d : %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d %3d\n", cnt, buf_arr[(cnt * 16) + 0], buf_arr[(cnt * 16) + 1], buf_arr[(cnt * 16) + 2], buf_arr[(cnt * 16) + 3], buf_arr[(cnt * 16) + 4], buf_arr[(cnt * 16) + 5], buf_arr[(cnt * 16) + 6], buf_arr[(cnt * 16) + 7], buf_arr[(cnt * 16) + 8], buf_arr[(cnt * 16) + 9], buf_arr[(cnt * 16) + 10], buf_arr[(cnt * 16) + 11], buf_arr[(cnt * 16) + 12], buf_arr[(cnt * 16) + 13], buf_arr[(cnt * 16) + 14], buf_arr[(cnt * 16) + 15]);
                }

                printf("FTB %d cnt %d bi %d st %d sfi %d bb %d bmin %d bmax %d\n", result, cnt, buf_int, Selected_Timebase, SIGNALFaktor_idx, buf_byte2, buf_min, buf_max);
#endif
				break;
			}
        	}
	
		if (result < 15)
		{
			Selected_Timebase_Old = Selected_Timebase;
		
			if ((Selected_Timebase < 4) && (SIGNALFaktor_idx == 0)) Selected_Timebase++;
			else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx < 4)) SIGNALFaktor_idx++;
			else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx < 2)) SIGNALFaktor_idx++;
			else if (Selected_Timebase < max_tb) Selected_Timebase++;
		
			if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
			{
				if (Selected_Timebase_Old == 6)
				{
					Selected_Timebase = 9;
					SIGNALFaktor_idx = 2;
				}
			}
		
			if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
			{
				if (Selected_Timebase_Old == 9)
				{
					Selected_Timebase = 6;
					SIGNALFaktor_idx = 4;
				}
			}
		
			timebase_reg = tb_value[Selected_Timebase];

/* BF del		
			// BF default timebase is 4 !!!
			if (Selected_Timebase > 7)		//TB >= 10µS (Ta <= 25 MSa/S)
			{ //adc_change12_reg |= 0x01000000;
			  adc_change34_reg |= 0x01000000; }
			else					//TB <= 5µS (Ta >= 250 MSa/S)
			{ //adc_change12_reg &= 0xFEFFFFFF; 
			  adc_change34_reg &= 0xFEFFFFFF; } 
*/
/*
			if (timebase_reg = 0xFFFFFFFF)
			{ adc_change34_reg &= 0xFEFFFFFF; }	//BF -> reset Bit 24
			else	
			{ adc_change34_reg |= 0x01000000; }	//BF -> set Bit 24
*/
			SetupADC();
		}
		else if (result > 50)
		{
			Selected_Timebase_Old = Selected_Timebase;
		
			if ((Selected_Timebase > 4) && (SIGNALFaktor_idx == 4)) Selected_Timebase--;
			else if (SIGNALFaktor_idx > 0) SIGNALFaktor_idx--;
			else if ((Selected_Timebase > 2) && (SIGNALFaktor_idx == 0)) Selected_Timebase--;
		
			if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
			{
				if (Selected_Timebase_Old == 6)
				{
					Selected_Timebase = 9;
					SIGNALFaktor_idx = 2;
				}
			}
		
			if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
			{
				if (Selected_Timebase_Old == 9)
				{
					Selected_Timebase = 6;
					SIGNALFaktor_idx = 4;
				}
			}
		
			if ( Selected_Timebase <4 )
			Selected_Timebase = 4;
		
			timebase_reg = tb_value[Selected_Timebase];
/* BF del
			// BF default timebase is 4 !!!
			if (Selected_Timebase > 7)		//TB >= 10µS (Ta <= 25 MSa/S)
			{ //adc_change12_reg |= 0x01000000;
			  adc_change34_reg |= 0x01000000; }
			else					//TB <= 5µS (Ta >= 200 MSa/S)
			{ //adc_change12_reg &= 0xFEFFFFFF; 
			  adc_change34_reg &= 0xFEFFFFFF; }  
*/
/*
			if (timebase_reg = 0xFFFFFFFF)
			{ adc_change34_reg &= 0xFEFFFFFF; }	//BF -> reset Bit 24
			else	
			{ adc_change34_reg |= 0x01000000; }	//BF -> set Bit 24
*/
			SetupADC();
	
			if ((Selected_Timebase == 2) && (SIGNALFaktor_idx == 0)) result = 25;   // set break condition
		}


		if (Selected_Timebase == max_tb) result = 25;   // set break condition
		if (max_cnt == 25) result = 25;   // set break condition
    	}

    	Timebase_Idx = Selected_Timebase + SIGNALFaktor_idx;

    	Stop_Record();

	serdata->np_piodata = 0x700000CA;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(50);

	serdata->np_piodata = 0x500000CA;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;
	nr_delay(50);
	
	if (NumberOfChannels > 2)
	{
		serdata->np_piodata = 0x100000CA;
		serstartsw->np_piodata = 1;
		serstartsw->np_piodata = 0;
		nr_delay(50);
	
		serdata->np_piodata = 0x300000CA;
		serstartsw->np_piodata = 1;
		serstartsw->np_piodata = 0;
		nr_delay(50);	
	}
	
	nr_delay(300);
	
	return result;
}

int Hardware::FindVoltage(char channel)
{
    int ix, ix2, buf_int, volt = 12;
    long buf_long = 0;
    volatile unsigned char buf_byte = 0;

    int deltaV = 100;
    int topV = 40;
    int bottomV = 220;

    int posmin = 0, posmax = 0;

#ifdef _Debug_FindVoltage_
    printf("Start Channel %d\n", channel);
#endif

        			
    while (1)
    {
        if (volt > 3)
        {
            volt--;
#ifdef _Debug_FindVoltage_
            printf("decrement volt %d\n", volt);
#endif
        }
        else break;

        topV = 30;
        bottomV = 226;

                /*
        if ((Channel_1_Active) && (Channel_2_Active))
        {
            if (channel == 1)
            {
                topV = 30;
                bottomV = 128;
            }
            else
            {
                topV = 128;
                bottomV = 226;
            }
        }     */

        SetSwitches(channel, volt);

#ifdef _Debug_FindVoltage_
            printf("switches set\n");
#endif
/*
        Selected_Timebase = 15;                                          //  50 nS
        SIGNALFaktor_idx = 2;                                           // zoom factor 1 = 50 nS
//        Selected_Timebase = 4;                                          //  50 nS
//        SIGNALFaktor_idx = 0;                                           // zoom factor 1 = 50 nS
        SIGNAL_StartFr_idx = 0;                                         // running. so 0

        SIGNAL_StartFr_idx = 0;                                         // running. so 0

        timebase_reg = tb_value[Selected_Timebase];
        Timebase_Idx = 17;                                          // Displayed timebase is 50 ns
//        Timebase_Idx = 4;                                          // Displayed timebase is 50 ns
*/
        triggering = 0;							
        ctrl_reg = 0x0087;				                   // Trigger_Master / Trigger_INT / Free Run
        adc_ctrl_reg &= 0xFFF0;				                   // Disable Trigger sources

        pre_reg = 0x002D;
        //Trigger_Offset_Pos = 162;		//BF del not used

        if (Timebase_Idx == 4)
        {
            pre_reg = 0x002D;
            //Trigger_Offset_Pos = 162;		//BF del not used
        }
        else if (Timebase_Idx == 5)
        {
            pre_reg = 0x003C;
            //Trigger_Offset_Pos = 162;		//BF del not used
        }
        else if (Timebase_Idx == 6)
        {
            pre_reg = 0x0055;
            //Trigger_Offset_Pos = 262;		//BF del not used
        }
        else if (Timebase_Idx == 7)
        {
            pre_reg = 0x00A1;
            //Trigger_Offset_Pos = 560;		//BF del not used
        }
        else if (Timebase_Idx == 8)
        {
            pre_reg = 0x0120;
            //Trigger_Offset_Pos = 1075;	//BF del not used
        }
        else if (Timebase_Idx == 9)
        {
            pre_reg = 0x0120;
            //Trigger_Offset_Pos = 1075;	//BF del not used
        }
        else if (Timebase_Idx == 10)
        {
            pre_reg = 0x0120;
            //Trigger_Offset_Pos = 1075;	//BF del not used
        }
        else if (Timebase_Idx > 10)
        {
            pre_reg = 0x0110;
            //Trigger_Offset_Pos = 252;		//BF del not used
        }

        SetupADC();


#ifdef _Debug_FindVoltage_
            printf("Setup ADC - start record ctrl %x  pre %x  trig %d   irq %d\n", ctrl_reg, pre_reg, triggering, acq_ready->np_piodata);
#endif

        // first reag
        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off	

        while (acq_ready->np_piodata == 0x01) {}

#ifdef _Debug_FindVoltage_
            printf("Data received\n");
#endif

        data_adr->np_piodata = 0x01;

        buf_long = READADC(1);
        buf_long = READADC(1);

        WRITEADC(1, ram_adress_reg);
        WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            WRITEADC(3, ram_adress_reg);
            WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;

#ifdef _Debug_FindVoltage_
            printf("Start read out\n");
#endif         	

        switch(channel)
        {
            case 1 : ReadOut_Signal(1, 0); break;
            case 2 : ReadOut_Signal(2, 0); break;
            case 3 : ReadOut_Signal(3, 0); break;
            case 4 : ReadOut_Signal(4, 0); break;
        }

        buf_int = (int) ZoomFactor;

        if (buf_int <= 0) buf_int = 1;


        switch(channel)
        {
            case 1 :
            {

                buf_min = 255;
                buf_max = 0;

#ifdef _Debug_FindVoltage_
                printf("acquire data\n");
#endif
                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL1[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
            case 2 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL2[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
            case 3 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL3[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }


                break;
            }
            case 4 :
            {
                buf_min = 255;
                buf_max = 0;

                ix2 = 0;

                for (ix = 150; ix < 650; ix++)
                {
                    buf_byte = SIGNAL4[ix * buf_int];
                    buf_arr[ix2++] = buf_byte;
                    if (buf_min > buf_byte)
                    {
                        buf_min = buf_byte;
                        posmin = ix;
                    }
                    if (buf_max < buf_byte)
                    {
                        buf_max = buf_byte;
                        posmax = ix;
                    }
                }

                break;
            }
        }

#ifdef _Debug_FindVoltage_
        printf("Min %d  Max %d  Volt %d \n", buf_min, buf_max, volt);

        for (ix2 = (posmin - 1); ix2 < (posmin + 10); ix2++) printf("S1[%3d] : %d\n", ix2, buf_arr[ix2]);
#endif
        if ((buf_min > topV) && (buf_max < bottomV) && (abs(buf_max - buf_min) > 40)) break;
    }
#ifdef _Debug_FindVoltage_
    printf("Res : Min %d  Max %d  Volt %d \n", buf_min, buf_max, volt);
#endif

	
    switch(channel)
    {
        case 1 : Selected_Voltage_CH1 = volt; SetSwitches(1, Selected_Voltage_CH1); VoltageChangedCh1 = 1; Display::DRAWSTATUS(1, 0); Rotary_Steps = 0; UserIF::UserIF::ON_Zero_Channel_1();break;											// Draw Voltage Channel 1
        case 2 : Selected_Voltage_CH2 = volt; SetSwitches(2, Selected_Voltage_CH2); VoltageChangedCh2 = 1; Display::DRAWSTATUS(2, 0); Rotary_Steps = 0; UserIF::UserIF::ON_Zero_Channel_2();break;											// Draw Voltage Channel 2
        case 3 : Selected_Voltage_CH3 = volt; SetSwitches(3, Selected_Voltage_CH3); VoltageChangedCh3 = 1; Display::DRAWSTATUS(3, 0); Rotary_Steps = 0; UserIF::UserIF::ON_Zero_Channel_3();break;											// Draw Voltage Channel 3
        case 4 : Selected_Voltage_CH4 = volt; SetSwitches(4, Selected_Voltage_CH4); VoltageChangedCh4 = 1; Display::DRAWSTATUS(4, 0); Rotary_Steps = 0; UserIF::UserIF::ON_Zero_Channel_4();break;											// Draw Voltage Channel 4

    }
    Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel

#ifdef _Debug_FindVoltage_
    printf("Ready FV\n");
#endif
}
/* BF not used
void Hardware::FindSlope(void)
{
	long buf_long = 0, buf_long1 = 0;
	int cnt = 0;
	// Only two channels so far
	
    Hardware::DoDisableUARTInterrupt();
    Hardware::DoDisableADCInterrupt();
    Hardware::DoDisableKeyInterrupt();
    Hardware::DoDisableRotInterrupt();

    Stop_Record();


    AutoTimerOff = true;    	
	
//    Display::DRAWROUNDBUTTON(230, 180, 220, 80, 0, 0);
//    Display::TEXTOUTxvbig("For startup calibration", 247, 192, 1, UI_Plane2);
//    Display::TEXTOUTxvbig("remove all input lines.", 247, 212, 1, UI_Plane2);
//    Display::TEXTOUTxvbig("Press any key to continue.", 247, 232, 1, UI_Plane2);

  //  printf("Press a key\n");

//	key_reset->np_piodata = 0;										// Reset Keyboard
//	nr_delay(1);
//	key_reset->np_piodata = 1;
//	key_int->np_pioedgecapture = 0;									// clear IRQ conditions	

 //   while (key_int->np_pioedgecapture == 0) {};

//   printf("Yes, a key\n");
	
	// Backup old
    triggering_bak = triggering;
    ctrl_reg_bak = ctrl_reg;
    adc_ctrl_reg_bak = adc_ctrl_reg;
    adc_change12_reg_bak = adc_change12_reg;
    adc_change34_reg_bak = adc_change34_reg;

    Selected_Timebase_bak = Selected_Timebase;
    SIGNALFaktor_idx_bak = SIGNALFaktor_idx;
    SIGNAL_StartFr_idx_bak = SIGNAL_StartFr_idx;
    timebase_reg_bak = timebase_reg;
    Timebase_Idx_bak = Timebase_Idx;
    Continius_bak = Continius;
    SingleMode_bak = SingleMode;

    Selected_Voltage_CH1_bak = Selected_Voltage_CH1;
    Selected_Voltage_CH2_bak = Selected_Voltage_CH2;
    Selected_Voltage_CH3_bak = Selected_Voltage_CH3;
    Selected_Voltage_CH4_bak = Selected_Voltage_CH4;   	

    ZeroLevelCH1_bak = ZeroLevelCH1;
    ZeroLevelCH2_bak = ZeroLevelCH2;
    ZeroLevelCH3_bak = ZeroLevelCH3;
    ZeroLevelCH4_bak = ZeroLevelCH4;

    Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
    Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
    Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
    Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;


    CH1_DAC_Correction_1_bak = CH1_DAC_Correction_1;	
    CH1_DAC_Correction_2_bak = CH1_DAC_Correction_2;
    CH1_DAC_Correction_3_bak = CH1_DAC_Correction_3;

    CH2_DAC_Correction_1_bak = CH2_DAC_Correction_1;	
    CH2_DAC_Correction_2_bak = CH2_DAC_Correction_2;
    CH2_DAC_Correction_3_bak = CH2_DAC_Correction_3;

    CH3_DAC_Correction_1_bak = CH3_DAC_Correction_1;	
    CH3_DAC_Correction_2_bak = CH3_DAC_Correction_2;
    CH3_DAC_Correction_3_bak = CH3_DAC_Correction_3;

    CH4_DAC_Correction_1_bak = CH4_DAC_Correction_1;	
    CH4_DAC_Correction_2_bak = CH4_DAC_Correction_2;
    CH4_DAC_Correction_3_bak = CH4_DAC_Correction_3;
	
	// set test data
	
    CH1_DAC_Correction_1 = 0;	
    CH1_DAC_Correction_2 = 0;
    CH1_DAC_Correction_3 = 0;

    CH2_DAC_Correction_1 = 0;	
    CH2_DAC_Correction_2 = 0;
    CH2_DAC_Correction_3 = 0;

    CH3_DAC_Correction_1 = 0;	
    CH3_DAC_Correction_2 = 0;
    CH3_DAC_Correction_3 = 0;

    CH4_DAC_Correction_1 = 0;	
    CH4_DAC_Correction_2 = 0;
    CH4_DAC_Correction_3 = 0;	

    ZeroLevelCH1 = GRID_HEIGHT / 2;
    Virtual_ZeroLevelCH1 = 0;                                 // Virtual ZeroLevel
    //BF del	CH1_Zero_Offset = 0;                                        // Shift offset when stopped

    ZeroLevelCH2 = GRID_HEIGHT / 2;
    Virtual_ZeroLevelCH2 = 0;                                 // Virtual ZeroLevel
    //BF del	CH2_Zero_Offset = 0;                                        // Shift offset when stopped

    Rotary_Steps = 0;
    Hardware::UserIF::ON_Zero_Channel_1();

    nr_delay(100);

    Rotary_Steps = 0;
    Hardware::UserIF::ON_Zero_Channel_2();

    Hardware::SetSwitches(1, 11);

    nr_delay(100);

    Hardware::SetSwitches(2, 11);    	

    nr_delay(100);

    Selected_Timebase  = 4;                                          //  50 nS
    SIGNALFaktor_idx   = 0;                                           // zoom factor 1 = 50 nS
    SIGNAL_StartFr_idx = 0;                                         // running. so 0

    timebase_reg = tb_value[Selected_Timebase];
    Timebase_Idx = 4;                                          // Displayed timebase is 50 ns

    HoldOff_Value = 0;
    triggering = 0;								
    //ctrl_reg &= 0xC0FF;							// Clear Pulse and HoldOff bits
    ctrl_reg = 0x0087;							                    // Trigger_Master / Trigger_INT / Free Run
    adc_ctrl_reg &= 0x0100;						                    // Disable Trigger sources
	                     	

    // test generator settings
    adc_change12_reg = 0x30000000;                //  Bit 28 - TestGenerator  - Filter
    adc_change34_reg = 0x10000000;                //  Bit 28 - TestGenerator
    SwitchesCH2 = 0x66DA;                       // TestCounter CH I - IV + 5V Channel II
					
    Hardware::SetSwitches(2, -1);


    la_pulse->np_piodata = 0x01;				//stop record Port On
    la_pulse->np_piodata = 0x00;				//stop record Port Off	
                             																						
    Hardware::SetupADC();
    nr_delay(100);
    Hardware::SetupADC();

    // Run as long not found


//    Hardware::READADC(1);

    acq_ready->np_pioedgecapture = 0;
    acq_ready->np_piodata = 0x00;

 //   while ((buf_long & 0x1000) == 0)
    {
        // first reag
        start_acq->np_piodata = 0x01;				//start record Port On
        start_acq->np_piodata = 0x00;				//start record Port Off

        //printf("slope started\n");	

        while (acq_ready->np_piodata == 0x01)
        {
//#ifdef _Debug_
            //printf("1\n");
            nr_delay(500);

//            Hardware::SetupADC();
//            start_acq->np_piodata = 0x01;				//start record Port On
//            start_acq->np_piodata = 0x00;				//start record Port Off	

            cnt++;
            if (cnt == 20)
            {
//                printf("Slope stoped");
                break;
            }
//#endif
        }


        data_adr->np_piodata = 0x01;

        buf_long  = Hardware::READADC(1);
        buf_long1 = Hardware::READADC(1);

        Hardware::WRITEADC(1, ram_adress_reg);
        Hardware::WRITEADC(2, ram_adress_reg);

        if (NumberOfChannels > 2)
        {
            Hardware::WRITEADC(3, ram_adress_reg);
            Hardware::WRITEADC(4, ram_adress_reg);
        }
    	
        data_adr->np_piodata = 0x00;

        ReadOut_Signal(1, buf_long, 0);
        ReadOut_Signal(2, buf_long, 0);
        if (NumberOfChannels > 2)
        {
            ReadOut_Signal(3, buf_long, 0);
            ReadOut_Signal(4, buf_long, 0);
        }
#ifdef _Debug_
        printf("bl %04x bl1 %08x\n", buf_long, buf_long1);
#endif
    }

    la_gate->np_piodata = 0x00;
    slope_value = la_data->np_piodata;


    // restore old
    triggering = triggering_bak;
    ctrl_reg = ctrl_reg_bak;
    adc_ctrl_reg = adc_ctrl_reg_bak;

    Continius = Continius_bak;
    SingleMode = SingleMode_bak;

    SwitchesCH2 &= 0x00FF;
    adc_change12_reg = adc_change12_reg_bak;
    adc_change34_reg = adc_change34_reg_bak;

    Selected_Timebase = Selected_Timebase_bak;
    SIGNALFaktor_idx = SIGNALFaktor_idx_bak;
    SIGNAL_StartFr_idx = SIGNAL_StartFr_idx_bak;
    timebase_reg = timebase_reg_bak;
    Timebase_Idx = Timebase_Idx_bak;

    Selected_Voltage_CH1 = Selected_Voltage_CH1_bak;
    Selected_Voltage_CH2 = Selected_Voltage_CH2_bak;
    Selected_Voltage_CH3 = Selected_Voltage_CH3_bak;
    Selected_Voltage_CH4 = Selected_Voltage_CH4_bak;   	

    ZeroLevelCH1 = ZeroLevelCH1_bak;
    ZeroLevelCH2 = ZeroLevelCH2_bak;
    ZeroLevelCH3 = ZeroLevelCH3_bak;
    ZeroLevelCH4 = ZeroLevelCH4_bak;

    Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_bak;
    Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_bak;
    Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_bak;
    Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_bak;

    CH1_DAC_Correction_1 = CH1_DAC_Correction_1_bak;	
    CH1_DAC_Correction_2 = CH1_DAC_Correction_2_bak;
    CH1_DAC_Correction_3 = CH1_DAC_Correction_3_bak;

    CH2_DAC_Correction_1 = CH2_DAC_Correction_1_bak;	
    CH2_DAC_Correction_2 = CH2_DAC_Correction_2_bak;
    CH2_DAC_Correction_3 = CH2_DAC_Correction_3_bak;

    CH3_DAC_Correction_1 = CH3_DAC_Correction_1_bak;	
    CH3_DAC_Correction_2 = CH3_DAC_Correction_2_bak;
    CH3_DAC_Correction_3 = CH3_DAC_Correction_3_bak;

    CH4_DAC_Correction_1 = CH4_DAC_Correction_1_bak;	
    CH4_DAC_Correction_2 = CH4_DAC_Correction_2_bak;
    CH4_DAC_Correction_3 = CH4_DAC_Correction_3_bak;

    Hardware::UpdateTrigger(33);

    Rotary_Steps = 0;
    Hardware::UserIF::ON_Zero_Channel_1();
    Rotary_Steps = 0;
    Hardware::UserIF::ON_Zero_Channel_2();

    Hardware::SetSwitches(1, Selected_Voltage_CH1);
    Hardware::SetSwitches(2, Selected_Voltage_CH2);



//    Display::DRAWROUNDBUTTON(230, 180, 220, 80, 0, 1);
//    Display::TEXTOUTxvbig("For startup calibration", 247, 192, 0, UI_Plane2);
//    Display::TEXTOUTxvbig("remove all input lines.", 247, 212, 0, UI_Plane2);
//    Display::TEXTOUTxvbig("Press any key to continue.", 247, 232, 0, UI_Plane2);	

    AutoTimerOff = false;    	

    Hardware::DoEnableRotInterrupt();
    Hardware::DoEnableKeyInterrupt();
    Hardware::DoEnableADCInterrupt();
    Hardware::DoEnableUARTInterrupt();	
#ifdef _Debug_
    printf("Slope : %x\n", slope_value);
#endif
}
*/

void Hardware::DoEnableReadVSyncInterrupt(void)						// Enable ReadVSync service routine
{

	read_vsync->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	read_vsync->np_piodirection = 0;								// set bit to input
	read_vsync->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_read_vsync_irq,ISR_ReadVSync_INT,(int)read_vsync);		// Install ISR for ReadVSync
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("read_vsync interrupt enabled.\n"); 					// print on console
#endif	

}

void Hardware::DoDisableReadVSyncInterrupt(void)					// Disable ReadVSync service routine
{
	nr_installuserisr(na_read_vsync_irq,0,0); 						// Install empty routine for ReadVSync irq
	read_vsync->np_piointerruptmask = 0x00;							// disable all IRQs
}

void Hardware::ISR_ReadVSync_INT(int context)						// ReadVSync interrupt subroutine
{
    	//BF del tc_test_var2++;
	VSync_Needed = 1;	
	vs_counter++;
	read_vsync->np_pioedgecapture = 0;								// clear IRQ conditions	

#ifdef _Debug_IRQ_
	//if (Debug_Mode) printf("read_vsync interrupt enabled.\n"); 					// print on console
#endif		
}

void Hardware::TransferPlanes(void)
{
	int cnt;
	
	//if (VSync_Needed == 0) return;
	if (MenuPopupActive > -1) return;
	
	if (UpdateMarkerPlane)
	{
	 	TransferPlanes_asm_persistant(0x008CABE4, 0x009D9DF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
		UpdateMarkerPlane = false;
	}
	
	if (UpdateMenuTextPlane)
	{
		if ((QM_Enabled == 1) || (Cursor_Enabled == 1))				//BF add by Guido
		{ TransferDataPlane_asm_persistant(0x008DBB24, 0x00970F30); }		//BF add by Guido	
		else
		{ TransferDataPlane_asm_persistant(0x008DC254, 0x00971660); }		//BF -> fixed by Guido 			

		UpdateMenuTextPlane = false;	
	}
	
	if (Splash_drawed) return;
	
//!!!!!!!!!!!!!!!!!!! BF TEST !!!!!!!!!!!!!!!!!!!	
	//if (UI_request) return;	
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

    if (MenuStatus[MENU_DISPLAY][0] == 240)
    {
        switch(ClearPlane)
        {
            case 0x01 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x02 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x03 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2); break;
            case 0x04 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	
            case 0x05 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;
            case 0x06 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;	
            case 0x07 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3); break;
            case 0x08 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;
            case 0x09 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;
            case 0x0A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
            case 0x0B : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3); break;
            case 0x0C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
            case 0x0D : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;
            case 0x0E : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;

            case 0x0F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x10 : TransferPlanes_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	
            case 0x11 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
            case 0x12 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;	
            case 0x13 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3); break;	
            case 0x14 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
            case 0x15 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;	
            case 0x16 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;

            case 0x17 :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x18 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;		
            case 0x19 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		
            case 0x1A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		

            case 0x1B :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;	

            case 0x1D :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1E :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                break;
            }  		
        }
    }
    else
    {	
        switch(ClearPlane)
        {
            case 0x01 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x02 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x03 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2);break;
            case 0x04 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	
            case 0x05 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;
            case 0x06 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;
            case 0x07 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3);break;
            case 0x08 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;                               		
            case 0x09 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0B : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);break;
            case 0x0C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
            case 0x0D : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;
            case 0x0E : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;

            case 0x0F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x10 : TransferPlanes_asm_persistant(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
            case 0x11 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x12 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x13 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);break;
            case 0x14 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
            case 0x15 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;
            case 0x16 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x17 :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
                break;
            }

            case 0x18 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;                              		
            case 0x19 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;     		
            case 0x1A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x1B :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;

            case 0x1D :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1E :
            {
                TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                else TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
                break;
            }

            case 0x1F :
            {
                TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
                if (MenuStatus[MENU_DISPLAY][0] == 240) TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                else TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
                break;
            }
        }
    }

     /*
	// pixel error correction
	if ((ClearPlane & 0x01) == 0x01)
    {
    //    for (cnt = 20; cnt < 480; cnt++) Buffer_Plane1[cnt * 20] = Buffer_Plane1[cnt * 20] << 2;	
        	
    }

    for (cnt = 20; cnt < 480; cnt++)
    {
        if ((ClearPlane & 0x01) == 0x01) Channel_Plane1[cnt * 20] = Channel_Plane1[cnt * 20] << 2;
        if ((ClearPlane & 0x02) == 0x02) Channel_Plane2[cnt * 20] = Channel_Plane2[cnt * 20] << 2;
        if ((ClearPlane & 0x04) == 0x04) Channel_Plane3[cnt * 20] = Channel_Plane3[cnt * 20] << 2;
        if ((ClearPlane & 0x08) == 0x08) Channel_Plane4[cnt * 20] = Channel_Plane4[cnt * 20] << 2;
        if ((ClearPlane & 0x10) == 0x10) Channel_Math_Plane[cnt * 20] = Channel_Math_Plane[cnt * 20] << 2;

    }
    */

	if (Splash_drawed == false)
	{
        	if (init_done) Display::DRAWSIGNS();

        	if (Menu_Changed) Display::UpdateMenu();
    	}
//BF test 	
	if(!UI_request)
	ZL_changed = 0;
	VS_TrigLevelChanged = 0;	//reset triggerlevel change flag
	VS_ZeroLevelChanged = 0;	//reset zerolevel change flag
//test end

	//BF test ClearPlane &= 0xE0;
	ClearPlane = 0xE0;	
    	VSync_Needed = 0;
    	
	//reset_watchdog->np_piodata = 0x01;								// Enable WatchDog	

}

void Hardware::ClearPlanes(void)
{
//	reset_watchdog->np_piodata = 0x00;								// Disable WatchDog
	
	if (Channel_1_Active == 1) DrawPlane |= 0x01;	
	if (Channel_2_Active == 1) DrawPlane |= 0x02;
	
	if (Channel_3_Active == 1) DrawPlane |= 0x04;
	if (Channel_4_Active == 1) DrawPlane |= 0x08;
	
	if (Channel_Math_Active == 1) DrawPlane |= 0x10;

	ClearPlane = DrawPlane | RemovePlane;
	DrawPlane = 0;
   	   	
	//printf("ClearPlane = %x\r\n");

	switch(ClearPlane)
	{
		case 0x01 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x02 :
		{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x03 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2); break; }
		case 0x04 :
		{ TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x05 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break; }
		case 0x06 :
		{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break; }
		case 0x07 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3); break; }	
		case 0x08 :
	    	{ TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
        	case 0x09 :
	    	{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break; }
        	case 0x0A :
	    	{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break; }
		case 0x0B :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0C :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);
		break;	
			}
		case 0x0D :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0E :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0F :
		{
		TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
		break;
			}     	
		case 0x10 :
		{
		TransferPlanes_clear_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
		break;	
			}
		case 0x11 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;
			}
		case 0x12 :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;	
			}
		case 0x13 :
		{  	
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x14 :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;
			}
		case 0x15 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x16 :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
		break;
			}
		case 0x17 :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
		break;		
			}
		case 0x18 :
		{
		TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;		
			}                                        		
		case 0x19 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;		
			}               		
		case 0x1A :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;		
			}
		case 0x1B :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);	
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
		break;		
			}
		case 0x1C :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x1D :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
		break;
			}
		case 0x1E :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
		break;	
			}           		
		case 0x1F :
		{
		TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
		break;
			}		
	}	
	
	//BF del if (init_done) Display::DRAWSIGNS();

	ClearPlane &= 0xE0;	
    	
//	reset_watchdog->np_piodata = 0x01;								// Enable WatchDog	
}
//#####################################################################################################################################
//BF changed by Guido
void Hardware::TransferDataPlane_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1)
{
	if ((QM_Enabled == 1) || (Cursor_Enabled == 1))
	{
		asm("
            		PFX	    %hi(1460)                	; //Set Counter 	BF-> change from 1460 to 1000 for new grid to avoid pixel error
            		MOVI	%l1,%lo(1460)			; //BF-> new values calculated by Guido

            		loopmtpp1:
            		LD     %l0, [%i0]                  	; //Load Buffer Data to %r0 	
            		ST     [%i1], %l0                  	; //Store it to Plane

            		ADDI   %i0, 4               		; //Add Address Counter
            		ADDI   %i1, 4	
	
            		SUBI   %l1, 1              		; //Decrement Line Counter
            		SKPS   cc_z
            		BR     loopmtpp1
            		NOP 	
        		");
	}
	else
	{
		asm("
            		PFX	    %hi(1000)                	; //Set Counter 	BF-> change from 1460 to 1000 for new grid to avoid pixel error
            		MOVI	%l1,%lo(1000)			; //BF-> new values calculated by Guido

            		loopmtpp1_a:
            		LD     %l0, [%i0]                  	; //Load Buffer Data to %r0 	
            		ST     [%i1], %l0                  	; //Store it to Plane

            		ADDI   %i0, 4               		; //Add Address Counter
            		ADDI   %i1, 4	
	
            		SUBI   %l1, 1              		; //Decrement Line Counter
            		SKPS   cc_z
            		BR     loopmtpp1_a
            		NOP 	
        		");
	}
}

void Hardware::TransferPlane_Set_Buffer_Adr(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2)
{
    asm("
            MOV		%r4,%i0	
            MOV		%r5,%i1

            MOV		%r6,%i2
            MOV		%r7,%i3
        ");
}

void Hardware::TransferPlanes_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp3
                    NOP 	
                ");
            break;
        }

	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                    ST     [%r6], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)
	
                    looptpp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)
	
                    looptpp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_clear_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc1:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc2:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc3:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc4:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc5:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane

                    ST     [%r6], %l2                        ; Clear Buffer
                    ST     [%r7], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::Planes_clear_asm(unsigned long Buffer_Adr1)
{
	asm("
            PFX	    %hi(8060)                         ; Set Counter
            MOVI	%l1,%lo(8060)

            PFX	    %hi(0)                            ; Set Clear register
            MOVI	%l2,%lo(0)
            PFX	    %xhi(0)
            MOVHI	%l2,%xlo(0)	
	
        looptpcc1:
            ST     [%i0], %l2                        ; Clear Buffer

            ADDI   %i0, 4                            ; Add Address Counter
	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     looptpcc1
            NOP 	
        ");
}

void Hardware::Planes_clear_asm_all(unsigned char count, unsigned long Buffer_Adr1, unsigned long Buffer_Adr2, unsigned long Buffer_Adr3, unsigned long Buffer_Adr4, unsigned long Buffer_Adr5)
{
    switch(count)
    {
        case 1 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc21:
                ST     [%i1], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc21
                NOP 	
            ");
            break;
        }
        case 2 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc22:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc22
                NOP 	
            ");
            break;
        }
        case 3 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc23:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc23
                NOP 	
            ");
            break;
        }
        case 4 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc24:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc24
                NOP 	
            ");
            break;
        }
        case 5 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc25:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer
                ST     [%i5], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
                ADDI   %i5, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc25
                NOP 	
            ");
            break;
        }
    }
}
/*BF not used	
void Hardware::DoEnableLogicAnalyserInterrupt(void)							// Enable service routine
{
	la_interrupt->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	la_interrupt->np_piodirection = 0x00;								// set all bits to input
	la_interrupt->np_piointerruptmask = 0x01;							// enable Button IRQs
	la_interrupt->np_piodata = 0;

	nr_installuserisr(na_la_interrupt_irq,ISR_LogicAnalyser,(int)la_interrupt);	// Install ISR for parallel I/Os

#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nLogicAnalyser interrupt enabled.\n"); 						// print on console
#endif	
}
*/

/*BF not used	
void Hardware::DoDisableLogicAnalyserInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_la_interrupt_irq,0,0); 				// Install empty routine for pio irq
	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
}
*/

/*BF not used
void Hardware::ISR_LogicAnalyser(int context)
{
	char la_data_cnt;
	
	tc_test_var2++;

	la_gate->np_piodata = 0x01;
	
	for (la_data_cnt = 0; la_data_cnt < 32; la_data_cnt++)
	{
		la_pulse->np_piodata = 0x01;
		
		LogicData[la_data_cnt] = la_data-> np_piodata;
		
		la_pulse->np_piodata = 0x00;		
	}	
	
	la_gate->np_piodata = 0x00;
	
    la_interrupt->np_pioedgecapture = 0; 								// clear IRQ conditions		

	//if (USB_Data_Trans == 1)
	{
		send_buffer[0] = 3;						// Command Write Data
		send_buffer[1] = 20;
		send_buffer[2] = 1;
		
		CommIF::SendData(send_buffer);	
	}
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nLogicAnalyser interrupt received\n");
#endif	
}
*/

/***************************************************************************
* clear: zeroize a FIR delay line                                          
***************************************************************************/
/*BF del not used
void clear(int ntaps, SAMPLE z[])
{
    int ii;
    for (ii = 0; ii < ntaps; ii++) {
        z[ii] = 0;
    }
}
*/
/****************************************************************************
* fir_basic: Does the basic FIR algorithm: store input sample, calculate
* output sample, move delay line
*****************************************************************************/
/*BF del not used
SAMPLE fir_basic(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[])
{
    int ii;
    SAMPLE accum;

    // store input at the beginning of the delay line 
    z[0] = input;

    // calc FIR 
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += h[ii] * z[ii];
    }

    // shift delay line 
    for (ii = ntaps - 2; ii >= 0; ii--) {
        z[ii + 1] = z[ii];
    }

    return accum;
}
*/
/****************************************************************************
* fir_circular: This function illustrates the use of "circular" buffers
* in FIR implementations.  The advantage of circular buffers is that they
* alleviate the need to move data samples around in the delay line (as
* was done in all the functions above).  Most DSP microprocessors implement
* circular buffers in hardware, which allows a single FIR tap can be
* calculated in a single instruction.  That works fine when programming in
* assembly, but since C doesn't have any constructs to represent circular
* buffers, you need to "fake" them in C by adding an extra "if" statement
* inside the FIR calculation, even if the DSP processor provides hardware to
* implement them without overhead.
*****************************************************************************/
/*BF del not used
SAMPLE fir_circular(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[],
                    int *p_state)
{
    int ii, state;
    SAMPLE accum;

    state = *p_state;               // copy the filter's state to a local

    // store input at the beginning of the delay line
    z[state] = input;
    if (++state >= ntaps) {         // incr state and check for wrap
        state = 0;
    }

    // calc FIR and shift data
    accum = 0;
    for (ii = ntaps - 1; ii >= 0; ii--) {
        accum += h[ii] * z[state];
        if (++state >= ntaps) {     // incr state and check for wrap
            state = 0;
        }
    }

    *p_state = state;               // return new state to caller 

    return accum;
}
*/

/****************************************************************************
* fir_shuffle: This is like fir_basic, except that data is shuffled by
* moving it _inside_ the calculation loop.  This is similar to the MACD
* instruction on TI's fixed-point processors
*****************************************************************************/
/*BF del not used
SAMPLE fir_shuffle(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[])
{
    int ii;
    SAMPLE accum;

    // store input at the beginning of the delay line
    z[0] = input;

    // calc FIR and shift data
    accum = h[ntaps - 1] * z[ntaps - 1];
    for (ii = ntaps - 2; ii >= 0; ii--) {
        accum += h[ii] * z[ii];
        z[ii + 1] = z[ii];
    }

    return accum;
}
*/

/****************************************************************************
* fir_split: This splits the calculation into two parts so the circular
* buffer logic doesn't have to be done inside the calculation loop
*****************************************************************************/
/*BF del not used
SAMPLE fir_split(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[], int *p_state)
{
    int ii, end_ntaps, state = *p_state;
    SAMPLE accum;
    SAMPLE const *p_h;
    SAMPLE *p_z;

    // setup the filter
    accum = 0;
    p_h = h;

    // calculate the end part 
    p_z = z + state;
    *p_z = input;
    end_ntaps = ntaps - state;
    for (ii = 0; ii < end_ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    // calculate the beginning part
    p_z = z;
    for (ii = 0; ii < state; ii++) {
        accum += *p_h++ * *p_z++;
    }

    // decrement the state, wrapping if below zero
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       // return new state to caller

    return accum;
}
*/


/****************************************************************************
* fir_double_z: double the delay line so the FIR calculation always
* operates on a flat buffer
*****************************************************************************/
/*BF del not used
SAMPLE fir_double_z(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[], int *p_state)
{
    SAMPLE accum;
    int ii, state = *p_state;
    SAMPLE const *p_h, *p_z;

    // store input at the beginning of the delay line as well as ntaps more
    z[state] = z[state + ntaps] = input;

    // calculate the filter
    p_h = h;
    p_z = z + state;
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    // decrement state, wrapping if below zero
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       // return new state to caller

    return accum;
}
*/

/****************************************************************************
* fir_double_h: uses doubled coefficients (supplied by caller) so that the
* filter calculation always operates on a flat buffer.
*****************************************************************************/
/*BF del not used
SAMPLE fir_double_h(SAMPLE input, int ntaps, const SAMPLE h[], SAMPLE z[], int *p_state)
{
    SAMPLE accum;
    int ii, state = *p_state;
    SAMPLE const *p_h, *p_z;

    // store input at the beginning of the delay line 
    z[state] = input;

    // calculate the filter
    p_h = h + ntaps - state;
    p_z = z;
    accum = 0;
    for (ii = 0; ii < ntaps; ii++) {
        accum += *p_h++ * *p_z++;
    }

    // decrement state, wrapping if below zero
    if (--state < 0) {
        state += ntaps;
    }
    *p_state = state;       // return new state to caller

    return accum;
}
*/

/****************************************************************************
* main: This provides a simple test suite for the functions above.  An
* impulse is fed into each filter implementation, so the output should be
* the "impulse response", that is, the coefficients of the filter.  You
* should see some zeroes, followed by the "coefficents" below, followed by a
* few more zeroes.
*****************************************************************************/
/*BF del not used
int Hardware::TestFir(void)
{
    static const SAMPLE h[NTAPS] = { 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2, 0.2 };
    static SAMPLE h2[2 * NTAPS];
    static SAMPLE z[2 * NTAPS];
    static SAMPLE imp[IMP_SIZE];

    SAMPLE output;
    int ii, state;

    // make impulse input signal
    clear(IMP_SIZE, imp);


    imp[0]  = 0.0;
    imp[1]  = 0.0;
    imp[2]  = 1.0;
    imp[3]  = 2.0;
    imp[4]  = 3.0;
    imp[5]  = 4.0;
    imp[6]  = 5.0;
    imp[7]  = 4.0;
    imp[8]  = 3.0;
    imp[9]  = 2.0;
    imp[10] = 1.0;
    imp[11] = 0.0;
    imp[12] = -1.0;
    imp[13] = -2.0;
    imp[14] = -3.0;
    imp[15] = -4.0;
    imp[16] = -5.0;
    imp[17] = -4.0;
    imp[18] = -3.0;
    imp[19] = -2.0;
    imp[20] = -1.0;
    imp[21] = 0.0;
    imp[22] = 1.0;
    imp[23] = 2.0;
    imp[24] = 3.0;
    imp[25] = 4.0;
    imp[26] = 5.0;
    imp[27] = 4.0;
    imp[28] = 3.0;
    imp[29] = 2.0;
    imp[30] = 1.0;
    imp[31] = 0.0;
    imp[32] = 0.0;


    // create a SAMPLEd h
    for (ii = 0; ii < NTAPS; ii++) {
        h2[ii] = h2[ii + NTAPS] = h[ii];
    }

    // test FIR algorithms

    printf("Testing fir_basic:\n   ");
    clear(NTAPS, z);
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_basic(imp[ii], NTAPS, h, z);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_shuffle:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_shuffle(imp[ii], NTAPS, h, z);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_circular:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_circular(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_split:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_split(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_double_z:\n   ");
    clear(2 * NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_double_z(imp[ii], NTAPS, h, z, &state);
        printf("%3.1lf ", (double) output);
    }
    printf("\n\n");

    printf("Testing fir_double_h:\n   ");
    clear(NTAPS, z);
    state = 0;
    for (ii = 0; ii < IMP_SIZE; ii++) {
        output = fir_double_h(imp[ii], NTAPS, h2, z, &state);
        printf("%3.1lf ", (double) output);
    }

    #ifdef WIN32
        printf("\n\nHit any key to continue.");
        getch();
    #endif

    return 0;
}
*/
//##########################################################################################################################################################

void Hardware::floatprintf(float fvalue)
{
	long int pre, aft,factor;
	int i;
	
	//calculating pre FP value
	pre = (long int)fvalue;
	if(pre == 0 && fvalue < 0)	//negativ
		printf("-%d.",pre);
	else
		printf("%d.",pre);
		
	//get leading zero
	if((fvalue - pre) != 0) //check if numbers after FP exist
	{
		for(factor = 10, i= 0 ;0 == (long int)((fvalue - pre) * factor) && i<11; factor*=10, i++)
		{ printf("0"); }
	}
	else
	{	
		printf("000");
		return;
	}
	
	//calc after FP value, minimum 3 numbers after FP
	aft = (long int)((fvalue - pre) * factor * 100);
	
	if(aft < 0)	//kill sign
	{ aft *= -1; }

	printf("%d",aft);

	if(i >= 11)
	printf("overflow");
}

//##########################################################################################################################################################
//BF added
// Calculate ADC offset for specified channel
void Hardware::Calc_ADC_Offset(int channel)
{
	long int ADC1 = 0, ADC2 = 0, ADC3 = 0, ADC4 = 0;
	int ix = 0, ref; 
	
	printf("\nChannel %d start calibrating ADC offsets\r\n", channel);

	switch(channel)
	{
		case 1:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 0; ix < 4000; ix+=4)
			{ ADC1 += SIGNAL1[ix];ADC2 += SIGNAL1[ix+1];ADC3 += SIGNAL1[ix+2];ADC4 += SIGNAL1[ix+3];}
			break;	
		}
		case 2:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 0; ix < 4000; ix+=4)
			{ ADC1 += SIGNAL2[ix];ADC2 += SIGNAL2[ix+1];ADC3 += SIGNAL2[ix+2];ADC4 += SIGNAL2[ix+3];}
			break;	
		}
		case 3:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 0; ix < 4000; ix+=4)
			{ ADC1 += SIGNAL3[ix];ADC2 += SIGNAL3[ix+1];ADC3 += SIGNAL3[ix+2];ADC4 += SIGNAL3[ix+3];}
			break;	
		}
		case 4:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 0; ix < 4000; ix+=4)
			{ ADC1 += SIGNAL4[ix];ADC2 += SIGNAL4[ix+1];ADC3 += SIGNAL4[ix+2];ADC4 += SIGNAL4[ix+3];}
			break;	
		}
	}

	//calculate average for each ADC	
	ix = ix >> 2;	

	ADC1 /= ix;
	ADC2 /= ix;
	ADC3 /= ix;
	ADC4 /= ix;

	//get ADC with smallest offset as  zero reference 
	ref = ADC1;
	if( ADC2 < ref ) ref = ADC2;
	if( ADC3 < ref ) ref = ADC3;
	if( ADC4 < ref ) ref = ADC4;
	
	//calculate offsets
        ADC_Offset[channel-1][0] = ADC1 - ref;
	ADC_Offset[channel-1][1] = ADC2 - ref;
	ADC_Offset[channel-1][2] = ADC3 - ref;
	ADC_Offset[channel-1][3] = ADC4 - ref;

	
	printf("ADC 1 Offset = %d\r\n",ADC_Offset[channel-1][0]);
	printf("ADC 2 Offset = %d\r\n",ADC_Offset[channel-1][1]);
	printf("ADC 3 Offset = %d\r\n",ADC_Offset[channel-1][2]);
	printf("ADC 4 Offset = %d\r\n",ADC_Offset[channel-1][3]);


}

//##########################################################################################################################################################
//BF added
//Calculate DAC offset correction for specified channel
void Hardware::Calc_DAC_Correction(int channel, int *Correction)
{

	//-------------------------------------------------------------------------------------------
	// BF new calibration	
	//------------------------------------------------------------------------------------------
	printf("\r\nChannel %d start calibrating DAC zero\r\n", channel);
	printf("DAC correction old  = %d\r\n", Correction[0]);

	long int ADC_sum = 0;
	int ADC_diff;
	int ix = 0, lvoltage_range = 0, lVirtual_Zero=0; 
	
	switch(channel)
	{
		case 1:
		{
			//get sum of values
			for (ix = 0; ix < 99; ix++)
			{ ADC_sum += SIGNAL1[ix]; }
			lvoltage_range = Selected_Voltage_CH1;
			lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH1 / scale_factor[Selected_Voltage_CH1][GainIdx]);
			break;	
		}
		case 2:
		{
			//get sum of values
			for (ix = 0; ix < 99; ix++)
			{ ADC_sum += SIGNAL2[ix]; }
			lvoltage_range = Selected_Voltage_CH2;	
			lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH2 / scale_factor[Selected_Voltage_CH2][GainIdx]);	
			break;	
		}
		case 3:
		{
			//get sum of values
			for (ix = 0; ix < 99; ix++)
			{ ADC_sum += SIGNAL3[ix]; }
			lvoltage_range = Selected_Voltage_CH3;	
			lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH3 / scale_factor[Selected_Voltage_CH3][GainIdx]);	
			break;	
		}
		case 4:
		{
			//get sum of values
			for (ix = 0; ix < 99; ix++)
			{ ADC_sum += SIGNAL4[ix]; }
			lvoltage_range = Selected_Voltage_CH4;	
			lVirtual_Zero = ADC_ZERO + int((float)Virtual_ZeroLevelCH4 / scale_factor[Selected_Voltage_CH4][GainIdx]);	
			break;	
		}
	}

	//get average offset of each ADC-set
	
	ADC_sum /= ix;
	printf("ADC average value  = %d\r\n", ADC_sum);


	//ADC_diff = ADC_sum - ADC_ZERO;
	ADC_diff = ADC_sum - lVirtual_Zero;
	printf("ADC offset         = %d\r\n", ADC_diff);
	
	switch(lvoltage_range)
	{
		case 0: Correction[0] -= (ADC_diff << 1); break;//  1 mV
		case 1: Correction[0] -= (ADC_diff << 2); break;//  2 mV
		case 2: Correction[0] -= (ADC_diff << 2); break;//  5 mV
		case 3: Correction[0] -= (ADC_diff << 1); break;// 10 mV
		case 4: Correction[0] -= (ADC_diff << 2); break;// 20 mV
		case 5: Correction[0] -= (ADC_diff << 2); break;// 50 mV
		case 6: Correction[0] -= (ADC_diff << 1); break;//100 mV
		case 7: Correction[0] -= (ADC_diff << 2); break;//200 mV
		case 8: Correction[0] -= (ADC_diff << 2); break;//500 mV
		case 9: Correction[0] -= (ADC_diff << 1); break;// 1 V
		case 10: Correction[0] -= (ADC_diff << 2); break;//2 V
		case 11: Correction[0] -= (ADC_diff << 2); break;//5 V	
	}
		
	printf("DAC Correction new  = %d\r\n", Correction[0]);

	return;

}
//##########################################################################################################################################################
//BF added
//Calibrate all ADCs
void Hardware::Calibrate_ADC_ZeroOffsets(void)
{

	
	//out_test->np_piodata = 0x01;	// Testbit+++++++++++++++++++++++
	volatile long buffer_addr = 0;	
	volatile long buffer_peak = 0;	
	volatile long buffer_written = 0;	
	volatile long buffer_adradd = 0;

	int channel_trig = 0;

	char CH1_DelCorr_bak;
	char CH2_DelCorr_bak;
	char CH3_DelCorr_bak;
	char CH4_DelCorr_bak;

	char lChannel_1_bak, lChannel_2_bak, lChannel_3_bak, lChannel_4_bak;



	//backup BF  #001 
	CH1_DelCorr_bak = CH1_Del_Correct;
	CH2_DelCorr_bak = CH2_Del_Correct;
	CH3_DelCorr_bak = CH3_Del_Correct;
	CH4_DelCorr_bak = CH4_Del_Correct;



//	Channel delay correction must be reset for correct ADC adjustment  BF  #001 
	CH1_Del_Correct = 0;
	CH2_Del_Correct = 0;
	CH3_Del_Correct = 0;
	CH4_Del_Correct = 0;


	Stop_Record();
	AutoTimerOff = true;


	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
	Display::TEXTOUTxvbig("Calibrating ADC Offsets.", 247, 192, 1, UI_Plane2);
	Display::TEXTOUTxvbig("Remove all inputs.", 247, 212, 1, UI_Plane2);
	//Display::TEXTOUTxvbig("Can take up to 1 min.", 247, 232, 1, UI_Plane2);



	//backup settings
	lChannel_1_bak = Channel_1_Active; Channel_1_Active = 1;
	lChannel_2_bak = Channel_2_Active; Channel_2_Active = 1;
	lChannel_3_bak = Channel_3_Active; Channel_3_Active = 1;
	lChannel_4_bak = Channel_4_Active; Channel_4_Active = 1;

	
	//Wait until ADC is ready
	if (adc_started)
	{
		while (acq_ready->np_piodata == 0x01)
		{}
		adc_started = false;
	}

	//if no new data is available return	
	//if (ADC_Data_Available == 0) return;

	//reset availability flag	
	ADC_Data_Available = 0;

	Start_Record();

	//wait a little bit
	nr_delay(300);	

	//wait for ADC
	for(int timeout = 0;timeout < 100 && !ADC_Data_Available;timeout++)
	nr_delay(10);

	//if no new data is available send message
	if (ADC_Data_Available == 0)
	{ printf("\r\nNo new Data available for DAC-Calibration\r\n"); }

	//reset availability flag	
	ADC_Data_Available = 0;

	Stop_Record();

	data_adr->np_piodata = 0x01;


	data_adr->np_piodata = 0x00;
	
	
	//read signal and calibrate ADC-offsets
	if (Channel_1_Active)
	{
		//reset offsets
		ADC_Offset[0][0] = 0;
		ADC_Offset[0][1] = 0;
		ADC_Offset[0][2] = 0;
		ADC_Offset[0][3] = 0;
		ReadOut_Signal(1, buffer_addr & 0x3FFF);
		Calc_ADC_Offset(1);
	}
	
	if (Channel_2_Active)
	{ 
		//reset offsets
		ADC_Offset[1][0] = 0;
		ADC_Offset[1][1] = 0;
		ADC_Offset[1][2] = 0;
		ADC_Offset[1][3] = 0;
		ReadOut_Signal(2, buffer_addr & 0x3FFF);
		Calc_ADC_Offset(2);
	}	
	
	if (NumberOfChannels > 2)
	{	
		if (Channel_3_Active)
		{ 
			//reset offsets
			ADC_Offset[2][0] = 0;
			ADC_Offset[2][1] = 0;
			ADC_Offset[2][2] = 0;
			ADC_Offset[2][3] = 0;
			ReadOut_Signal(3, buffer_addr & 0x3FFF);
			Calc_ADC_Offset(3);
		}
	
		if (Channel_4_Active)
		{
			//reset offsets
			ADC_Offset[3][0] = 0;
			ADC_Offset[3][1] = 0;
			ADC_Offset[3][2] = 0;
			ADC_Offset[3][3] = 0;
			ReadOut_Signal(4, buffer_addr & 0x3FFF);
			Calc_ADC_Offset(4);
		}
	}	


	//restore settings
	Channel_1_Active = lChannel_1_bak;
	Channel_2_Active = lChannel_2_bak;
	Channel_3_Active = lChannel_3_bak;
	Channel_4_Active = lChannel_4_bak;


	//Save new values to flash
   	AMDFlash::Write_Protected_Flash();


	//restore BF  #001 
	CH1_Del_Correct = CH1_DelCorr_bak;
	CH2_Del_Correct = CH2_DelCorr_bak;
	CH3_Del_Correct = CH3_DelCorr_bak;
	CH4_Del_Correct = CH4_DelCorr_bak;


	//wait a little bit
	nr_delay(1000);	

	//Delete popup
	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
	Display::TEXTOUTxvbig("Calibrating ADC Offsets.", 247, 192, 0, UI_Plane2);
	Display::TEXTOUTxvbig("Remove all inputs.", 247, 212, 0, UI_Plane2);
	//Display::TEXTOUTxvbig("Still under construction", 247, 232, 0, UI_Plane2);

	Start_Record();



}

//##########################################################################################################################################################
//BF added
//Calibrate DACs for all channels and all voltage ranges
void Hardware::Calibrate_DAC_ZeroOffsets(void)
{
	volatile long buffer_addr = 0;	
	volatile long buffer_peak = 0;	
	volatile long buffer_written = 0;	
	volatile long buffer_adradd = 0;
	         long timebase_reg_bak;

	char lVoltRange;

	char lCH1_VR_bak,lCH2_VR_bak, lCH3_VR_bak, lCH4_VR_bak;

	char CH1_DelCorr_bak;
	char CH2_DelCorr_bak;
	char CH3_DelCorr_bak;
	char CH4_DelCorr_bak;

	char lChannel_1_bak, lChannel_2_bak, lChannel_3_bak, lChannel_4_bak;


	Stop_Record();


	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
	Display::TEXTOUTxvbig("Calibrating DAC Offsets.", 247, 192, 1, UI_Plane2);
	Display::TEXTOUTxvbig("Remove all inputs!", 247, 212, 1, UI_Plane2);
	Display::TEXTOUTxvbig("Working . . .", 247, 232, 1, UI_Plane2);


	// Backup actual values

	//backup BF  #001 
	CH1_DelCorr_bak = CH1_Del_Correct;
	CH2_DelCorr_bak = CH2_Del_Correct;
	CH3_DelCorr_bak = CH3_Del_Correct;
	CH4_DelCorr_bak = CH4_Del_Correct;


//	Channel delay correction must be reset for correct ADC adjustment  BF  #001 
	CH1_Del_Correct = 0;
	CH2_Del_Correct = 0;
	CH3_Del_Correct = 0;
	CH4_Del_Correct = 0;


	lCH1_VR_bak = Selected_Voltage_CH1;
	lCH2_VR_bak = Selected_Voltage_CH2;
	lCH3_VR_bak = Selected_Voltage_CH3;
	lCH4_VR_bak = Selected_Voltage_CH4;

	lChannel_1_bak = Channel_1_Active;
	lChannel_2_bak = Channel_2_Active;
	lChannel_3_bak = Channel_3_Active;
	lChannel_4_bak = Channel_4_Active;

	Channel_1_Active = true;
	Channel_2_Active = true;
	
	if (NumberOfChannels > 2)
	{
		Channel_3_Active = true;
		Channel_4_Active = true;
	}

	triggering_bak = triggering;
	triggering = 0;	
	
	Continius_bak  = Continius;
	SingleMode_bak = SingleMode;
	Continius  = 1;
	SingleMode = 0;

	//Wait until ADC is ready
	if (adc_started)
	{
		while (acq_ready->np_piodata == 0x01)
		{}
		adc_started = false;
	}
	
	timebase_reg_bak = timebase_reg;	//backup timebase
	timebase_reg = 0xFFFFFFFF;              //set real timebase 50ns (1GSa/s)

	for(lVoltRange = 9; lVoltRange <= 11; lVoltRange++)
	{

		Selected_Voltage_CH1 = lVoltRange;
		Selected_Voltage_CH2 = lVoltRange;
		Selected_Voltage_CH3 = lVoltRange;
		Selected_Voltage_CH4 = lVoltRange;



		if (Channel_1_Active) Hardware::SetSwitches(1, Selected_Voltage_CH1);
		if (Channel_2_Active) Hardware::SetSwitches(2, Selected_Voltage_CH2);
		if (Channel_3_Active) Hardware::SetSwitches(3, Selected_Voltage_CH3);
		if (Channel_4_Active) Hardware::SetSwitches(4, Selected_Voltage_CH4);

		SetupADC();


		//wait a little bit
		nr_delay(200);	
	
	
		//make several calibration runs to approximate zero
		for(int i=0; i<5 ; i++)
		{
			Start_Record();
		
			//wait for ADC
			for(int timeout = 0;timeout < 100 && !ADC_Data_Available;timeout++)
			nr_delay(10);
		
			//if no new data is available send error message
			if (ADC_Data_Available == 0)
			{ printf("\r\nError, no new Data available for DAC-Calibration\r\n");  }
		
			//reset availability flag	
			ADC_Data_Available = 0;
		
			Stop_Record();
		
			//read signal and calibrate DAC-offsets
			if (Channel_1_Active)
			{ 
				ReadOut_Signal(1, buffer_addr & 0x3FFF);

				switch(lVoltRange)
				{
					case 9: Calc_DAC_Correction(1, &DAC_Correction[0][0]); break;// 1 V
					case 10: Calc_DAC_Correction(1, &DAC_Correction[0][1]); break;//2 V
					case 11: Calc_DAC_Correction(1, &DAC_Correction[0][2]); break;//5 V	
				}
		
			}
			
			if (Channel_2_Active)
			{
				ReadOut_Signal(2, buffer_addr & 0x3FFF); 

				switch(lVoltRange)
				{
					case 9: Calc_DAC_Correction(2, &DAC_Correction[1][0]); break;// 1 V
					case 10: Calc_DAC_Correction(2, &DAC_Correction[1][1]); break;//2 V
					case 11: Calc_DAC_Correction(2, &DAC_Correction[1][2]); break;//5 V	
				}	
			}	
			
			if (NumberOfChannels > 2)
			{	
				if (Channel_3_Active)
				{ 
					ReadOut_Signal(3, buffer_addr & 0x3FFF);

					switch(lVoltRange)
					{
						case 9: Calc_DAC_Correction(3, &DAC_Correction[2][0]); break;// 1 V
						case 10: Calc_DAC_Correction(3, &DAC_Correction[2][1]); break;//2 V
						case 11: Calc_DAC_Correction(3, &DAC_Correction[2][2]); break;//5 V	
					}
				}
			
				if (Channel_4_Active)
				{ 
					ReadOut_Signal(4, buffer_addr & 0x3FFF); 

					switch(lVoltRange)
					{
						case 9: Calc_DAC_Correction(4, &DAC_Correction[3][0]); break;// 1 V
						case 10: Calc_DAC_Correction(4, &DAC_Correction[3][1]); break;//2 V
						case 11: Calc_DAC_Correction(4, &DAC_Correction[3][2]); break;//5 V	
					}
		
				}
			}	
	
			//activate new settings
			Rotary_Steps = 0;
			UserIF::ON_Zero_Channel_1();
			Rotary_Steps = 0;
			UserIF::ON_Zero_Channel_2();
		
			if (NumberOfChannels > 2)
			{		
				Rotary_Steps = 0;
				UserIF::ON_Zero_Channel_3();
				Rotary_Steps = 0;
				UserIF::ON_Zero_Channel_4();
			}
			
			//wait a little bit...
			nr_delay(50);	
		
		
		}//for loop end
	
	}	//voltage ranges

	//restore settings
	Selected_Voltage_CH1 = lCH1_VR_bak;
	Selected_Voltage_CH2 = lCH2_VR_bak;
	Selected_Voltage_CH3 = lCH3_VR_bak;
	Selected_Voltage_CH4 = lCH4_VR_bak;

	//restore timebase settings
	timebase_reg = tb_value[Selected_Timebase];

	triggering = triggering_bak;
	Continius  = Continius_bak;
	SingleMode = SingleMode_bak;

	SetSwitches(1, Selected_Voltage_CH1);
	SetSwitches(2, Selected_Voltage_CH2);
	SetSwitches(3, Selected_Voltage_CH3);
	SetSwitches(4, Selected_Voltage_CH4);


	SetupADC();	

	//activate settings
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();
	if (NumberOfChannels == 4)
	{	
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_3();
	
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();
	}

	Channel_1_Active = lChannel_1_bak;
	Channel_2_Active = lChannel_2_bak;
	Channel_3_Active = lChannel_3_bak;
	Channel_4_Active = lChannel_4_bak;

	//Save new values to flash
	AMDFlash::Write_Protected_Flash();

	//restore BF  #001 
	CH1_Del_Correct = CH1_DelCorr_bak;
	CH2_Del_Correct = CH2_DelCorr_bak;
	CH3_Del_Correct = CH3_DelCorr_bak;
	CH4_Del_Correct = CH4_DelCorr_bak;


	if(Continius) Start_Record();

	//Delete popup
	Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
	Display::TEXTOUTxvbig("Calibrating DAC Offsets.", 247, 192, 0, UI_Plane2);
	Display::TEXTOUTxvbig("Remove all inputs!", 247, 212, 0, UI_Plane2);
	Display::TEXTOUTxvbig("Working . . .", 247, 232, 0, UI_Plane2);


}

//##########################################################################################################################################################

void Hardware::FFT_Set_Channel(unsigned char backup)
{
	//Hardware::Stop_Record();

	if (backup)
	{
		//printf("- FFT Backup Channels\r\n");

		//Backup channel status
		Channel_1_Active_bak = Channel_1_Active;
		Channel_2_Active_bak = Channel_2_Active;
		if(NumberOfChannels == 4)
		{
			Channel_3_Active_bak = Channel_3_Active;	
			Channel_4_Active_bak = Channel_4_Active;
		}
		else
		{
			Channel_3_Active_bak = Channel_3_Active = 0;	
			Channel_4_Active_bak = Channel_4_Active = 0;
		}

		//Backup triggersetting and force auto mode	
		FFT_TriggerMode_bak = MenuStatus[MENU_TRIGGERMODE][0];	// remember the trigger setting
		MenuStatus[MENU_TRIGGERMODE][0] = 92;			//set trigger auto mode (or combi???)
		Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);	//BF #007
		TriggerLevelChanged = 1;
		TriggerModeChanged = 1;
		UpdateTrigger();
	}

	// which channel has to be active?
	switch(MenuStatus[MENU_FFT][0])	//FFT source
	{
		case 137: Channel_1_Active = 1;	Channel_2_Active = 0; Channel_3_Active = 0; Channel_4_Active = 0;
				Set_LED(0); Reset_LED(1); Reset_LED(2); Reset_LED(3); break;	
		case 138: Channel_1_Active = 0;	Channel_2_Active = 1; Channel_3_Active = 0; Channel_4_Active = 0;
				Reset_LED(0); Set_LED(1); Reset_LED(2); Reset_LED(3); break;	
		case 139: Channel_1_Active = 0;	Channel_2_Active = 0; Channel_3_Active = 1; Channel_4_Active = 0;
				Reset_LED(0); Reset_LED(1); Set_LED(2); Reset_LED(3); break;	
		case 140: Channel_1_Active = 0;	Channel_2_Active = 0; Channel_3_Active = 0; Channel_4_Active = 1;
				Reset_LED(0); Reset_LED(1); Reset_LED(2); Set_LED(3); break;	
	}

	Display::MenuPopupInit(29, MENU_FFT, 137);			// 29 FFT Source

	config_changed = true;						//Save new values to flash

	nr_delay(5);
	Send_LED();
	nr_delay(1);

	// Remove all Signals which where active before
	if(Channel_1_Active_bak)RemovePlane |= 0x01;
	if(Channel_2_Active_bak)RemovePlane |= 0x02;
	if(Channel_3_Active_bak)RemovePlane |= 0x04;
	if(Channel_4_Active_bak)RemovePlane |= 0x08;
	RemovePlane |= 0x1F;

	ClearPlanes();

	// force new output in statusbar
	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;

	Display::StatusUpdate();
	
	//if(!Continius)SingleMode = 1;
	//Hardware::Start_Record();

}
//##########################################################################################################################################################

void Hardware::FFT_Restore_Channels(void)
{
	//printf("- FFT Restore Channels\r\n");

	//Hardware::Stop_Record();

	//restore channel setting
	Channel_1_Active = Channel_1_Active_bak;
	Channel_2_Active = Channel_2_Active_bak;
	if(NumberOfChannels == 4)
	{
		Channel_3_Active = Channel_3_Active_bak;	
		Channel_4_Active = Channel_4_Active_bak;
	}
	else
	{
		Channel_3_Active_bak = Channel_3_Active = 0;	
		Channel_4_Active_bak = Channel_4_Active = 0;
	}


	// set LEDs
	if (Channel_1_Active) Set_LED(0);
	else Reset_LED(0);

	// set LEDs
	if (Channel_2_Active) Set_LED(1);
	else Reset_LED(1);

	// set LEDs
	if (Channel_3_Active) Set_LED(2);
	else Reset_LED(2);

	// set LEDs
	if (Channel_4_Active) Set_LED(3);
	else Reset_LED(3);

	nr_delay(5);
	Send_LED();
	nr_delay(1);

	// Remove Signals of inactive channels
	if(!Channel_1_Active)RemovePlane |= 0x01;
	if(!Channel_2_Active)RemovePlane |= 0x02;
	if(!Channel_3_Active)RemovePlane |= 0x04;
	if(!Channel_4_Active)RemovePlane |= 0x08;

	ClearPlanes();

	//restore triggermode
	MenuStatus[MENU_TRIGGERMODE][0] = FFT_TriggerMode_bak;	
	Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);	//BF #007
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	UpdateTrigger();


/*BF not needed, because it is done in RefreshScreen() 
	// force new output in statusbar
	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;
	
	Display::StatusUpdate();
*/



}
//##########################################################################################################################################################

void Hardware::Reset_To_Default(void)
{
	printf("- Reset to Default\r\n");

	Hardware::Stop_Record();

	Hardware::Set_Vars_Default();

   	Hardware::RecalcTimeParameters();
	
	UpdateChannel(1, 1);
	UpdateChannel(2, 1);

	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;	

	LED_ON[0] = 1;
	LED_ON[1] = 1;
	LED_ON[5] = 1;
	LED_ON[6] = 0;

	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();

	SetSwitches(1, Selected_Voltage_CH1);
	SetSwitches(2, Selected_Voltage_CH2);

	if (NumberOfChannels > 2)
	{

		UpdateChannel(3, 1);
		UpdateChannel(4, 1);

		VoltageChangedCh3 = 1;
		VoltageChangedCh4 = 1;
	
		LED_ON[2] = 1;
		LED_ON[3] = 1;
	
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_3();
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();

		SetSwitches(3, Selected_Voltage_CH3);
		SetSwitches(4, Selected_Voltage_CH4);

	}
	else
	{
		UpdateChannel(3, 0);
		UpdateChannel(4, 0);
	} 	

	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;	
	TriggerWayChanged = 1;
	TimebaseChanged = 1;
	TimeOffsetChanged = 1;
	MenuStatusChanged = 1;
	MenuAktive = 1;

	Cursor_Data_First_Draw = 0;
	Quick_Measure_First_Draw = 0;

	//Top area above the grid
	for (int lX = TOP_PLANE_MIN; lX < TOP_PLANE_MAX; lX++)
	{
		Buffer_UI2Plane[lX]   = 0;	
		UI_Plane2[lX]         = 0; 	
		UI_Plane3[lX]         = 0xFFFFFFFF;
	}

		
	//Grid area
	for (int lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
	{
		Buffer_Mark1Plane[lX] = 0;
		Marker_Plane1[lX]     = 0;
		Marker_Plane2[lX]     = 0;
		Buffer_UI2Plane[lX]   = 0;
		UI_Plane1[lX]         = 0; 		
		UI_Plane2[lX]         = 0; 	
		UI_Plane3[lX]         = 0;	
		UI_Plane4[lX]         = 0; 
		UI_Plane5[lX]         = 0;

	}	

	//Bottom area
	for (int lX = BOTT_PLANE_MIN; lX < BOTT_PLANE_MAX; lX++)
	{
		UI_Plane1[lX] = *(UI_Plane1_Flash + lX);
		Buffer_UI2Plane[lX]   = 0;
		UI_Plane2[lX]         = 0; 
		UI_Plane3[lX]         = 0xFFFFFFFF;
		UI_Plane4[lX]         = 0; 
		UI_Plane5[lX]         = 0;
	}

	// BF insert - init display
	Display::RefreshScreen();

	UpdateTrigger();
	Display::CALCPRETRIGGER();
	Display::DRAW_ALL_CURSOR();

	Display::DRAWSQUAREBUTTON(2, 1, 14, 16, btnPushed, btnDraw);					// Button
	Display::TEXTOUTvbig("1", 6, 4, 1, Channel_Plane1);						// Draw Voltage Text
//                    Display::TEXTOUTvbig("1", 6, 4, 1, Buffer_Plane1);				// Draw Voltage Text

	Display::DRAWSQUAREBUTTON(78, 1, 14, 16, btnPushed, btnDraw);					// Button
	Display::TEXTOUTvbig("2", 82, 4, 1, Channel_Plane2);						// Draw Voltage Text
//                    Display::TEXTOUTvbig("2", 82, 4, 1, Buffer_Plane2);				// Draw Voltage Text

	Display::StatusUpdate();

	if (NumberOfChannels > 2)
	{
		Display::DRAWSQUAREBUTTON(154, 1, 14, 16, btnPushed, btnDraw);				// Button
		Display::TEXTOUTvbig("3", 158, 4, 1, Channel_Plane3);					// Draw Voltage Text
//                        Display::TEXTOUTvbig("3", 158, 4, 1, Buffer_Plane3);				// Draw Voltage Text

		Display::DRAWSQUAREBUTTON(230, 1, 14, 16, btnPushed, btnDraw);				// Button		
		Display::TEXTOUTvbig("4", 234, 4, 1, Channel_Plane4);					// Draw Voltage Text
//                        Display::TEXTOUTvbig("4", 234, 4, 1, Buffer_Plane4);				// Draw Voltage Text
	}

	Display::MenuInit();	
	Display::DRAWSTATUS(6, 0);

	Send_LED();

	Hardware::Start_Record();

}
//##########################################################################################################################################################

void Hardware::Restore_From_Flash(void)
{
	printf("- Restore settings from flash\r\n");

	Hardware::Set_Vars_Default();

	Cursor_Data_First_Draw = 0;
	Quick_Measure_First_Draw = 0;

	AMDFlash::Read_Config_Flash();

	if (config_loaded == false){ Reset_To_Default(); config_changed = true; return;}	// emergency exit

	//new timebase settings
	timebase_reg = tb_value[Selected_Timebase];
    	Timebase_Idx = Selected_Timebase + SIGNALFaktor_idx;

	//prepare USTB-mode
	if (USTB_Mode != USTB_OFF) 	//timebase > 500mS/Div?
	{
		Signal::USTB_Clear_Buffer();	//clear all buffers
		Reset_Timer2();
	}

	//prepare FFT-mode
	if(FFT_Mode != FFT_OFF)
	{ Signal::FFT_BuildTrigoTables(); }

	//initialize channels	
	if (Channel_1_Active)
	{ Hardware::UpdateChannel(1, 1); }
	else
    	{
		Hardware::UpdateChannel(1, 0);
		//Channel_1_Active_Old = 1;
		VoltageChangedCh1 = 1;
    	}

	if (Channel_2_Active)
	{ Hardware::UpdateChannel(2, 1); }
	else
    	{
		Hardware::UpdateChannel(2, 0);
		//Channel_2_Active_Old = 1;
		VoltageChangedCh2 = 1;
    	}

	if (Channel_3_Active)
	{ Hardware::UpdateChannel(3, 1); }
	else
    	{
		Hardware::UpdateChannel(3, 0);
		//Channel_3_Active_Old = 1;
		VoltageChangedCh3 = 1;
    	}

	if (Channel_4_Active)
	{ Hardware::UpdateChannel(4, 1); }
	else
    	{
		Hardware::UpdateChannel(4, 0);
		//Channel_4_Active_Old = 1;
		VoltageChangedCh4 = 1;
    	}


	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_1();
	Hardware::SetSwitches(1, Selected_Voltage_CH1);
	Hardware::SetDacOffset(1);
	Hardware::SetCHDacOffset(1);
	
	Rotary_Steps = 0;
	UserIF::ON_Zero_Channel_2();
	Hardware::SetSwitches(2, -1);
	Hardware::SetDacOffset(2);
	Hardware::SetCHDacOffset(2);
	
	if (NumberOfChannels > 2)
	{
        	Rotary_Steps = 0;
        	UserIF::ON_Zero_Channel_3();
		Hardware::SetSwitches(3, Selected_Voltage_CH3);
		Hardware::SetDacOffset(3);
		Hardware::SetCHDacOffset(3);
		
		Rotary_Steps = 0;
		UserIF::ON_Zero_Channel_4();
		Hardware::SetSwitches(4, Selected_Voltage_CH4);
		Hardware::SetDacOffset(4);
		Hardware::SetCHDacOffset(4);
	}

	Hardware::Send_LED();	

	Display::MenuInit();		//BF #005

	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;	
	TriggerWayChanged = 1;
	TimebaseChanged = 1;
	TimeOffsetChanged = 1;
	MenuStatusChanged = 1;
	MenuAktive = 1;
	Menu_Changed = 1;

	Cursor_Data_First_Draw = 0;
	Quick_Measure_First_Draw = 0;

	Hardware::RecalcTimeParameters();

	Display::CALCPRETRIGGER();

	//ON_Timebase();

	if (Memory_Window_visible) 
	Display::DRAWMEMORY(1, 0, 0);		//close memory window

	// Draw Startscreen only when restart is done
	if(!first_start)
	{


		//Top area above the grid
		for (int lX = TOP_PLANE_MIN; lX < TOP_PLANE_MAX; lX++)
		{
			Buffer_UI2Plane[lX]   = 0;	
			UI_Plane2[lX]         = 0; 	
			UI_Plane3[lX]         = 0xFFFFFFFF;
		}
	
			
		//Grid area
		for (int lX = GRID_PLANE_MIN; lX < GRID_PLANE_MAX; lX++)
		{
			Buffer_Mark1Plane[lX] = 0;
			Marker_Plane1[lX]     = 0;
			Marker_Plane2[lX]     = 0;
			Buffer_UI2Plane[lX]   = 0;
			UI_Plane1[lX]         = 0; 		
			UI_Plane2[lX]         = 0; 	
			UI_Plane3[lX]         = 0;	
			UI_Plane4[lX]         = 0; 
			UI_Plane5[lX]         = 0;

		}	
	
		//Bottom area
		for (int lX = BOTT_PLANE_MIN; lX < BOTT_PLANE_MAX; lX++)
		{
			UI_Plane1[lX] = *(UI_Plane1_Flash + lX);
			Buffer_UI2Plane[lX]   = 0;
			UI_Plane2[lX]         = 0; 
			UI_Plane3[lX]         = 0xFFFFFFFF;
			UI_Plane4[lX]         = 0; 
			UI_Plane5[lX]         = 0;
		}


		Display::RefreshScreen();
		Display::DRAW_ALL_CURSOR();
	}
	UpdateTrigger();	//-> in Update channel - delete here???

	first_start = false; 

	printf("- Restore settings from flash           - done\r\n");


}
//##########################################################################################################################################################
//BF new Startup initialization
void Hardware::Start_Up(void)
{

	//Display::REMOVE_SPLASH();
	Display::DrawInitialScreen();	//Display::RefreshScreen();???
	//Splash_drawed = false;

//	channel delay correction -> will be loaded from flash but may be damaged because of old values
//	check for correct value range - else set to default
	if(CH1_Del_Correct > 16 || CH1_Del_Correct < 0){CH1_Del_Correct = 0;}
	if(CH2_Del_Correct > 16 || CH2_Del_Correct < 0){CH2_Del_Correct = 0;}
	if(CH3_Del_Correct > 16 || CH3_Del_Correct < 0){CH3_Del_Correct = 0;}
	if(CH4_Del_Correct > 16 || CH4_Del_Correct < 0){CH4_Del_Correct = 0;}


	// preset flash if new developer subversion
	//if(FlashPreset != (char)tc_dev_subversion)
	if(FlashPreset != 0xAA)
	{
		printf("Start up: Presetting Flash\r\n");

		//ADC registers to factory setting
		MenuStatus[MENU_HARDWARE][0] = 223;
		Display::MenuPopupInit(37, MENU_HARDWARE, 223);
		AMDFlash::ReadProtReg();

		//Pre Amp Gain to factory setting
		GainIdx = 0;
		MenuStatus[MENU_HARDWARE][1] = 230;		//BF #004
		Display::MenuPopupInit(38, MENU_HARDWARE, 230);

		OS_CompMode = 1;				//BF #006
		MenuStatus[MENU_QUICKPRINT][5] = 187;		//OS-Version of Screenshot
		Display::MenuPopupInit(39, MENU_QUICKPRINT, 186);

		FFT_grid = 0;

	//	set channel delay to default
		CH1_Del_Correct = 0;
		CH2_Del_Correct = 0;
		CH3_Del_Correct = 0;
		CH4_Del_Correct = 0;
	
	//      init extended utility menu
		MenuStatus[MENU_EXTUTILS][0] = 203;
		MenuStatus[MENU_EXTUTILS][1] = 203;
	
		if (NumberOfChannels == 4)
		{
			MenuStatus[MENU_EXTUTILS][2] = 203;
			MenuStatus[MENU_EXTUTILS][3] = 203;
		}
		else
		{
			MenuStatus[MENU_EXTUTILS][2] = 246;	// for 2 Channel version set inactive
			MenuStatus[MENU_EXTUTILS][3] = 246;	// for 2 Channel version set inactive
		}

		Display::MenuPopupInit(33, MENU_EXTUTILS, 203); 
		Display::MenuPopupInit(34, MENU_EXTUTILS, 203); 
		Display::MenuPopupInit(35, MENU_EXTUTILS, 203);
		Display::MenuPopupInit(36, MENU_EXTUTILS, 203); 


		MenuStatus[MENU_TRIGGERMODE][0] = 92;		//set new trigger auto mode
		Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);

		MenuStatus[MENU_TRIGGEREDGE][1] = 137;		//trigger source is channel 1
		MenuStatus[MENU_TRIGGEREDGE][2] = 246;		//ext. trigger popup is inactive
		MenuStatus[MENU_TRIGGEREDGE][3] = 246;		//TV trigger popup is inactive

		MenuPopupStatus[8][0] = 3;	              	//BF popup for external trigger
		MenuPopupStatus[8][1] = 2;
		MenuPopupStatus[8][2] = 2;

		MenuPopupStatus[11][0] = 3;              	//BF popup for TV trigger
		MenuPopupStatus[11][1] = 2;

		//FlashPreset = (char)tc_dev_subversion;
		FlashPreset = 0xAA;
		//AMDFlash::Write_Config_Flash();

		DAC_Correction[0][0] = 100; 	//channel 1
		DAC_Correction[0][1] = 130; 
		DAC_Correction[0][2] = 100; 

		DAC_Correction[1][0] = 100; 	//channel 2
		DAC_Correction[1][1] = 130; 
		DAC_Correction[1][2] = 100; 

		DAC_Correction[2][0] = 100; 	//channel 3
		DAC_Correction[2][1] = 130; 
		DAC_Correction[2][2] = 100; 

		DAC_Correction[3][0] = 100; 	//channel 4
		DAC_Correction[3][1] = 130; 
		DAC_Correction[3][2] = 100; 

		ADC_Offset[0][0] = 0;
		ADC_Offset[0][1] = 0;
		ADC_Offset[0][2] = 0;
		ADC_Offset[0][3] = 0;	
		
		ADC_Offset[1][0] = 0;
		ADC_Offset[1][1] = 0;
		ADC_Offset[1][2] = 0;
		ADC_Offset[1][3] = 0;
	
		ADC_Offset[2][0] = 0;
		ADC_Offset[2][1] = 0;
		ADC_Offset[2][2] = 0;
		ADC_Offset[2][3] = 0;
	
		ADC_Offset[3][0] = 0;
		ADC_Offset[3][1] = 0;
		ADC_Offset[3][2] = 0;
		ADC_Offset[3][3] = 0;

		AMDFlash::Write_Protected_Flash();

	} //preset end

	config_changed = 2;
	AMDFlash::Write_Config_Flash();

	TimebaseChanged = 1;
	TimeOffsetChanged = 1;
	
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	TriggerWayChanged = 1;
	
	VoltageChangedCh1 = 1;	
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;		
		
	Display::StatusUpdate();
	
	CursorChanged = 3;
	Cursor_Data_First_Draw = 1;
	Display::DRAWCURSORDATA(0);

	Quick_Measure_First_Draw = 1;
	Display::DRAWQMDATA(0); 	

	Display::DRAW_ALL_CURSOR();

	if (Continius) Hardware::Start_Record();
	

}

